/*
 * Decompiled with CFR 0.152.
 */
package svenhjol.charm.world.item;

import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.renderer.color.IItemColor;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.IItemPropertyGetter;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.fml.common.Optional;
import svenhjol.charm.world.feature.Moonstone;
import svenhjol.meson.MesonItem;
import svenhjol.meson.helper.ItemNBTHelper;
import svenhjol.meson.helper.TextHelper;
import svenhjol.meson.iface.IMesonItem;
import vazkii.quark.api.ICustomEnchantColor;

@Optional.Interface(iface="vazkii.quark.api.ICustomEnchantColor", modid="quark")
public class ItemMoonstone
extends MesonItem
implements ICustomEnchantColor,
IMesonItem.IItemColorHandler,
IMesonItem.IItemCustomModel {
    private static final String SX = "charmPosX";
    private static final String SY = "charmPosY";
    private static final String SZ = "charmPosZ";
    private static final String SD = "charmDim";
    private static final String GLOW = "charmGlow";
    private static final String TICK = "charmTick";
    private static final String ORIGIN = "charmOrigin";

    public ItemMoonstone() {
        super("moonstone");
        this.func_77637_a(CreativeTabs.field_78040_i);
        this.func_77625_d(1);
        this.func_77627_a(true);
        this.func_185043_a(new ResourceLocation("align"), new IItemPropertyGetter(){

            public float func_185085_a(ItemStack stack, @Nullable World world, @Nullable EntityLivingBase entityIn) {
                BlockPos sPos;
                EntityLivingBase entity;
                if (entityIn == null && !stack.func_82839_y()) {
                    return 0.0f;
                }
                boolean hasEntity = entityIn != null;
                Object object = entity = hasEntity ? entityIn : stack.func_82836_z();
                if (world == null) {
                    world = ((Entity)Objects.requireNonNull(entity)).field_70170_p;
                }
                if ((sPos = ItemMoonstone.getStonePos(stack)) == null) {
                    return 0.0f;
                }
                if (entity == null) {
                    return 0.0f;
                }
                int sDim = ItemMoonstone.getStoneDim(stack);
                int eDim = world.field_73011_w.getDimension();
                int sx = sPos.func_177958_n();
                int sz = sPos.func_177952_p();
                int ex = MathHelper.func_76128_c((double)entity.field_70165_t);
                int ez = MathHelper.func_76128_c((double)entity.field_70161_v);
                if (sDim == -1 && eDim != -1) {
                    sx = (int)((float)sx * 8.0f);
                    sz = (int)((float)sz * 8.0f);
                } else if (eDim == -1 && sDim != -1) {
                    sx = (int)((float)sx / 8.0f);
                    sz = (int)((float)sz / 8.0f);
                }
                boolean alignedx = sx == ex;
                boolean alignedz = sz == ez;
                ItemNBTHelper.setBoolean(stack, ItemMoonstone.ORIGIN, alignedx && alignedz);
                return this.glow(world, stack, alignedx || alignedz);
            }

            private int glow(World world, ItemStack stack, boolean aligned) {
                int glow = ItemNBTHelper.getInt(stack, ItemMoonstone.GLOW, 0);
                long tick = ItemNBTHelper.getLong(stack, ItemMoonstone.TICK, 0L);
                if (world.func_82737_E() != tick) {
                    tick = world.func_82737_E();
                    if (aligned && glow <= 6) {
                        ++glow;
                    } else if (!aligned && glow >= 0) {
                        --glow;
                    }
                }
                ItemNBTHelper.setLong(stack, ItemMoonstone.TICK, tick);
                ItemNBTHelper.setInt(stack, ItemMoonstone.GLOW, glow);
                return glow;
            }
        });
    }

    @Override
    public String getModId() {
        return "charm";
    }

    public boolean func_77636_d(ItemStack stack) {
        return Moonstone.glowOnOrigin && ItemNBTHelper.getBoolean(stack, ORIGIN, false);
    }

    @Override
    public IItemColor getItemColor() {
        return (stack, tintIndex) -> {
            int meta = stack.func_77960_j();
            return EnumDyeColor.func_176766_a((int)(15 - meta)).func_193350_e();
        };
    }

    public void func_150895_a(CreativeTabs tab, NonNullList<ItemStack> items) {
        if (this.func_194125_a(tab)) {
            EnumDyeColor[] values = EnumDyeColor.values();
            for (int i = 0; i < values.length; ++i) {
                items.add((Object)new ItemStack((Item)this, 1, i));
            }
        }
    }

    @Override
    public void registerModels(Item item) {
        for (int i = 0; i < 16; ++i) {
            if (item == null || item.getRegistryName() == null) continue;
            ModelResourceLocation loc = new ModelResourceLocation(item.getRegistryName(), "inventory");
            ModelLoader.setCustomModelResourceLocation((Item)item, (int)i, (ModelResourceLocation)loc);
        }
    }

    public int getEnchantEffectColor(ItemStack stack) {
        int col = 0xFFFFFF;
        if (ItemNBTHelper.getBoolean(stack, ORIGIN, false)) {
            col = EnumDyeColor.func_176766_a((int)(15 - stack.func_77960_j())).func_193350_e();
        }
        return col - 328965;
    }

    public static BlockPos getStonePos(ItemStack stack) {
        if (stack.func_77942_o()) {
            int x = ItemNBTHelper.getInt(stack, SX, 0);
            int y = ItemNBTHelper.getInt(stack, SY, 0);
            int z = ItemNBTHelper.getInt(stack, SZ, 0);
            return new BlockPos(x, y, z);
        }
        return null;
    }

    public static int getStoneDim(ItemStack stack) {
        if (stack.func_77942_o()) {
            return ItemNBTHelper.getInt(stack, SD, 0);
        }
        return 0;
    }

    public static ItemStack setStonePos(ItemStack stack, BlockPos pos) {
        ItemNBTHelper.setInt(stack, SX, pos.func_177958_n());
        ItemNBTHelper.setInt(stack, SY, pos.func_177956_o());
        ItemNBTHelper.setInt(stack, SZ, pos.func_177952_p());
        return stack;
    }

    public static ItemStack setStoneDim(ItemStack stack, int dim) {
        ItemNBTHelper.setInt(stack, SD, dim);
        return stack;
    }

    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        if (!Moonstone.showInformation) {
            return;
        }
        int dim = ItemMoonstone.getStoneDim(stack);
        BlockPos pos = ItemMoonstone.getStonePos(stack);
        TextFormatting color = TextHelper.getTextFormattingByDyeDamage(15 - EnumDyeColor.func_176766_a((int)stack.func_77960_j()).func_176767_b());
        if (pos != null) {
            String x = String.valueOf(pos.func_177958_n());
            String y = String.valueOf(pos.func_177956_o());
            String z = String.valueOf(pos.func_177952_p());
            tooltip.add(color + x + " " + y + " " + z + ". " + I18n.func_135052_a((String)"dimension", (Object[])new Object[0]) + " " + dim);
        }
    }
}

