/*
 * Decompiled with CFR 0.152.
 */
package svenhjol.charm.smithing.feature;

import java.util.HashMap;
import java.util.Map;
import net.minecraft.init.Items;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemAxe;
import net.minecraft.item.ItemHoe;
import net.minecraft.item.ItemPickaxe;
import net.minecraft.item.ItemSpade;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemSword;
import net.minecraftforge.event.AnvilUpdateEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import svenhjol.meson.Feature;

public class DecreaseRepairCost
extends Feature {
    public static Map<Item, Class<? extends Item>> tools = new HashMap<Item, Class<? extends Item>>();
    public static Map<Item, EntityEquipmentSlot> armor = new HashMap<Item, EntityEquipmentSlot>();
    public static int decreaseCost;
    public static int xpCost;

    @Override
    public String getDescription() {
        return "Combine an item with its golden version on an anvil to reduce the original item's repair cost.";
    }

    @Override
    public void configure() {
        super.configure();
        decreaseCost = this.propInt("Decrease repair amount", "Amount that a golden item will decrease another item's repair cost.", 2);
        xpCost = this.propInt("XP cost", "Amount of XP (levels) to use a golden item to decrease another item's repair cost.", 0);
    }

    @Override
    public void preInit(FMLPreInitializationEvent event) {
        super.preInit(event);
        tools.put(Items.field_151005_D, ItemPickaxe.class);
        tools.put(Items.field_151011_C, ItemSpade.class);
        tools.put(Items.field_151006_E, ItemAxe.class);
        tools.put(Items.field_151013_M, ItemHoe.class);
        tools.put(Items.field_151010_B, ItemSword.class);
        armor.put((Item)Items.field_151169_ag, EntityEquipmentSlot.HEAD);
        armor.put((Item)Items.field_151171_ah, EntityEquipmentSlot.CHEST);
        armor.put((Item)Items.field_151149_ai, EntityEquipmentSlot.LEGS);
        armor.put((Item)Items.field_151151_aj, EntityEquipmentSlot.FEET);
    }

    @SubscribeEvent
    public void onAnvilUpdate(AnvilUpdateEvent event) {
        boolean canDecrease;
        ItemStack in = event.getLeft();
        ItemStack combine = event.getRight();
        if (in.func_190926_b() || combine.func_190926_b()) {
            return;
        }
        Item i = in.func_77973_b();
        Item c = combine.func_77973_b();
        if (tools.get(c) == null && armor.get(c) == null) {
            return;
        }
        if (i instanceof ItemArmor) {
            canDecrease = ((ItemArmor)i).field_77881_a == armor.get(c);
        } else {
            boolean bl = canDecrease = i.getClass() == tools.get(c);
        }
        if (!canDecrease) {
            return;
        }
        ItemStack out = in.func_77946_l();
        if (in.func_77978_p() != null && !in.func_77978_p().func_82582_d()) {
            int cost = in.func_77978_p().func_74762_e("RepairCost");
            out.func_82841_c(Math.max(0, cost - decreaseCost));
        }
        event.setCost(xpCost);
        event.setOutput(out);
    }

    @Override
    public boolean hasSubscriptions() {
        return true;
    }
}

