/*
 * Decompiled with CFR 0.152.
 */
package meldexun.entityculling.util;

import javax.annotation.Nullable;
import meldexun.entityculling.EntityCulling;
import meldexun.entityculling.integration.CubicChunks;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.WorldType;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.storage.ExtendedBlockStorage;

public class CachedBlockAccess
implements IBlockAccess {
    private World level;
    private Chunk cachedChunk;
    private ExtendedBlockStorage cachedSection;

    public void setupCached(World level) {
        this.level = level;
        this.cachedChunk = null;
        this.cachedSection = null;
    }

    public void clearCache() {
        this.level = null;
        this.cachedChunk = null;
        this.cachedSection = null;
    }

    private Chunk getChunk(int chunkX, int chunkZ) {
        if (this.cachedChunk == null || this.cachedChunk.field_76635_g != chunkX || this.cachedChunk.field_76647_h != chunkZ) {
            this.cachedChunk = this.level.func_72964_e(chunkX, chunkZ);
            this.cachedSection = null;
        }
        return this.cachedChunk;
    }

    @Nullable
    private ExtendedBlockStorage getChunkSection(int chunkX, int chunkY, int chunkZ) {
        if (EntityCulling.isCubicChunksInstalled) {
            this.cachedSection = CubicChunks.getBlockStorage(this.level, chunkX, chunkY, chunkZ);
        } else {
            Chunk chunk = this.getChunk(chunkX, chunkZ);
            if (this.cachedSection == null || this.cachedSection.func_76662_d() >> 4 != chunkY) {
                this.cachedSection = chunk.func_76587_i()[chunkY];
            }
        }
        return this.cachedSection;
    }

    public TileEntity func_175625_s(BlockPos pos) {
        throw new UnsupportedOperationException();
    }

    public int func_175626_b(BlockPos pos, int lightValue) {
        throw new UnsupportedOperationException();
    }

    public IBlockState func_180495_p(BlockPos pos) {
        if (this.level.func_189509_E(pos)) {
            return Blocks.field_150350_a.func_176223_P();
        }
        ExtendedBlockStorage section = this.getChunkSection(pos.func_177958_n() >> 4, pos.func_177956_o() >> 4, pos.func_177952_p() >> 4);
        if (section == null) {
            return Blocks.field_150350_a.func_176223_P();
        }
        return section.func_177485_a(pos.func_177958_n() & 0xF, pos.func_177956_o() & 0xF, pos.func_177952_p() & 0xF);
    }

    public boolean func_175623_d(BlockPos pos) {
        throw new UnsupportedOperationException();
    }

    public Biome func_180494_b(BlockPos pos) {
        throw new UnsupportedOperationException();
    }

    public int func_175627_a(BlockPos pos, EnumFacing direction) {
        throw new UnsupportedOperationException();
    }

    public WorldType func_175624_G() {
        throw new UnsupportedOperationException();
    }

    public boolean isSideSolid(BlockPos pos, EnumFacing side, boolean _default) {
        throw new UnsupportedOperationException();
    }
}

