/*
 * Decompiled with CFR 0.152.
 */
package snownee.kiwi.crafting.input;

import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import snownee.kiwi.crafting.input.ProcessingInput;

public class RegularItemStackInput
implements ProcessingInput {
    private final Item item;
    private final int meta;
    private final int size;

    public static RegularItemStackInput of(@Nonnull ItemStack instance) {
        return instance.func_190926_b() ? RegularItemStackInput.of(Items.field_190931_a) : new RegularItemStackInput(instance.func_77973_b(), instance.func_77960_j(), instance.func_190916_E());
    }

    public static RegularItemStackInput of(@Nonnull Block block) {
        Item actualForm = Item.func_150898_a((Block)block);
        if (actualForm == Items.field_190931_a) {
            throw new IllegalArgumentException("Block %s does not have item form");
        }
        return RegularItemStackInput.of(actualForm);
    }

    public static RegularItemStackInput of(@Nonnull Block block, int meta) {
        Item actualForm = Item.func_150898_a((Block)block);
        if (actualForm == Items.field_190931_a) {
            throw new IllegalArgumentException("Block %s does not have item form");
        }
        return RegularItemStackInput.of(actualForm, meta);
    }

    public static RegularItemStackInput of(@Nonnull Item item) {
        return new RegularItemStackInput(item, 0, 1);
    }

    public static RegularItemStackInput of(@Nonnull Item item, int meta) {
        return new RegularItemStackInput(item, meta, 1);
    }

    protected RegularItemStackInput(@Nonnull Item item, int meta, int size) {
        this.item = item;
        this.meta = meta;
        this.size = size;
    }

    @Override
    public List<ItemStack> examples() {
        return this.isEmpty() ? Collections.emptyList() : Collections.singletonList(new ItemStack(this.item, this.size, this.meta));
    }

    @Override
    public boolean matches(ItemStack stack) {
        return stack.func_190926_b() ? this.isEmpty() : stack.func_77973_b() == this.item && stack.func_77960_j() == this.meta && stack.func_190916_E() >= this.size;
    }

    @Override
    public int count() {
        return this.isEmpty() ? 0 : this.size;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RegularItemStackInput that = (RegularItemStackInput)o;
        if (this.meta != that.meta) {
            return false;
        }
        if (this.size != that.size) {
            return false;
        }
        return this.item == that.item;
    }

    public int hashCode() {
        int result = this.item.hashCode();
        result = 31 * result + this.meta;
        result = 31 * result + this.size;
        return result;
    }

    @Override
    public boolean isEmpty() {
        return this.item == Items.field_190931_a;
    }
}

