/*
 * Decompiled with CFR 0.152.
 */
package snownee.kiwi;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.Map;
import java.util.Set;
import net.minecraft.client.Minecraft;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.config.Config;
import net.minecraftforge.common.config.ConfigManager;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.ModContainer;
import net.minecraftforge.fml.common.discovery.ASMDataTable;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.logging.log4j.Logger;
import snownee.kiwi.IModule;
import snownee.kiwi.KiwiConfig;
import snownee.kiwi.KiwiManager;
import snownee.kiwi.KiwiModule;
import snownee.kiwi.block.IModBlock;
import snownee.kiwi.client.AdvancedFontRenderer;
import snownee.kiwi.item.IModItem;
import snownee.kiwi.potion.PotionMod;

@Mod(modid="kiwi", name="Kiwi", version="0.5.3.32", acceptedMinecraftVersions="[1.12, 1.13)")
public class Kiwi {
    public static final String MODID = "kiwi";
    public static final String NAME = "Kiwi";
    private static final Kiwi INSTANCE = new Kiwi();
    public static Logger logger;

    @Mod.InstanceFactory
    public static Kiwi getInstance() {
        return INSTANCE;
    }

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) throws IllegalArgumentException, IllegalAccessException, InstantiationException, ClassNotFoundException {
        logger = event.getModLog();
        ASMDataTable table = event.getAsmData();
        Set allModules = table.getAll(KiwiModule.class.getName());
        logger.info("Processing " + allModules.size() + " KiwiModule annotations");
        Map map = Loader.instance().getIndexedModList();
        for (ASMDataTable.ASMData aSMData : allModules) {
            String dependency;
            Boolean optional;
            String modid = (String)aSMData.getAnnotationInfo().get("modid");
            String name = (String)aSMData.getAnnotationInfo().get("name");
            if (name == null) {
                name = modid;
            }
            if ((optional = (Boolean)aSMData.getAnnotationInfo().get("optional")) == Boolean.TRUE) {
                Boolean enabled = KiwiConfig.MODULES.modules.get(modid + ":" + name);
                if (enabled == null) {
                    Boolean disabledByDefault = (Boolean)aSMData.getAnnotationInfo().get("disabledByDefault");
                    if (disabledByDefault == null) {
                        disabledByDefault = false;
                    }
                    KiwiConfig.MODULES.modules.put(modid + ":" + name, disabledByDefault == false);
                    if (disabledByDefault.booleanValue()) {
                        continue;
                    }
                } else if (enabled == Boolean.FALSE) continue;
            }
            if ((dependency = (String)aSMData.getAnnotationInfo().get("dependency")) != null && !Loader.isModLoaded((String)dependency)) continue;
            Class<?> asmClass = Class.forName(aSMData.getClassName());
            Loader.instance().setActiveModContainer((ModContainer)map.get(modid));
            IModule instance = asmClass.asSubclass(IModule.class).newInstance();
            KiwiManager.addInstance(new ResourceLocation(modid, name), instance);
            Loader.instance().setActiveModContainer(null);
        }
        ConfigManager.sync((String)MODID, (Config.Type)Config.Type.INSTANCE);
        for (Map.Entry entry : KiwiManager.MODULES.entrySet()) {
            int countBlock = 0;
            int countItem = 0;
            String modid = ((ResourceLocation)entry.getKey()).func_110624_b();
            String name = ((ResourceLocation)entry.getKey()).func_110623_a();
            for (Field field : ((IModule)entry.getValue()).getClass().getFields()) {
                Object o;
                int mods = field.getModifiers();
                if (!Modifier.isPublic(mods) || !Modifier.isStatic(mods) || !Modifier.isFinal(mods) || (o = field.get(null)) == null) continue;
                if (o instanceof IModBlock) {
                    KiwiManager.BLOCKS.put((IModBlock)o, modid);
                    ++countBlock;
                    continue;
                }
                if (o instanceof IModItem) {
                    KiwiManager.ITEMS.put((IModItem)o, modid);
                    ++countItem;
                    continue;
                }
                if (!(o instanceof PotionMod)) continue;
                KiwiManager.POTIONS.put((PotionMod)((Object)o), modid);
            }
            logger.info("[{}:{}]: Block: {}, Item: {}", (Object)modid, (Object)name, (Object)countBlock, (Object)countItem);
        }
        Loader.instance().setActiveModContainer(null);
        KiwiManager.MODULES.values().forEach(IModule::preInit);
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent event) {
        if (KiwiConfig.GENERAL.replaceDefaultFontRenderer && event.getSide() == Side.CLIENT) {
            Kiwi.replaceFontRenderer();
        }
        Loader.instance().setActiveModContainer(null);
        KiwiManager.MODULES.values().forEach(IModule::init);
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent event) {
        Loader.instance().setActiveModContainer(null);
        KiwiManager.MODULES.values().forEach(IModule::postInit);
        KiwiManager.BLOCKS.clear();
        KiwiManager.BLOCKS = null;
        KiwiManager.ITEMS.clear();
        KiwiManager.ITEMS = null;
        KiwiManager.POTIONS.clear();
        KiwiManager.POTIONS = null;
    }

    public static boolean isOptionalModuleLoaded(String modid, String name) {
        return Kiwi.isLoaded(new ResourceLocation(modid, name));
    }

    public static boolean isLoaded(ResourceLocation module) {
        return KiwiManager.ENABLED_MODULES.contains(module);
    }

    @SideOnly(value=Side.CLIENT)
    private static void replaceFontRenderer() {
        Minecraft.func_71410_x().field_71466_p = AdvancedFontRenderer.INSTANCE;
    }
}

