/*
 * Decompiled with CFR 0.152.
 */
package com.lycanitesmobs.core.network;

import com.lycanitesmobs.core.entity.ExtendedPlayer;
import com.lycanitesmobs.core.pets.SummonSet;
import io.netty.buffer.ByteBuf;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.fml.relauncher.Side;

public class MessageSummonSet
implements IMessage {
    public byte summonSetID;
    public int subpsecies;
    public int variant;
    public String summonType;
    public byte behaviour;

    public MessageSummonSet() {
    }

    public MessageSummonSet(ExtendedPlayer playerExt, byte summonSetID) {
        this.summonSetID = summonSetID;
        this.summonType = playerExt.getSummonSet((int)summonSetID).summonType;
        this.subpsecies = playerExt.getSummonSet((int)summonSetID).subspecies;
        this.variant = playerExt.getSummonSet((int)summonSetID).variant;
        this.behaviour = playerExt.getSummonSet(summonSetID).getBehaviourByte();
    }

    public static void onMessage(MessageSummonSet message, MessageContext ctx, EntityPlayer player) {
        if (ctx.side == Side.SERVER) {
            ExtendedPlayer playerExt = ExtendedPlayer.getForPlayer(player);
            SummonSet summonSet = playerExt.getSummonSet(message.summonSetID);
            summonSet.readFromPacket(message.summonType, message.subpsecies, message.variant, message.behaviour);
        } else {
            ExtendedPlayer playerExt = ExtendedPlayer.getForPlayer(player);
            if (playerExt == null) {
                return;
            }
            SummonSet summonSet = playerExt.getSummonSet(message.summonSetID);
            summonSet.readFromPacket(message.summonType, message.subpsecies, message.variant, message.behaviour);
        }
    }

    public void fromBytes(ByteBuf buf) {
        PacketBuffer packet = new PacketBuffer(buf);
        this.summonSetID = packet.readByte();
        this.summonType = packet.func_150789_c(256);
        this.subpsecies = packet.readInt();
        this.variant = packet.readInt();
        this.behaviour = packet.readByte();
    }

    public void toBytes(ByteBuf buf) {
        PacketBuffer packet = new PacketBuffer(buf);
        packet.writeByte((int)this.summonSetID);
        packet.func_180714_a(this.summonType);
        packet.writeInt(this.subpsecies);
        packet.writeInt(this.variant);
        packet.writeByte((int)this.behaviour);
    }
}

