/*
 * Decompiled with CFR 0.152.
 */
package com.lycanitesmobs.core.item.special;

import com.lycanitesmobs.client.localisation.LanguageManager;
import com.lycanitesmobs.core.entity.ExtendedPlayer;
import com.lycanitesmobs.core.entity.TameableCreatureEntity;
import com.lycanitesmobs.core.info.CreatureInfo;
import com.lycanitesmobs.core.info.ModInfo;
import com.lycanitesmobs.core.item.ItemBase;
import com.lycanitesmobs.core.pets.PetEntry;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.world.World;

public class ItemSoulstone
extends ItemBase {
    public ItemSoulstone(ModInfo group) {
        this.itemName = "soulstone";
        this.modInfo = group;
        this.setup();
    }

    @Override
    public void func_77663_a(ItemStack itemStack, World world, Entity entity, int par4, boolean par5) {
        super.func_77663_a(itemStack, world, entity, par4, par5);
    }

    @Override
    public boolean onItemRightClickOnEntity(EntityPlayer player, Entity entity, ItemStack itemStack) {
        ExtendedPlayer playerExt = ExtendedPlayer.getForPlayer(player);
        if (playerExt == null) {
            return false;
        }
        if (!(entity instanceof TameableCreatureEntity)) {
            if (!player.func_130014_f_().field_72995_K) {
                player.func_145747_a((ITextComponent)new TextComponentString(LanguageManager.translate("message.soulstone.invalid")));
            }
            return false;
        }
        TameableCreatureEntity entityTameable = (TameableCreatureEntity)entity;
        CreatureInfo creatureInfo = entityTameable.creatureInfo;
        if (!creatureInfo.isTameable() || entityTameable.func_70902_q() != player) {
            if (!player.func_130014_f_().field_72995_K) {
                player.func_145747_a((ITextComponent)new TextComponentString(LanguageManager.translate("message.soulstone.untamed")));
            }
            return false;
        }
        if (entityTameable.getPetEntry() != null) {
            if (!player.func_130014_f_().field_72995_K) {
                player.func_145747_a((ITextComponent)new TextComponentString(LanguageManager.translate("message.soulstone.exists")));
            }
            return false;
        }
        if (player.func_130014_f_().field_72995_K) {
            for (int i = 0; i < 32; ++i) {
                entity.func_130014_f_().func_175688_a(EnumParticleTypes.VILLAGER_HAPPY, entity.field_70165_t + (double)(4.0f * player.func_70681_au().nextFloat()) - 2.0, entity.field_70163_u + (double)(4.0f * player.func_70681_au().nextFloat()) - 2.0, entity.field_70161_v + (double)(4.0f * player.func_70681_au().nextFloat()) - 2.0, 0.0, 0.0, 0.0, new int[0]);
            }
        }
        if (!player.func_130014_f_().field_72995_K) {
            String petType = "pet";
            if (entityTameable.creatureInfo.isMountable()) {
                petType = "mount";
            }
            String message = LanguageManager.translate("message.soulstone." + petType + ".added");
            message = message.replace("%creature%", creatureInfo.getTitle());
            player.func_145747_a((ITextComponent)new TextComponentString(message));
            PetEntry petEntry = PetEntry.createFromEntity(player, entityTameable, petType);
            playerExt.petManager.addEntry(petEntry);
            playerExt.sendPetEntriesToPlayer(petType);
            petEntry.assignEntity(entity);
            entityTameable.setPetEntry(petEntry);
            if (!player.field_71075_bZ.field_75098_d) {
                itemStack.func_190920_e(Math.max(0, itemStack.func_190916_E() - 1));
            }
        }
        return true;
    }
}

