/*
 * Decompiled with CFR 0.152.
 */
package com.lycanitesmobs.core.info.projectile.behaviours;

import com.google.gson.JsonObject;
import com.lycanitesmobs.core.entity.BaseProjectileEntity;
import com.lycanitesmobs.core.info.projectile.behaviours.ProjectileBehaviour;
import net.minecraft.block.Block;
import net.minecraft.block.BlockDynamicLiquid;
import net.minecraft.block.BlockLiquid;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fluids.BlockFluidBase;
import net.minecraftforge.fml.common.registry.GameRegistry;

public class ProjectileBehaviourPlaceBlocks
extends ProjectileBehaviour {
    public String blockName;
    public double chance = 1.0;
    public int radius = 1;
    public int height = 1;
    public boolean solidSurface = true;

    @Override
    public void loadFromJSON(JsonObject json) {
        this.blockName = json.get("block").getAsString();
        if (json.has("chance")) {
            this.chance = json.get("chance").getAsDouble();
        }
        if (json.has("radius")) {
            this.radius = json.get("radius").getAsInt();
        }
        if (json.has("height")) {
            this.height = json.get("height").getAsInt();
        }
        if (json.has("solidSurface")) {
            this.solidSurface = json.get("solidSurface").getAsBoolean();
        }
    }

    @Override
    public void onProjectileImpact(BaseProjectileEntity projectile, World world, BlockPos pos) {
        Block block = (Block)GameRegistry.findRegistry(Block.class).getValue(new ResourceLocation(this.blockName));
        if (block == null) {
            return;
        }
        if (block == Blocks.field_150355_j) {
            block = Blocks.field_150358_i;
        } else if (block == Blocks.field_150353_l) {
            block = Blocks.field_150356_k;
        }
        IBlockState blockState = block.func_176223_P();
        if (block instanceof BlockDynamicLiquid || block instanceof BlockFluidBase) {
            blockState = blockState.func_177226_a((IProperty)BlockLiquid.field_176367_b, (Comparable)Integer.valueOf(2));
        }
        for (int x = -this.radius + 1; x < this.radius; ++x) {
            for (int y = this.height - 1; y < this.height; ++y) {
                for (int z = -this.radius + 1; z < this.radius; ++z) {
                    BlockPos placePos = pos.func_177982_a(x, y, z);
                    if (this.solidSurface && !world.func_180495_p(placePos.func_177977_b()).func_185904_a().func_76220_a() || !projectile.canDestroyBlock(placePos) || !(this.chance >= 1.0) && !(this.chance >= world.field_73012_v.nextDouble())) continue;
                    world.func_175656_a(placePos, blockState);
                }
            }
        }
    }
}

