/*
 * Decompiled with CFR 0.152.
 */
package com.lycanitesmobs.core.info;

import com.google.gson.JsonObject;
import com.lycanitesmobs.LycanitesMobs;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.registry.GameRegistry;

public class ItemDrop {
    public static List<ItemDrop> allDrops = new ArrayList<ItemDrop>();
    public String itemId;
    protected int metadata;
    protected String burningItemId;
    protected int burningMetadata;
    protected Map<Integer, String> effectItemIds = new HashMap<Integer, String>();
    protected Map<Integer, Integer> effectItemMetadata = new HashMap<Integer, Integer>();
    public int minAmount = 1;
    public int maxAmount = 1;
    public boolean bonusAmount = true;
    public boolean amountMultiplier = true;
    public float chance = 0.0f;
    public int subspeciesIndex = -1;
    public int variantIndex = -1;
    public boolean adultOnly = true;

    public static ItemDrop createFromJSON(JsonObject json) {
        ItemDrop itemDrop = null;
        int itemMetadata = 0;
        if (json.has("item")) {
            if (json.has("metadata")) {
                itemMetadata = json.get("metadata").getAsInt();
            }
            String itemId = json.get("item").getAsString();
            itemDrop = new ItemDrop(itemId, itemMetadata, 1.0f);
            itemDrop.loadFromJSON(json);
        } else {
            LycanitesMobs.logWarning("", "[JSON] Unable to load item drop from json as it has no item id!");
        }
        allDrops.add(itemDrop);
        return itemDrop;
    }

    public static ItemDrop createFromConfigString(String itemDropString) {
        if (itemDropString != null && itemDropString.length() > 0) {
            String[] customDropValues = itemDropString.split(",");
            String itemId = customDropValues[0];
            int itemMetadata = 0;
            if (customDropValues.length > 1) {
                itemMetadata = Integer.parseInt(customDropValues[1]);
            }
            int amountMin = 1;
            if (customDropValues.length > 2) {
                amountMin = Integer.parseInt(customDropValues[2]);
            }
            int amountMax = 1;
            if (customDropValues.length > 3) {
                amountMax = Integer.parseInt(customDropValues[3]);
            }
            float chance = 1.0f;
            if (customDropValues.length > 4) {
                chance = Float.parseFloat(customDropValues[4]);
            }
            ItemDrop itemDrop = new ItemDrop(itemId, itemMetadata, chance);
            itemDrop.setMinAmount(amountMin);
            itemDrop.setMaxAmount(amountMax);
            return itemDrop;
        }
        return null;
    }

    public ItemDrop(String itemId, int metadata, float chance) {
        this.itemId = itemId;
        this.metadata = metadata;
        this.chance = chance;
    }

    public ItemDrop(NBTTagCompound nbtTagCompound) {
        this.readFromNBT(nbtTagCompound);
    }

    public ItemDrop(ItemDrop copyDrop) {
        this.itemId = copyDrop.itemId;
        this.metadata = copyDrop.metadata;
        this.minAmount = copyDrop.minAmount;
        this.maxAmount = copyDrop.maxAmount;
        this.bonusAmount = copyDrop.bonusAmount;
        this.amountMultiplier = copyDrop.amountMultiplier;
        this.chance = copyDrop.chance;
        this.subspeciesIndex = copyDrop.subspeciesIndex;
        this.variantIndex = copyDrop.variantIndex;
        this.adultOnly = copyDrop.adultOnly;
        this.burningItemId = copyDrop.burningItemId;
        this.burningMetadata = copyDrop.burningMetadata;
        this.effectItemIds = copyDrop.effectItemIds;
        this.effectItemMetadata = copyDrop.effectItemMetadata;
    }

    public void loadFromJSON(JsonObject json) {
        if (json.has("minAmount")) {
            this.minAmount = json.get("minAmount").getAsInt();
        }
        if (json.has("maxAmount")) {
            this.maxAmount = json.get("maxAmount").getAsInt();
        }
        if (json.has("bonusAmount")) {
            this.bonusAmount = json.get("bonusAmount").getAsBoolean();
        }
        if (json.has("amountMultiplier")) {
            this.amountMultiplier = json.get("amountMultiplier").getAsBoolean();
        }
        if (json.has("chance")) {
            this.chance = json.get("chance").getAsFloat();
        }
        if (json.has("subspecies")) {
            this.subspeciesIndex = json.get("subspecies").getAsInt();
        }
        if (json.has("variant")) {
            this.variantIndex = json.get("variant").getAsInt();
        }
        if (json.has("adultOnly")) {
            this.adultOnly = json.get("adultOnly").getAsBoolean();
        }
        if (json.has("burningItem")) {
            this.burningItemId = json.get("burningItem").getAsString();
            if (json.has("burningMetadata")) {
                this.burningMetadata = json.get("burningMetadata").getAsInt();
            }
        }
    }

    public ItemDrop setDrop(ItemStack itemStack) {
        this.itemId = itemStack.func_77973_b().getRegistryName().toString();
        this.metadata = itemStack.func_77960_j();
        return this;
    }

    public ItemDrop setBurningDrop(ItemStack itemStack) {
        this.burningItemId = itemStack.func_77973_b().getRegistryName().toString();
        this.burningMetadata = itemStack.func_77960_j();
        return this;
    }

    public ItemDrop setEffectDrop(int effectID, ItemStack itemStack) {
        this.effectItemIds.put(effectID, itemStack.func_77973_b().getRegistryName().toString());
        this.effectItemMetadata.put(effectID, itemStack.func_77960_j());
        return this;
    }

    public ItemDrop setMinAmount(int amount) {
        this.minAmount = amount;
        return this;
    }

    public ItemDrop setMaxAmount(int amount) {
        this.maxAmount = amount;
        return this;
    }

    public ItemDrop setChance(float chance) {
        this.chance = chance;
        return this;
    }

    public ItemDrop setSubspecies(int subspeciesIndex) {
        this.subspeciesIndex = subspeciesIndex;
        return this;
    }

    public ItemDrop setVariant(int variantIndex) {
        this.variantIndex = variantIndex;
        return this;
    }

    public int getQuantity(Random random, int bonus, int multiplier) {
        int min;
        int max;
        float roll = random.nextFloat();
        if ((roll = Math.max(roll, 0.0f)) > this.chance) {
            return 0;
        }
        if (!this.amountMultiplier) {
            multiplier = 1;
        }
        if ((max = this.maxAmount + (this.bonusAmount ? bonus : 0)) <= (min = this.minAmount)) {
            return min * multiplier;
        }
        float dropRange = (float)(max - min) * (roll /= this.chance);
        int dropAmount = min + Math.round(dropRange);
        return Math.min(dropAmount * multiplier, this.getItemStack().func_77976_d());
    }

    public ItemStack getItemStack() {
        if (this.itemId == null) {
            return ItemStack.field_190927_a;
        }
        Item item = (Item)GameRegistry.findRegistry(Item.class).getValue(new ResourceLocation(this.itemId));
        if (item != null) {
            return new ItemStack(item, 1, this.metadata);
        }
        return ItemStack.field_190927_a;
    }

    public ItemStack getBurningItemStack() {
        if (this.burningItemId == null) {
            return this.getItemStack();
        }
        Item item = (Item)GameRegistry.findRegistry(Item.class).getValue(new ResourceLocation(this.burningItemId));
        if (item != null) {
            return new ItemStack(item, 1, this.burningMetadata);
        }
        return this.getItemStack();
    }

    public ItemStack getEffectItemStack(int effectId) {
        if (!this.effectItemIds.containsKey(effectId) || !this.effectItemMetadata.containsKey(effectId)) {
            return ItemStack.field_190927_a;
        }
        Item item = (Item)GameRegistry.findRegistry(Item.class).getValue(new ResourceLocation(this.effectItemIds.get(effectId)));
        if (item != null) {
            return new ItemStack(item, 1, this.effectItemMetadata.get(effectId).intValue());
        }
        return ItemStack.field_190927_a;
    }

    public ItemStack getEntityDropItemStack(EntityLivingBase entity, int quantity) {
        ItemStack itemStack = this.getItemStack();
        if (entity != null) {
            if (entity.func_70027_ad()) {
                itemStack = this.getBurningItemStack();
            }
            for (Object potionEffect : entity.func_70651_bq()) {
                int effectId;
                ItemStack effectStack;
                if (!(potionEffect instanceof PotionEffect) || (effectStack = this.getEffectItemStack(effectId = Potion.func_188409_a((Potion)((PotionEffect)potionEffect).func_188419_a()))).func_190926_b()) continue;
                itemStack = effectStack;
            }
        }
        itemStack.func_190920_e(quantity);
        return itemStack;
    }

    public void readFromNBT(NBTTagCompound nbtTagCompound) {
        if (nbtTagCompound.func_74764_b("ItemId")) {
            this.itemId = nbtTagCompound.func_74779_i("ItemId");
        }
        if (nbtTagCompound.func_74764_b("Metadata")) {
            this.metadata = nbtTagCompound.func_74762_e("Metadata");
        }
        this.minAmount = nbtTagCompound.func_74762_e("MinAmount");
        this.maxAmount = nbtTagCompound.func_74762_e("MaxAmount");
        if (nbtTagCompound.func_74764_b("BonusAmount")) {
            this.bonusAmount = nbtTagCompound.func_74767_n("BonusAmount");
        }
        this.chance = nbtTagCompound.func_74760_g("Chance");
        if (nbtTagCompound.func_74764_b("AmountMultiplier")) {
            this.amountMultiplier = nbtTagCompound.func_74767_n("AmountMultiplier");
        }
        if (nbtTagCompound.func_74764_b("Subspecies")) {
            this.subspeciesIndex = nbtTagCompound.func_74762_e("Subspecies");
        }
        if (nbtTagCompound.func_74764_b("Variant")) {
            this.variantIndex = nbtTagCompound.func_74762_e("Variant");
        }
        if (nbtTagCompound.func_74764_b("AdultOnly")) {
            this.adultOnly = nbtTagCompound.func_74767_n("AdultOnly");
        }
    }

    public boolean writeToNBT(NBTTagCompound nbtTagCompound) {
        if (this.itemId == null) {
            return false;
        }
        nbtTagCompound.func_74778_a("ItemId", this.itemId);
        nbtTagCompound.func_74768_a("Metadata", this.metadata);
        nbtTagCompound.func_74768_a("MinAmount", this.minAmount);
        nbtTagCompound.func_74768_a("MaxAmount", this.maxAmount);
        nbtTagCompound.func_74757_a("BonusAmount", this.bonusAmount);
        nbtTagCompound.func_74776_a("Chance", this.chance);
        nbtTagCompound.func_74757_a("AmountMultiplier", this.amountMultiplier);
        nbtTagCompound.func_74768_a("Subspecies", this.subspeciesIndex);
        nbtTagCompound.func_74768_a("Variant", this.variantIndex);
        nbtTagCompound.func_74757_a("AdultOnly", this.adultOnly);
        return true;
    }

    public String toConfigString() {
        return this.itemId + "," + this.metadata + "," + this.minAmount + "," + this.maxAmount + "," + this.chance;
    }
}

