/*
 * Decompiled with CFR 0.152.
 */
package com.lycanitesmobs.core.helpers;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.lycanitesmobs.LycanitesMobs;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.item.Item;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.fml.common.registry.GameRegistry;

public class JSONHelper {
    public static Vec3i getVec3i(JsonObject json, String memberName) {
        if (json.has(memberName)) {
            JsonArray jsonArray = json.get(memberName).getAsJsonArray();
            Iterator jsonIterator = jsonArray.iterator();
            int[] coords = new int[3];
            for (int i = 0; jsonIterator.hasNext() && i < coords.length; ++i) {
                coords[i] = ((JsonElement)jsonIterator.next()).getAsInt();
            }
            return new Vec3i(coords[0], coords[1], coords[2]);
        }
        return new Vec3i(0, 0, 0);
    }

    public static Vec3d getVec3d(JsonObject json, String memberName, Vec3d defaultVec) {
        if (json.has(memberName)) {
            JsonArray jsonArray = json.get(memberName).getAsJsonArray();
            Iterator jsonIterator = jsonArray.iterator();
            double[] coords = new double[3];
            for (int i = 0; jsonIterator.hasNext() && i < coords.length; ++i) {
                coords[i] = ((JsonElement)jsonIterator.next()).getAsDouble();
            }
            return new Vec3d(coords[0], coords[1], coords[2]);
        }
        return defaultVec;
    }

    public static List<String> getJsonStrings(JsonArray jsonArray) {
        ArrayList<String> strings = new ArrayList<String>();
        Iterator jsonIterator = jsonArray.iterator();
        while (jsonIterator.hasNext()) {
            String string = ((JsonElement)jsonIterator.next()).getAsString();
            strings.add(string);
        }
        return strings;
    }

    public static List<Block> getJsonBlocks(JsonObject json) {
        List<Block> blocks = new ArrayList<Block>();
        if (json.has("blocks")) {
            blocks = JSONHelper.getJsonBlocks(json.get("blocks").getAsJsonArray());
        }
        return blocks;
    }

    public static List<Block> getJsonBlocks(JsonArray jsonArray) {
        ArrayList<Block> blocks = new ArrayList<Block>();
        Iterator jsonIterator = jsonArray.iterator();
        while (jsonIterator.hasNext()) {
            Block block = (Block)GameRegistry.findRegistry(Block.class).getValue(new ResourceLocation(((JsonElement)jsonIterator.next()).getAsString()));
            if (block == null) continue;
            blocks.add(block);
        }
        return blocks;
    }

    public static List<Item> getJsonItems(JsonArray jsonArray) {
        ArrayList<Item> items = new ArrayList<Item>();
        Iterator jsonIterator = jsonArray.iterator();
        while (jsonIterator.hasNext()) {
            Item item = (Item)GameRegistry.findRegistry(Item.class).getValue(new ResourceLocation(((JsonElement)jsonIterator.next()).getAsString()));
            if (item == null) continue;
            items.add(item);
        }
        return items;
    }

    public static List<Material> getJsonMaterials(JsonObject json) {
        ArrayList<Material> materials = new ArrayList<Material>();
        if (json.has("materials")) {
            JsonArray jsonArray = json.get("materials").getAsJsonArray();
            Iterator jsonIterator = jsonArray.iterator();
            while (jsonIterator.hasNext()) {
                Material material = null;
                String materialName = ((JsonElement)jsonIterator.next()).getAsString();
                if ("air".equalsIgnoreCase(materialName)) {
                    material = Material.field_151579_a;
                } else if ("lava".equalsIgnoreCase(materialName)) {
                    material = Material.field_151587_i;
                } else if ("fire".equalsIgnoreCase(materialName)) {
                    material = Material.field_151581_o;
                } else if ("water".equalsIgnoreCase(materialName)) {
                    material = Material.field_151586_h;
                } else if ("ground".equalsIgnoreCase(materialName)) {
                    material = Material.field_151578_c;
                } else if ("sand".equalsIgnoreCase(materialName)) {
                    material = Material.field_151595_p;
                } else if ("claw".equalsIgnoreCase(materialName)) {
                    material = Material.field_151571_B;
                } else if ("wood".equalsIgnoreCase(materialName)) {
                    material = Material.field_151575_d;
                } else if ("rock".equalsIgnoreCase(materialName)) {
                    material = Material.field_151576_e;
                } else if ("grass".equalsIgnoreCase(materialName)) {
                    material = Material.field_151577_b;
                } else if ("plants".equalsIgnoreCase(materialName)) {
                    material = Material.field_151585_k;
                } else if ("leaves".equalsIgnoreCase(materialName)) {
                    material = Material.field_151584_j;
                } else if ("vine".equalsIgnoreCase(materialName)) {
                    material = Material.field_151582_l;
                } else if ("cactus".equalsIgnoreCase(materialName)) {
                    material = Material.field_151570_A;
                } else if ("snow".equalsIgnoreCase(materialName)) {
                    material = Material.field_151597_y;
                } else if ("ice".equalsIgnoreCase(materialName)) {
                    material = Material.field_151588_w;
                } else if ("iron".equalsIgnoreCase(materialName)) {
                    material = Material.field_151573_f;
                } else if ("web".equalsIgnoreCase(materialName)) {
                    material = Material.field_151569_G;
                }
                if (material == null) continue;
                materials.add(material);
            }
        }
        return materials;
    }

    public static List<Biome> getBiomesFromTags(List<String> biomeTags) {
        ArrayList<Biome> biomeList = new ArrayList<Biome>();
        for (String biomeEntry : biomeTags) {
            boolean additive = true;
            if (biomeEntry.charAt(0) == '-' || biomeEntry.charAt(0) == '+') {
                if (biomeEntry.charAt(0) == '-') {
                    additive = false;
                }
                biomeEntry = biomeEntry.substring(1);
            }
            ArrayList selectedBiomes = new ArrayList();
            if ("ALL".equalsIgnoreCase(biomeEntry)) {
                for (BiomeDictionary.Type biomeType : BiomeDictionary.Type.getAll()) {
                    Set selectedBiomesSet = BiomeDictionary.getBiomes((BiomeDictionary.Type)biomeType);
                    selectedBiomes.addAll(selectedBiomesSet);
                }
            } else if (!"NONE".equalsIgnoreCase(biomeEntry)) {
                BiomeDictionary.Type biomeType = null;
                try {
                    biomeType = BiomeDictionary.Type.getType((String)biomeEntry.toUpperCase(Locale.ENGLISH), (BiomeDictionary.Type[])new BiomeDictionary.Type[0]);
                }
                catch (Exception e) {
                    LycanitesMobs.logWarning("", "[Spawning] Unknown biome type " + biomeEntry + " this will be ignored and treated as NONE.");
                }
                if (biomeType != null) {
                    Set selectedBiomesSet = BiomeDictionary.getBiomes((BiomeDictionary.Type)biomeType);
                    selectedBiomes.addAll(selectedBiomesSet);
                }
            }
            for (Biome biome : selectedBiomes) {
                if (additive) {
                    if (biomeList.contains(biome)) continue;
                    biomeList.add(biome);
                    continue;
                }
                biomeList.remove(biome);
            }
        }
        return biomeList;
    }

    public static List<Biome> getBiomes(List<String> biomeIds) {
        ArrayList<Biome> biomes = new ArrayList<Biome>();
        for (String biomeId : biomeIds) {
            Biome biome = (Biome)GameRegistry.findRegistry(Biome.class).getValue(new ResourceLocation(biomeId));
            if (biome == null) continue;
            biomes.add(biome);
        }
        return biomes;
    }
}

