/*
 * Decompiled with CFR 0.152.
 */
package com.lycanitesmobs.core.entity.navigate;

import com.lycanitesmobs.ObjectManager;
import com.lycanitesmobs.core.entity.BaseCreatureEntity;
import com.lycanitesmobs.core.entity.navigate.CreatureNodeProcessor;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.init.Blocks;
import net.minecraft.pathfinding.Path;
import net.minecraft.pathfinding.PathFinder;
import net.minecraft.pathfinding.PathNavigate;
import net.minecraft.pathfinding.PathNodeType;
import net.minecraft.pathfinding.PathPoint;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class CreaturePathNavigate
extends PathNavigate {
    public BaseCreatureEntity entityCreature;
    protected BlockPos targetPosition;

    public CreaturePathNavigate(BaseCreatureEntity entityCreature, World world) {
        super((EntityLiving)entityCreature, world);
        this.entityCreature = entityCreature;
    }

    protected PathFinder func_179679_a() {
        this.field_179695_a = new CreatureNodeProcessor();
        this.field_179695_a.func_186317_a(true);
        return new PathFinder(this.field_179695_a);
    }

    protected boolean func_75485_k() {
        if (this.entityCreature.isFlying()) {
            return true;
        }
        if (this.entityCreature.func_70090_H()) {
            return this.entityCreature.canWade() || this.entityCreature.isStrongSwimmer();
        }
        return this.field_75515_a.field_70122_E || this.field_75515_a.func_184218_aH();
    }

    public void setCanOpenDoors(boolean setBreakDoors) {
        this.field_179695_a.func_186321_b(setBreakDoors);
    }

    public boolean getCanOpenDoors() {
        return this.field_179695_a.func_186324_d();
    }

    public void setEnterDoors(boolean setBreakDoors) {
        this.field_179695_a.func_186317_a(setBreakDoors);
    }

    public boolean getEnterDoors() {
        return this.field_179695_a.func_186323_c();
    }

    public Path func_179680_a(BlockPos pos) {
        this.targetPosition = this.getSuitableDestination(pos);
        Path path = super.func_179680_a(this.targetPosition);
        return path;
    }

    public Path func_75494_a(Entity entity) {
        this.targetPosition = new BlockPos(entity);
        Path path = super.func_75494_a(entity);
        return path;
    }

    protected BlockPos getSuitableDestination(BlockPos pos) {
        IBlockState targetBlockState = this.field_75513_b.func_180495_p(pos);
        if (targetBlockState.func_185904_a() == Material.field_151579_a) {
            if (this.entityCreature.isFlying()) {
                return pos;
            }
            return this.getGround(pos);
        }
        if (!targetBlockState.func_185904_a().func_76220_a()) {
            return pos;
        }
        return this.getSurface(pos);
    }

    protected Vec3d func_75502_i() {
        return new Vec3d(this.field_75515_a.field_70165_t, (double)this.getPathablePosY(), this.field_75515_a.field_70161_v);
    }

    protected int getPathablePosY() {
        if (this.entityCreature.func_70090_H() && this.entityCreature.canFloat() && !this.entityCreature.canDive()) {
            int posY = (int)this.field_75515_a.func_174813_aQ().field_72338_b;
            Block block = this.field_75513_b.func_180495_p(new BlockPos(MathHelper.func_76128_c((double)this.field_75515_a.field_70165_t), posY, MathHelper.func_76128_c((double)this.field_75515_a.field_70161_v))).func_177230_c();
            int searchCount = 0;
            while (this.isSwimmableBlock(block)) {
                block = this.field_75513_b.func_180495_p(new BlockPos(MathHelper.func_76128_c((double)this.field_75515_a.field_70165_t), ++posY, MathHelper.func_76128_c((double)this.field_75515_a.field_70161_v))).func_177230_c();
                if (++searchCount <= 16) continue;
                return (int)this.field_75515_a.func_174813_aQ().field_72338_b;
            }
            return posY;
        }
        return (int)(this.field_75515_a.func_174813_aQ().field_72338_b + 0.5);
    }

    public boolean func_75497_a(Entity entityIn, double speedIn) {
        Path path = this.func_75494_a(entityIn);
        if (path != null) {
            return this.func_75484_a(path, speedIn);
        }
        if (this.entityCreature.canClimb()) {
            this.targetPosition = new BlockPos(entityIn);
            this.field_75511_d = speedIn;
            return true;
        }
        return false;
    }

    protected boolean isSwimmableBlock(Block block) {
        return this.isSwimmableBlock(block, 0);
    }

    protected boolean isSwimmableBlock(Block block, int cachedCheck) {
        if (block == null || block == Blocks.field_150350_a) {
            return false;
        }
        if (cachedCheck == 1 || this.isWaterBlock(block)) {
            return !this.entityCreature.waterDamage();
        }
        if (cachedCheck == 2 || this.isLavaBlock(block)) {
            return !this.entityCreature.canBurn();
        }
        if (cachedCheck == 3 || this.isOozeBlock(block)) {
            return !this.entityCreature.canFreeze();
        }
        return false;
    }

    protected boolean isWaterBlock(Block block) {
        return block == Blocks.field_150358_i || block == Blocks.field_150355_j;
    }

    protected boolean isLavaBlock(Block block) {
        return block == Blocks.field_150356_k || block == Blocks.field_150353_l || block == ObjectManager.getBlock("purelava");
    }

    protected boolean isOozeBlock(Block block) {
        return block == ObjectManager.getBlock("ooze");
    }

    public boolean func_188555_b(BlockPos pos) {
        if (this.entityCreature.isFlying() || this.entityCreature.func_70090_H() && this.entityCreature.isStrongSwimmer()) {
            IBlockState blockState = this.field_75513_b.func_180495_p(pos);
            if (blockState.func_185904_a().func_76224_d()) {
                return this.entityCreature.isStrongSwimmer();
            }
            return !blockState.func_185904_a().func_76220_a();
        }
        return super.func_188555_b(pos);
    }

    public BlockPos getGround(BlockPos pos) {
        BlockPos resultPos = pos;
        resultPos = pos.func_177977_b();
        while (resultPos.func_177956_o() > 0 && !this.field_75513_b.func_180495_p(resultPos).func_185904_a().func_76220_a()) {
            resultPos = resultPos.func_177977_b();
        }
        if ((resultPos = resultPos.func_177984_a()).func_177956_o() == 0 && !this.field_75513_b.func_180495_p(resultPos).func_185896_q()) {
            return pos;
        }
        return resultPos;
    }

    public BlockPos getSurface(BlockPos pos) {
        BlockPos resultPos = pos;
        resultPos = pos.func_177984_a();
        while (resultPos.func_177956_o() < this.field_75513_b.func_72800_K() && this.field_75513_b.func_180495_p(resultPos).func_185904_a().func_76220_a()) {
            resultPos = resultPos.func_177984_a();
        }
        if (resultPos.func_177956_o() == this.field_75513_b.func_72800_K() && this.field_75513_b.func_180495_p(resultPos).func_185904_a().func_76220_a()) {
            return pos;
        }
        return resultPos;
    }

    protected boolean func_75493_a(Vec3d startVec, Vec3d endVec, int sizeX, int sizeY, int sizeZ) {
        if (this.entityCreature.isFlying() || this.entityCreature.func_70090_H()) {
            RayTraceResult raytraceresult = this.field_75513_b.func_147447_a(startVec, new Vec3d(endVec.field_72450_a, endVec.field_72448_b + (double)this.field_75515_a.field_70131_O * 0.5, endVec.field_72449_c), false, true, false);
            if (raytraceresult == null) {
                return true;
            }
            if (raytraceresult.field_72313_a == RayTraceResult.Type.BLOCK) {
                IBlockState hitState = this.field_75513_b.func_180495_p(raytraceresult.func_178782_a());
                return !hitState.func_185904_a().func_76220_a();
            }
            return raytraceresult.field_72313_a == RayTraceResult.Type.MISS;
        }
        int i = MathHelper.func_76128_c((double)startVec.field_72450_a);
        int j = MathHelper.func_76128_c((double)startVec.field_72449_c);
        double distanceX = endVec.field_72450_a - startVec.field_72450_a;
        double distanceY = endVec.field_72449_c - startVec.field_72449_c;
        double distance = distanceX * distanceX + distanceY * distanceY;
        if (distance < 1.0E-8) {
            return false;
        }
        double d3 = 1.0 / Math.sqrt(distance);
        if (!this.isSafeToStandAt(i, (int)startVec.field_72448_b, j, sizeX += 2, sizeY, sizeZ += 2, startVec, distanceX *= d3, distanceY *= d3)) {
            return false;
        }
        sizeX -= 2;
        sizeZ -= 2;
        double d4 = 1.0 / Math.abs(distanceX);
        double d5 = 1.0 / Math.abs(distanceY);
        double d6 = (double)i - startVec.field_72450_a;
        double d7 = (double)j - startVec.field_72449_c;
        if (distanceX >= 0.0) {
            d6 += 1.0;
        }
        if (distanceY >= 0.0) {
            d7 += 1.0;
        }
        d6 /= distanceX;
        d7 /= distanceY;
        int k = distanceX < 0.0 ? -1 : 1;
        int l = distanceY < 0.0 ? -1 : 1;
        int i1 = MathHelper.func_76128_c((double)endVec.field_72450_a);
        int j1 = MathHelper.func_76128_c((double)endVec.field_72449_c);
        int k1 = i1 - i;
        int l1 = j1 - j;
        while (k1 * k > 0 || l1 * l > 0) {
            if (d6 < d7) {
                d6 += d4;
                k1 = i1 - (i += k);
            } else {
                d7 += d5;
                l1 = j1 - (j += l);
            }
            if (this.isSafeToStandAt(i, (int)startVec.field_72448_b, j, sizeX, sizeY, sizeZ, startVec, distanceX, distanceY)) continue;
            return false;
        }
        return true;
    }

    protected boolean isSafeToStandAt(int x, int y, int z, int sizeX, int sizeY, int sizeZ, Vec3d startVec, double distanceX, double distanceZ) {
        sizeX = Math.min(sizeX, 2);
        sizeY = Math.min(sizeY, 3);
        int i = x - sizeX / 2;
        int j = z - (sizeZ = Math.min(sizeZ, 2)) / 2;
        if (!this.isPositionClear(i, y, j, sizeX, sizeY, sizeZ, startVec, distanceX, distanceZ)) {
            return false;
        }
        for (int k = i; k < i + sizeX; ++k) {
            for (int l = j; l < j + sizeZ; ++l) {
                double d0 = (double)k + 0.5 - startVec.field_72450_a;
                double d1 = (double)l + 0.5 - startVec.field_72449_c;
                if (!(d0 * distanceX + d1 * distanceZ >= 0.0)) continue;
                PathNodeType pathnodetype = this.field_179695_a.func_186319_a((IBlockAccess)this.field_75513_b, k, y - 1, l, this.field_75515_a, sizeX, sizeY, sizeZ, true, true);
                if (pathnodetype == PathNodeType.WATER) {
                    return false;
                }
                if (pathnodetype == PathNodeType.LAVA) {
                    return false;
                }
                if (pathnodetype == PathNodeType.OPEN) {
                    return false;
                }
                pathnodetype = this.field_179695_a.func_186319_a((IBlockAccess)this.field_75513_b, k, y, l, this.field_75515_a, sizeX, sizeY, sizeZ, true, true);
                float f = this.field_75515_a.func_184643_a(pathnodetype);
                if (f < 0.0f || f >= 8.0f) {
                    return false;
                }
                if (!this.entityCreature.canBurn() || pathnodetype != PathNodeType.DAMAGE_FIRE && pathnodetype != PathNodeType.DANGER_FIRE && pathnodetype != PathNodeType.DAMAGE_OTHER) continue;
                return false;
            }
        }
        return true;
    }

    private boolean isPositionClear(int x, int y, int z, int sizeX, int sizeY, int sizeZ, Vec3d startVec, double distanceX, double distanceZ) {
        for (BlockPos blockpos : BlockPos.func_177980_a((BlockPos)new BlockPos(x, y, z), (BlockPos)new BlockPos(x + sizeX - 1, y + sizeY - 1, z + sizeZ - 1))) {
            Block block;
            double d1;
            double d0 = (double)blockpos.func_177958_n() + 0.5 - startVec.field_72450_a;
            if (!(d0 * distanceX + (d1 = (double)blockpos.func_177952_p() + 0.5 - startVec.field_72449_c) * distanceZ >= 0.0) || (block = this.field_75513_b.func_180495_p(blockpos).func_177230_c()).func_176205_b((IBlockAccess)this.field_75513_b, blockpos)) continue;
            return false;
        }
        return true;
    }

    protected void func_75487_m() {
        super.func_75487_m();
        if (!this.entityCreature.func_130014_f_().func_72935_r()) {
            return;
        }
        if (this.entityCreature.daylightBurns()) {
            if (this.field_75513_b.func_175678_i(this.field_75515_a.func_180425_c())) {
                return;
            }
            for (int j = 0; j < this.field_75514_c.func_75874_d(); ++j) {
                PathPoint pathpoint2 = this.field_75514_c.func_75877_a(j);
                BlockPos pathPos = new BlockPos(pathpoint2.field_75839_a, pathpoint2.field_75837_b, pathpoint2.field_75838_c);
                if (this.field_75513_b.func_180495_p(pathPos).func_177230_c() == Blocks.field_150355_j || this.field_75513_b.func_180495_p(pathPos.func_177977_b()).func_177230_c() == Blocks.field_150355_j || !this.field_75513_b.func_175678_i(pathPos)) continue;
                this.field_75514_c.func_75871_b(j - 1);
                return;
            }
        }
    }

    protected void func_75508_h() {
        if (this.entityCreature.isFlying() || this.entityCreature.func_70090_H()) {
            Vec3d entityVector = this.func_75502_i();
            float entitySize = this.field_75515_a.field_70130_N * this.field_75515_a.field_70130_N;
            if (entityVector.func_72436_e(this.field_75514_c.func_75881_a((Entity)this.field_75515_a, this.field_75514_c.func_75873_e())) < (double)entitySize) {
                this.field_75514_c.func_75875_a();
            }
            int pathIndexRange = 6;
            for (int pathIndex = Math.min(this.field_75514_c.func_75873_e() + pathIndexRange, this.field_75514_c.func_75874_d() - 1); pathIndex > this.field_75514_c.func_75873_e(); --pathIndex) {
                Vec3d pathVector = this.field_75514_c.func_75881_a((Entity)this.field_75515_a, pathIndex);
                if (!(pathVector.func_72436_e(entityVector) <= 36.0) || !this.func_75493_a(entityVector, pathVector, 0, 0, 0)) continue;
                this.field_75514_c.func_75872_c(pathIndex);
                break;
            }
            this.func_179677_a(entityVector);
            return;
        }
        super.func_75508_h();
    }

    /*
     * Enabled aggressive block sorting
     */
    public void func_75501_e() {
        block4: {
            block5: {
                if (!this.func_75500_f() || !this.entityCreature.canClimb()) {
                    super.func_75501_e();
                    return;
                }
                if (this.targetPosition == null) return;
                double d0 = this.field_75515_a.field_70130_N * this.field_75515_a.field_70130_N;
                if (!(this.field_75515_a.func_174831_c(this.targetPosition) >= d0)) break block4;
                if (this.field_75515_a.field_70163_u <= (double)this.targetPosition.func_177956_o()) break block5;
                BlockPos blockPos = new BlockPos(this.targetPosition.func_177958_n(), MathHelper.func_76128_c((double)this.field_75515_a.field_70163_u), this.targetPosition.func_177952_p());
                if (!(this.field_75515_a.func_174831_c(blockPos) >= d0)) break block4;
            }
            this.field_75515_a.func_70605_aq().func_75642_a((double)this.targetPosition.func_177958_n(), (double)this.targetPosition.func_177956_o(), (double)this.targetPosition.func_177952_p(), this.field_75511_d);
            return;
        }
        this.targetPosition = null;
    }
}

