/*
 * Decompiled with CFR 0.152.
 */
package com.lycanitesmobs.core.entity.navigate;

import com.google.common.collect.Sets;
import com.lycanitesmobs.ObjectManager;
import com.lycanitesmobs.core.entity.BaseCreatureEntity;
import com.lycanitesmobs.core.entity.navigate.ICreatureNodeProcessor;
import java.util.EnumSet;
import java.util.HashSet;
import net.minecraft.block.Block;
import net.minecraft.block.BlockDoor;
import net.minecraft.block.BlockFence;
import net.minecraft.block.BlockFenceGate;
import net.minecraft.block.BlockRailBase;
import net.minecraft.block.BlockWall;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.init.Blocks;
import net.minecraft.pathfinding.NodeProcessor;
import net.minecraft.pathfinding.PathNodeType;
import net.minecraft.pathfinding.PathPoint;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.IBlockAccess;

public class CreatureNodeProcessor
extends NodeProcessor
implements ICreatureNodeProcessor {
    public BaseCreatureEntity entityCreature;
    protected float avoidsWater;

    public void func_186315_a(IBlockAccess sourceIn, EntityLiving mob) {
        super.func_186315_a(sourceIn, mob);
        this.avoidsWater = mob.func_184643_a(PathNodeType.WATER);
        if (mob instanceof BaseCreatureEntity) {
            this.entityCreature = (BaseCreatureEntity)mob;
        }
    }

    @Override
    public void updateEntitySize(Entity updateEntity) {
        this.field_176168_c = MathHelper.func_76128_c((double)(this.getWidth(updateEntity) + 1.0));
        this.field_176165_d = MathHelper.func_76141_d((float)(updateEntity.field_70131_O + 1.0f));
        this.field_176166_e = MathHelper.func_76128_c((double)(this.getWidth(updateEntity) + 1.0));
    }

    public void func_176163_a() {
        if (this.entityCreature != null) {
            this.field_186326_b.func_184644_a(PathNodeType.WATER, this.avoidsWater);
        }
        super.func_176163_a();
    }

    public boolean func_186322_e() {
        if (this.entityCreature != null) {
            return this.entityCreature.canWade() || this.entityCreature.isStrongSwimmer();
        }
        return super.func_186322_e();
    }

    public boolean swimming() {
        if (this.entityCreature == null) {
            return false;
        }
        if (this.entityCreature.func_70090_H()) {
            return this.entityCreature.isStrongSwimmer();
        }
        return false;
    }

    public boolean flying() {
        return this.entityCreature != null && this.entityCreature.isFlying() && !this.entityCreature.func_70090_H();
    }

    public double getWidth() {
        return this.getWidth((Entity)this.field_186326_b);
    }

    public double getWidth(Entity entity) {
        return Math.min(3.0, (double)entity.field_70130_N);
    }

    public PathPoint func_186325_a(double x, double y, double z) {
        if (this.flying() || this.swimming()) {
            return this.func_176159_a(MathHelper.func_76128_c((double)x), MathHelper.func_76128_c((double)(y + 0.5)), MathHelper.func_76128_c((double)z));
        }
        return this.func_176159_a(MathHelper.func_76128_c((double)x), MathHelper.func_76128_c((double)y), MathHelper.func_76128_c((double)z));
    }

    public PathPoint func_186318_b() {
        int posY;
        if (this.flying() || this.swimming()) {
            return this.func_176159_a(MathHelper.func_76128_c((double)this.field_186326_b.func_174813_aQ().field_72340_a), MathHelper.func_76128_c((double)(this.field_186326_b.func_174813_aQ().field_72338_b + 0.5)), MathHelper.func_76128_c((double)this.field_186326_b.func_174813_aQ().field_72339_c));
        }
        if (this.func_186322_e() && this.field_186326_b.func_70090_H()) {
            posY = (int)this.field_186326_b.func_174813_aQ().field_72338_b;
            BlockPos.MutableBlockPos blockpos$mutableblockpos = new BlockPos.MutableBlockPos(MathHelper.func_76128_c((double)this.field_186326_b.field_70165_t), posY, MathHelper.func_76128_c((double)this.field_186326_b.field_70161_v));
            Block block = this.field_176169_a.func_180495_p((BlockPos)blockpos$mutableblockpos).func_177230_c();
            while (block == Blocks.field_150358_i || block == Blocks.field_150355_j) {
                blockpos$mutableblockpos.func_181079_c(MathHelper.func_76128_c((double)this.field_186326_b.field_70165_t), ++posY, MathHelper.func_76128_c((double)this.field_186326_b.field_70161_v));
                block = this.field_176169_a.func_180495_p((BlockPos)blockpos$mutableblockpos).func_177230_c();
            }
        } else if (this.field_186326_b.field_70122_E) {
            posY = MathHelper.func_76128_c((double)(this.field_186326_b.func_174813_aQ().field_72338_b + 0.5));
        } else {
            BlockPos blockpos = new BlockPos((Entity)this.field_186326_b);
            while ((this.field_176169_a.func_180495_p(blockpos).func_185904_a() == Material.field_151579_a || this.field_176169_a.func_180495_p(blockpos).func_177230_c().func_176205_b(this.field_176169_a, blockpos)) && blockpos.func_177956_o() > 0) {
                blockpos = blockpos.func_177977_b();
            }
            posY = blockpos.func_177984_a().func_177956_o();
        }
        BlockPos offsetXZ = new BlockPos((Entity)this.field_186326_b);
        PathNodeType targetNodeType = this.getPathNodeType(this.field_186326_b, offsetXZ.func_177958_n(), posY, offsetXZ.func_177952_p());
        if (this.field_186326_b.func_184643_a(targetNodeType) < 0.0f) {
            HashSet set = Sets.newHashSet();
            set.add(new BlockPos(this.field_186326_b.func_174813_aQ().field_72340_a, (double)posY, this.field_186326_b.func_174813_aQ().field_72339_c));
            set.add(new BlockPos(this.field_186326_b.func_174813_aQ().field_72340_a, (double)posY, this.field_186326_b.func_174813_aQ().field_72334_f));
            set.add(new BlockPos(this.field_186326_b.func_174813_aQ().field_72336_d, (double)posY, this.field_186326_b.func_174813_aQ().field_72339_c));
            set.add(new BlockPos(this.field_186326_b.func_174813_aQ().field_72336_d, (double)posY, this.field_186326_b.func_174813_aQ().field_72334_f));
            for (BlockPos betterPos : set) {
                PathNodeType pathnodetype = this.getPathNodeType(this.field_186326_b, betterPos);
                if (!(this.field_186326_b.func_184643_a(pathnodetype) >= 0.0f)) continue;
                return this.func_176159_a(betterPos.func_177958_n(), betterPos.func_177956_o(), betterPos.func_177952_p());
            }
        }
        return this.func_176159_a(offsetXZ.func_177958_n(), posY, offsetXZ.func_177952_p());
    }

    public int func_186320_a(PathPoint[] pathOptions, PathPoint currentPoint, PathPoint targetPoint, float maxDistance) {
        PathPoint pathpoint7;
        PathPoint pathpoint6;
        PathPoint pathpoint5;
        PathPoint pathpoint4;
        boolean flag3;
        if (this.flying() || this.swimming()) {
            int i = 0;
            for (EnumFacing enumfacing : EnumFacing.values()) {
                PathPoint pathpoint = null;
                pathpoint = this.flying() ? this.getFlightNode(currentPoint.field_75839_a + enumfacing.func_82601_c(), currentPoint.field_75837_b + enumfacing.func_96559_d(), currentPoint.field_75838_c + enumfacing.func_82599_e()) : this.getWaterNode(currentPoint.field_75839_a + enumfacing.func_82601_c(), currentPoint.field_75837_b + enumfacing.func_96559_d(), currentPoint.field_75838_c + enumfacing.func_82599_e());
                if (pathpoint == null || pathpoint.field_75842_i || !(pathpoint.func_75829_a(targetPoint) < maxDistance)) continue;
                pathOptions[i++] = pathpoint;
            }
            return i;
        }
        int i = 0;
        int j = 0;
        PathNodeType pathnodetype = this.getPathNodeType(this.field_186326_b, currentPoint.field_75839_a, currentPoint.field_75837_b + 1, currentPoint.field_75838_c);
        if (this.field_186326_b.func_184643_a(pathnodetype) >= 0.0f) {
            j = MathHelper.func_76141_d((float)Math.max(1.0f, this.field_186326_b.field_70138_W));
        }
        BlockPos blockpos = new BlockPos(currentPoint.field_75839_a, currentPoint.field_75837_b, currentPoint.field_75838_c).func_177977_b();
        double d0 = (double)currentPoint.field_75837_b - (1.0 - this.field_176169_a.func_180495_p((BlockPos)blockpos).func_185900_c((IBlockAccess)this.field_176169_a, (BlockPos)blockpos).field_72337_e);
        PathPoint pathpoint = this.getSafePoint(currentPoint.field_75839_a, currentPoint.field_75837_b, currentPoint.field_75838_c + 1, j, d0, EnumFacing.SOUTH);
        PathPoint pathpoint1 = this.getSafePoint(currentPoint.field_75839_a - 1, currentPoint.field_75837_b, currentPoint.field_75838_c, j, d0, EnumFacing.WEST);
        PathPoint pathpoint2 = this.getSafePoint(currentPoint.field_75839_a + 1, currentPoint.field_75837_b, currentPoint.field_75838_c, j, d0, EnumFacing.EAST);
        PathPoint pathpoint3 = this.getSafePoint(currentPoint.field_75839_a, currentPoint.field_75837_b, currentPoint.field_75838_c - 1, j, d0, EnumFacing.NORTH);
        if (pathpoint != null && !pathpoint.field_75842_i && pathpoint.func_75829_a(targetPoint) < maxDistance) {
            pathOptions[i++] = pathpoint;
        }
        if (pathpoint1 != null && !pathpoint1.field_75842_i && pathpoint1.func_75829_a(targetPoint) < maxDistance) {
            pathOptions[i++] = pathpoint1;
        }
        if (pathpoint2 != null && !pathpoint2.field_75842_i && pathpoint2.func_75829_a(targetPoint) < maxDistance) {
            pathOptions[i++] = pathpoint2;
        }
        if (pathpoint3 != null && !pathpoint3.field_75842_i && pathpoint3.func_75829_a(targetPoint) < maxDistance) {
            pathOptions[i++] = pathpoint3;
        }
        boolean flag = pathpoint3 == null || pathpoint3.field_186287_m == PathNodeType.OPEN || pathpoint3.field_186286_l != 0.0f;
        boolean flag1 = pathpoint == null || pathpoint.field_186287_m == PathNodeType.OPEN || pathpoint.field_186286_l != 0.0f;
        boolean flag2 = pathpoint2 == null || pathpoint2.field_186287_m == PathNodeType.OPEN || pathpoint2.field_186286_l != 0.0f;
        boolean bl = flag3 = pathpoint1 == null || pathpoint1.field_186287_m == PathNodeType.OPEN || pathpoint1.field_186286_l != 0.0f;
        if (flag && flag3 && (pathpoint4 = this.getSafePoint(currentPoint.field_75839_a - 1, currentPoint.field_75837_b, currentPoint.field_75838_c - 1, j, d0, EnumFacing.NORTH)) != null && !pathpoint4.field_75842_i && pathpoint4.func_75829_a(targetPoint) < maxDistance) {
            pathOptions[i++] = pathpoint4;
        }
        if (flag && flag2 && (pathpoint5 = this.getSafePoint(currentPoint.field_75839_a + 1, currentPoint.field_75837_b, currentPoint.field_75838_c - 1, j, d0, EnumFacing.NORTH)) != null && !pathpoint5.field_75842_i && pathpoint5.func_75829_a(targetPoint) < maxDistance) {
            pathOptions[i++] = pathpoint5;
        }
        if (flag1 && flag3 && (pathpoint6 = this.getSafePoint(currentPoint.field_75839_a - 1, currentPoint.field_75837_b, currentPoint.field_75838_c + 1, j, d0, EnumFacing.SOUTH)) != null && !pathpoint6.field_75842_i && pathpoint6.func_75829_a(targetPoint) < maxDistance) {
            pathOptions[i++] = pathpoint6;
        }
        if (flag1 && flag2 && (pathpoint7 = this.getSafePoint(currentPoint.field_75839_a + 1, currentPoint.field_75837_b, currentPoint.field_75838_c + 1, j, d0, EnumFacing.SOUTH)) != null && !pathpoint7.field_75842_i && pathpoint7.func_75829_a(targetPoint) < maxDistance) {
            pathOptions[i++] = pathpoint7;
        }
        return i;
    }

    private PathPoint getSafePoint(int x, int y, int z, int p_186332_4_, double p_186332_5_, EnumFacing facing) {
        PathPoint pathpoint = null;
        BlockPos blockpos = new BlockPos(x, y, z);
        BlockPos blockpos1 = blockpos.func_177977_b();
        double d0 = (double)y - (1.0 - this.field_176169_a.func_180495_p((BlockPos)blockpos1).func_185900_c((IBlockAccess)this.field_176169_a, (BlockPos)blockpos1).field_72337_e);
        if (d0 - p_186332_5_ > 1.125) {
            return null;
        }
        PathNodeType pathnodetype = this.getPathNodeType(this.field_186326_b, x, y, z);
        float f = this.field_186326_b.func_184643_a(pathnodetype);
        double entityRadius = this.getWidth() / 2.0;
        if (f >= 0.0f) {
            pathpoint = this.func_176159_a(x, y, z);
            pathpoint.field_186287_m = pathnodetype;
            pathpoint.field_186286_l = Math.max(pathpoint.field_186286_l, f);
        }
        if (pathnodetype == PathNodeType.WALKABLE) {
            return pathpoint;
        }
        if (pathpoint == null && p_186332_4_ > 0 && pathnodetype != PathNodeType.FENCE && pathnodetype != PathNodeType.TRAPDOOR && (pathpoint = this.getSafePoint(x, y + 1, z, p_186332_4_ - 1, p_186332_5_, facing)) != null && (pathpoint.field_186287_m == PathNodeType.OPEN || pathpoint.field_186287_m == PathNodeType.WALKABLE) && this.getWidth() < 1.0) {
            double d2 = (double)(x - facing.func_82601_c()) + 0.5;
            double d3 = (double)(z - facing.func_82599_e()) + 0.5;
            AxisAlignedBB axisalignedbb = new AxisAlignedBB(d2 - entityRadius, (double)y + 0.001, d3 - entityRadius, d2 + entityRadius, (double)((float)y + this.field_186326_b.field_70131_O), d3 + entityRadius);
            AxisAlignedBB axisalignedbb1 = this.field_176169_a.func_180495_p(blockpos).func_185900_c(this.field_176169_a, blockpos);
            AxisAlignedBB axisalignedbb2 = axisalignedbb.func_72321_a(0.0, axisalignedbb1.field_72337_e - 0.002, 0.0);
            if (this.field_186326_b.field_70170_p.func_184143_b(axisalignedbb2)) {
                pathpoint = null;
            }
        }
        if (pathnodetype == PathNodeType.OPEN) {
            PathNodeType pathnodetype1;
            AxisAlignedBB axisalignedbb3 = new AxisAlignedBB((double)x - entityRadius + 0.5, (double)y + 0.001, (double)z - entityRadius + 0.5, (double)x + entityRadius + 0.5, (double)((float)y + this.field_186326_b.field_70131_O), (double)z + entityRadius + 0.5);
            if (this.field_186326_b.field_70170_p.func_184143_b(axisalignedbb3)) {
                return null;
            }
            if (this.getWidth() >= 1.0 && (pathnodetype1 = this.getPathNodeType(this.field_186326_b, x, y - 1, z)) == PathNodeType.BLOCKED) {
                pathpoint = this.func_176159_a(x, y, z);
                pathpoint.field_186287_m = PathNodeType.WALKABLE;
                pathpoint.field_186286_l = Math.max(pathpoint.field_186286_l, f);
                return pathpoint;
            }
            int i = 0;
            while (y > 0 && pathnodetype == PathNodeType.OPEN) {
                --y;
                if (i++ >= this.field_186326_b.func_82143_as()) {
                    return null;
                }
                pathnodetype = this.getPathNodeType(this.field_186326_b, x, y, z);
                f = this.field_186326_b.func_184643_a(pathnodetype);
                if (pathnodetype != PathNodeType.OPEN && f >= 0.0f) {
                    pathpoint = this.func_176159_a(x, y, z);
                    pathpoint.field_186287_m = pathnodetype;
                    pathpoint.field_186286_l = Math.max(pathpoint.field_186286_l, f);
                    break;
                }
                if (!(f < 0.0f)) continue;
                return null;
            }
        }
        return pathpoint;
    }

    public PathNodeType func_186319_a(IBlockAccess blockaccessIn, int x, int y, int z, EntityLiving entitylivingIn, int xSize, int ySize, int zSize, boolean canBreakDoorsIn, boolean canEnterDoorsIn) {
        if (this.swimming()) {
            return PathNodeType.WATER;
        }
        EnumSet<PathNodeType> enumset = EnumSet.noneOf(PathNodeType.class);
        PathNodeType pathnodetype = PathNodeType.BLOCKED;
        BlockPos blockpos = new BlockPos((Entity)entitylivingIn);
        for (int i = 0; i < xSize; ++i) {
            for (int j = 0; j < ySize; ++j) {
                for (int k = 0; k < zSize; ++k) {
                    int l = i + x;
                    int i1 = j + y;
                    int j1 = k + z;
                    PathNodeType pathnodetype1 = this.func_186330_a(blockaccessIn, l, i1, j1);
                    if (pathnodetype1 == PathNodeType.DOOR_WOOD_CLOSED && canBreakDoorsIn && canEnterDoorsIn) {
                        pathnodetype1 = PathNodeType.WALKABLE;
                    }
                    if (pathnodetype1 == PathNodeType.DOOR_OPEN && !canEnterDoorsIn) {
                        pathnodetype1 = PathNodeType.BLOCKED;
                    }
                    if (pathnodetype1 == PathNodeType.RAIL && !(blockaccessIn.func_180495_p(blockpos).func_177230_c() instanceof BlockRailBase) && !(blockaccessIn.func_180495_p(blockpos.func_177977_b()).func_177230_c() instanceof BlockRailBase)) {
                        pathnodetype1 = PathNodeType.FENCE;
                    }
                    if (i == 0 && j == 0 && k == 0) {
                        pathnodetype = pathnodetype1;
                    }
                    enumset.add(pathnodetype1);
                }
            }
        }
        if (enumset.contains(PathNodeType.FENCE)) {
            return PathNodeType.FENCE;
        }
        PathNodeType pathnodetype2 = PathNodeType.BLOCKED;
        for (PathNodeType pathnodetype3 : enumset) {
            if (entitylivingIn.func_184643_a(pathnodetype3) < 0.0f) {
                return pathnodetype3;
            }
            if (!(entitylivingIn.func_184643_a(pathnodetype3) >= entitylivingIn.func_184643_a(pathnodetype2))) continue;
            pathnodetype2 = pathnodetype3;
        }
        if (pathnodetype == PathNodeType.OPEN && entitylivingIn.func_184643_a(pathnodetype2) == 0.0f) {
            return PathNodeType.OPEN;
        }
        return pathnodetype2;
    }

    public PathNodeType getPathNodeType(EntityLiving entitylivingIn, BlockPos pos) {
        if (this.swimming()) {
            return PathNodeType.WATER;
        }
        return this.getPathNodeType(entitylivingIn, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
    }

    public PathNodeType getPathNodeType(EntityLiving entitylivingIn, int x, int y, int z) {
        if (this.swimming()) {
            return PathNodeType.WATER;
        }
        return this.func_186319_a(this.field_176169_a, x, y, z, entitylivingIn, this.field_176168_c, this.field_176165_d, this.field_176166_e, this.func_186324_d(), this.func_186323_c());
    }

    public PathNodeType func_186330_a(IBlockAccess blockaccessIn, int x, int y, int z) {
        if (this.swimming()) {
            return PathNodeType.WATER;
        }
        PathNodeType pathnodetype = this.getPathNodeTypeRaw(blockaccessIn, x, y, z);
        if (pathnodetype == PathNodeType.OPEN && y >= 1) {
            Block block = blockaccessIn.func_180495_p(new BlockPos(x, y - 1, z)).func_177230_c();
            PathNodeType pathnodetype1 = this.getPathNodeTypeRaw(blockaccessIn, x, y - 1, z);
            PathNodeType pathNodeType = pathnodetype = pathnodetype1 != PathNodeType.WALKABLE && pathnodetype1 != PathNodeType.OPEN && pathnodetype1 != PathNodeType.WATER && pathnodetype1 != PathNodeType.LAVA ? PathNodeType.WALKABLE : PathNodeType.OPEN;
            if (pathnodetype1 == PathNodeType.DAMAGE_FIRE || block == Blocks.field_189877_df) {
                pathnodetype = PathNodeType.DAMAGE_FIRE;
            }
            if (pathnodetype1 == PathNodeType.DAMAGE_CACTUS) {
                pathnodetype = PathNodeType.DAMAGE_CACTUS;
            }
        }
        BlockPos.PooledMutableBlockPos blockpos$pooledmutableblockpos = BlockPos.PooledMutableBlockPos.func_185346_s();
        if (pathnodetype == PathNodeType.WALKABLE) {
            for (int j = -1; j <= 1; ++j) {
                for (int i = -1; i <= 1; ++i) {
                    if (j == 0 && i == 0) continue;
                    Block block1 = blockaccessIn.func_180495_p((BlockPos)blockpos$pooledmutableblockpos.func_181079_c(j + x, y, i + z)).func_177230_c();
                    if (block1 == Blocks.field_150434_aF) {
                        pathnodetype = PathNodeType.DANGER_CACTUS;
                        continue;
                    }
                    if (block1 == Blocks.field_150480_ab) {
                        pathnodetype = PathNodeType.DANGER_FIRE;
                        continue;
                    }
                    if (!block1.isBurning(blockaccessIn, (BlockPos)blockpos$pooledmutableblockpos.func_181079_c(j + x, y, i + z))) continue;
                    pathnodetype = PathNodeType.DAMAGE_FIRE;
                }
            }
        }
        blockpos$pooledmutableblockpos.func_185344_t();
        return pathnodetype;
    }

    protected PathNodeType getPathNodeTypeRaw(IBlockAccess blockAccess, int x, int y, int z) {
        BlockPos blockpos = new BlockPos(x, y, z);
        IBlockState iblockstate = blockAccess.func_180495_p(blockpos);
        Block block = iblockstate.func_177230_c();
        Material material = iblockstate.func_185904_a();
        PathNodeType type = block.getAiPathNodeType(iblockstate, blockAccess, blockpos);
        if (type != null) {
            return type;
        }
        return material == Material.field_151579_a ? PathNodeType.OPEN : (block != Blocks.field_150415_aT && block != Blocks.field_180400_cw && block != Blocks.field_150392_bi ? (block == Blocks.field_150480_ab ? PathNodeType.DAMAGE_FIRE : (block == Blocks.field_150434_aF ? PathNodeType.DAMAGE_CACTUS : (block instanceof BlockDoor && material == Material.field_151575_d && !((Boolean)iblockstate.func_177229_b((IProperty)BlockDoor.field_176519_b)).booleanValue() ? PathNodeType.DOOR_WOOD_CLOSED : (block instanceof BlockDoor && material == Material.field_151573_f && !((Boolean)iblockstate.func_177229_b((IProperty)BlockDoor.field_176519_b)).booleanValue() ? PathNodeType.DOOR_IRON_CLOSED : (block instanceof BlockDoor && ((Boolean)iblockstate.func_177229_b((IProperty)BlockDoor.field_176519_b)).booleanValue() ? PathNodeType.DOOR_OPEN : (block instanceof BlockRailBase ? PathNodeType.RAIL : (!(block instanceof BlockFence || block instanceof BlockWall || block instanceof BlockFenceGate && !((Boolean)iblockstate.func_177229_b((IProperty)BlockFenceGate.field_176466_a)).booleanValue()) ? (material == Material.field_151586_h ? PathNodeType.WATER : (material == Material.field_151587_i ? PathNodeType.LAVA : (block.func_176205_b(blockAccess, blockpos) ? PathNodeType.OPEN : PathNodeType.BLOCKED))) : PathNodeType.FENCE))))))) : PathNodeType.TRAPDOOR);
    }

    protected PathPoint getFlightNode(int x, int y, int z) {
        PathNodeType pathnodetype = this.isFlyablePathNode(x, y, z);
        if (this.entityCreature != null && this.entityCreature.isStrongSwimmer() && pathnodetype == PathNodeType.WATER) {
            return this.func_176159_a(x, y, z);
        }
        return pathnodetype == PathNodeType.OPEN ? this.func_176159_a(x, y, z) : null;
    }

    protected PathNodeType isFlyablePathNode(int x, int y, int z) {
        BlockPos.MutableBlockPos blockpos$mutableblockpos = new BlockPos.MutableBlockPos();
        for (int i = x; i < x + this.field_176168_c; ++i) {
            for (int j = y; j < y + this.field_176165_d; ++j) {
                for (int k = z; k < z + this.field_176166_e; ++k) {
                    IBlockState iblockstate = this.field_176169_a.func_180495_p((BlockPos)blockpos$mutableblockpos.func_181079_c(i, j, k));
                    if (!iblockstate.func_185904_a().func_76220_a() && !iblockstate.func_185904_a().func_76224_d()) {
                        if (!iblockstate.func_185904_a().func_76220_a() && !iblockstate.func_185904_a().func_76224_d()) {
                            return PathNodeType.OPEN;
                        }
                        return PathNodeType.OPEN;
                    }
                    if (iblockstate.func_185904_a() == Material.field_151579_a) continue;
                    if (this.entityCreature != null && this.entityCreature.isStrongSwimmer()) {
                        return this.isSwimmablePathNode(x, y, z);
                    }
                    return PathNodeType.BLOCKED;
                }
            }
        }
        return PathNodeType.OPEN;
    }

    private PathPoint getWaterNode(int x, int y, int z) {
        PathNodeType pathnodetype = null;
        if (this.entityCreature != null && this.entityCreature.isFlying()) {
            pathnodetype = this.isFlyablePathNode(x, y, z);
            if (pathnodetype == PathNodeType.OPEN) {
                return this.func_176159_a(x, y, z);
            }
        } else {
            pathnodetype = this.isSwimmablePathNode(x, y, z);
        }
        return pathnodetype == PathNodeType.WATER ? this.func_176159_a(x, y, z) : null;
    }

    private PathNodeType isSwimmablePathNode(int x, int y, int z) {
        BlockPos.MutableBlockPos blockpos$mutableblockpos = new BlockPos.MutableBlockPos();
        for (int i = x; i < x + this.field_176168_c; ++i) {
            for (int j = y; j < y + Math.min(this.field_176165_d, 3); ++j) {
                for (int k = z; k < z + this.field_176166_e; ++k) {
                    IBlockState iblockstate = this.field_176169_a.func_180495_p((BlockPos)blockpos$mutableblockpos.func_181079_c(i, j, k));
                    if (this.entityCreature == null) {
                        return PathNodeType.BLOCKED;
                    }
                    if (!this.entityCreature.waterDamage()) {
                        if (iblockstate.func_185904_a() == Material.field_151586_h) continue;
                        if (!this.entityCreature.canFreeze() && iblockstate.func_177230_c() != ObjectManager.getBlock("ooze")) {
                            return PathNodeType.BLOCKED;
                        }
                        return PathNodeType.BLOCKED;
                    }
                    if (!(!this.entityCreature.canBurn() ? iblockstate.func_185904_a() != Material.field_151587_i : !this.entityCreature.canFreeze() && iblockstate.func_177230_c() != ObjectManager.getBlock("ooze"))) continue;
                    return PathNodeType.BLOCKED;
                }
            }
        }
        return PathNodeType.WATER;
    }
}

