/*
 * Decompiled with CFR 0.152.
 */
package com.lycanitesmobs.core.entity.navigate;

import com.lycanitesmobs.core.entity.navigate.ArenaNode;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;

public class ArenaNodeNetwork {
    public World world;
    public List<ArenaNode> nodes = new ArrayList<ArenaNode>();
    public ArenaNode centralNode;

    public ArenaNodeNetwork(World world) {
        this.world = world;
    }

    public void addNode(ArenaNode node, ArenaNode ... adjacentNodes) {
        if (node == null || this.nodes.contains(node)) {
            return;
        }
        this.addNode(node);
        for (ArenaNode adjacentNode : adjacentNodes) {
            node.addAdjacentNode(adjacentNode);
        }
    }

    public void addNode(ArenaNode node) {
        if (node == null || this.nodes.contains(node)) {
            return;
        }
        this.nodes.add(node);
    }

    public ArenaNode getClosestNode(BlockPos targetPos) {
        int nodesSize = this.nodes.size();
        if (nodesSize <= 0) {
            return null;
        }
        if (nodesSize == 1) {
            return this.nodes.get(0);
        }
        double smallestDistance = 0.0;
        ArenaNode closestNode = null;
        for (ArenaNode node : this.nodes) {
            double distance = targetPos.func_177951_i((Vec3i)node.pos);
            if (closestNode != null && !(distance < smallestDistance)) continue;
            smallestDistance = distance;
            closestNode = node;
        }
        return closestNode;
    }
}

