/*
 * Decompiled with CFR 0.152.
 */
package com.lycanitesmobs.core.entity.creature;

import com.lycanitesmobs.ObjectManager;
import com.lycanitesmobs.core.entity.BaseCreatureEntity;
import com.lycanitesmobs.core.entity.goals.actions.AttackRangedGoal;
import com.lycanitesmobs.core.entity.goals.actions.WanderGoal;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EnumCreatureAttribute;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.monster.IMob;
import net.minecraft.init.Blocks;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;

public class EntityWendigo
extends BaseCreatureEntity
implements IMob {
    WanderGoal wanderAI;

    public EntityWendigo(World world) {
        super(world);
        this.attribute = EnumCreatureAttribute.UNDEAD;
        this.spawnsOnLand = true;
        this.spawnsInWater = true;
        this.hasAttackSound = false;
        this.setupMob();
    }

    @Override
    protected void func_184651_r() {
        super.func_184651_r();
        this.field_70714_bg.func_75776_a(this.nextCombatGoalIndex++, (EntityAIBase)new AttackRangedGoal(this).setSpeed(1.0).setRange(16.0f).setMinChaseDistance(8.0f));
    }

    @Override
    public void func_70636_d() {
        Block block;
        super.func_70636_d();
        if (!this.func_130014_f_().field_72995_K && this.isMoving() && this.field_70173_aa % 5 == 0) {
            int trailHeight = 1;
            int trailWidth = 1;
            if (this.isRareVariant()) {
                trailWidth = 3;
            }
            for (int y = 0; y < trailHeight; ++y) {
                Block block2 = this.func_130014_f_().func_180495_p(this.func_180425_c().func_177982_a(0, y, 0)).func_177230_c();
                if (block2 == null || block2 != Blocks.field_150350_a && block2 != Blocks.field_150480_ab && block2 != Blocks.field_150433_aE && block2 != Blocks.field_150329_H && block2 != ObjectManager.getBlock("scorchfire") && block2 != ObjectManager.getBlock("doomfire")) continue;
                if (trailWidth == 1) {
                    this.func_130014_f_().func_175656_a(this.func_180425_c().func_177982_a(0, y, 0), ObjectManager.getBlock("frostfire").func_176223_P());
                    continue;
                }
                for (int x = -(trailWidth / 2); x < trailWidth / 2 + 1; ++x) {
                    for (int z = -(trailWidth / 2); z < trailWidth / 2 + 1; ++z) {
                        this.func_130014_f_().func_175656_a(this.func_180425_c().func_177982_a(x, y, z), ObjectManager.getBlock("frostfire").func_176223_P());
                    }
                }
            }
        }
        if (!this.func_130014_f_().field_72995_K && this.isMoving() && this.field_70173_aa % 5 == 0 && (block = this.func_130014_f_().func_180495_p(this.func_180425_c().func_177982_a(0, -1, 0)).func_177230_c()) == Blocks.field_150355_j) {
            this.func_130014_f_().func_175656_a(this.func_180425_c().func_177982_a(0, -1, 0), Blocks.field_150432_aD.func_176223_P());
        }
        if (this.func_130014_f_().field_72995_K) {
            int i;
            for (i = 0; i < 2; ++i) {
                this.func_130014_f_().func_175688_a(EnumParticleTypes.SNOWBALL, this.field_70165_t + (this.field_70146_Z.nextDouble() - 0.5) * (double)this.field_70130_N, this.field_70163_u + this.field_70146_Z.nextDouble() * (double)this.field_70131_O, this.field_70161_v + (this.field_70146_Z.nextDouble() - 0.5) * (double)this.field_70130_N, 0.0, 0.0, 0.0, new int[0]);
                this.func_130014_f_().func_175688_a(EnumParticleTypes.SNOWBALL, this.field_70165_t + (this.field_70146_Z.nextDouble() - 0.5) * (double)this.field_70130_N, this.field_70163_u + this.field_70146_Z.nextDouble() * (double)this.field_70131_O, this.field_70161_v + (this.field_70146_Z.nextDouble() - 0.5) * (double)this.field_70130_N, 0.0, 0.0, 0.0, new int[0]);
            }
            if (this.field_70173_aa % 10 == 0) {
                for (i = 0; i < 2; ++i) {
                    this.func_130014_f_().func_175688_a(EnumParticleTypes.SNOWBALL, this.field_70165_t + (this.field_70146_Z.nextDouble() - 0.5) * (double)this.field_70130_N, this.field_70163_u + this.field_70146_Z.nextDouble() * (double)this.field_70131_O, this.field_70161_v + (this.field_70146_Z.nextDouble() - 0.5) * (double)this.field_70130_N, 0.0, 0.0, 0.0, new int[0]);
                }
            }
        }
    }

    @Override
    public float getAISpeedModifier() {
        if (this.func_70090_H()) {
            return 2.0f;
        }
        return 1.0f;
    }

    @Override
    public float getBlockPathWeight(int x, int y, int z) {
        int waterWeight = 10;
        BlockPos pos = new BlockPos(x, y, z);
        if (ObjectManager.getBlock("ooze") != null && this.func_130014_f_().func_180495_p(pos).func_177230_c() == ObjectManager.getBlock("ooze")) {
            return (super.getBlockPathWeight(x, y, z) + 1.0f) * (float)(waterWeight + 1);
        }
        if (this.func_70638_az() != null) {
            return super.getBlockPathWeight(x, y, z);
        }
        if (this.func_70090_H()) {
            return -999999.0f;
        }
        return super.getBlockPathWeight(x, y, z);
    }

    @Override
    public boolean func_96092_aw() {
        return false;
    }

    @Override
    public void attackRanged(Entity target, float range) {
        this.fireProjectile("tundra", target, range, 0.0f, new Vec3d(0.0, 0.0, 0.0), 1.2f, 2.0f, 1.0f);
        super.attackRanged(target, range);
    }

    @Override
    public int getNoBagSize() {
        return 0;
    }

    @Override
    public int getBagSize() {
        return this.creatureInfo.bagSize;
    }

    @Override
    public boolean isDamageTypeApplicable(String type, DamageSource source, float damage) {
        if (type.equals("ooze")) {
            return false;
        }
        return super.isDamageTypeApplicable(type, source, damage);
    }

    @Override
    public boolean func_70648_aU() {
        return true;
    }
}

