/*
 * Decompiled with CFR 0.152.
 */
package com.lycanitesmobs.core.entity.creature;

import com.lycanitesmobs.core.dungeon.DungeonManager;
import com.lycanitesmobs.core.entity.AgeableCreatureEntity;
import com.lycanitesmobs.core.entity.BaseCreatureEntity;
import com.lycanitesmobs.core.entity.CreatureBuildTask;
import com.lycanitesmobs.core.entity.CreatureStructure;
import com.lycanitesmobs.core.entity.TameableCreatureEntity;
import com.lycanitesmobs.core.entity.creature.EntityConba;
import com.lycanitesmobs.core.entity.creature.EntityVespid;
import com.lycanitesmobs.core.entity.goals.actions.AttackMeleeGoal;
import com.lycanitesmobs.core.entity.goals.actions.StayByHomeGoal;
import com.lycanitesmobs.core.entity.goals.targeting.FindAttackTargetGoal;
import com.lycanitesmobs.core.info.CreatureManager;
import com.lycanitesmobs.core.item.consumable.CreatureTreatItem;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EnumCreatureAttribute;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.monster.IMob;
import net.minecraft.item.ItemStack;
import net.minecraft.util.DamageSource;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.World;

public class EntityVespidQueen
extends TameableCreatureEntity
implements IMob {
    public final CreatureStructure creatureStructure;
    protected int swarmLimit = 10;

    public EntityVespidQueen(World world) {
        super(world);
        this.attribute = EnumCreatureAttribute.ARTHROPOD;
        this.hasAttackSound = true;
        this.solidCollision = true;
        this.setupMob();
        this.canGrow = true;
        this.babySpawnChance = 0.0;
        this.field_70138_W = 1.0f;
        this.setAttackCooldownMax(10);
        this.creatureStructure = new CreatureStructure(this, DungeonManager.getInstance().getTheme("vespid_hive"));
    }

    @Override
    protected void func_184651_r() {
        super.func_184651_r();
        this.field_70714_bg.func_75776_a(this.nextCombatGoalIndex++, (EntityAIBase)new AttackMeleeGoal(this).setLongMemory(true));
        this.field_70714_bg.func_75776_a(this.nextTravelGoalIndex++, (EntityAIBase)new StayByHomeGoal(this));
        this.field_70715_bh.func_75776_a(this.nextFindTargetIndex++, (EntityAIBase)new FindAttackTargetGoal(this).addTargets(((Object)((Object)this)).getClass()));
        Class<? extends EntityLiving> conbaType = CreatureManager.getInstance().getEntityClass("conba");
        if (conbaType != null) {
            this.field_70715_bh.func_75776_a(this.nextFindTargetIndex++, (EntityAIBase)new FindAttackTargetGoal(this).addTargets(conbaType));
        }
    }

    @Override
    public void loadCreatureFlags() {
        this.swarmLimit = this.creatureInfo.getFlag("swarmLimit", this.swarmLimit);
    }

    @Override
    public boolean isPersistant() {
        if (this.hasHome() && this.func_130014_f_().func_175659_aa() != EnumDifficulty.PEACEFUL) {
            return true;
        }
        return super.isPersistant();
    }

    @Override
    public void func_70636_d() {
        super.func_70636_d();
        if (this.func_130014_f_().field_72995_K) {
            return;
        }
        if (this.updateTick > 0L && this.updateTick % 20L == 0L) {
            if (!this.hasHome()) {
                this.creatureStructure.setOrigin(this.func_180425_c());
            }
            if (!this.creatureStructure.isPhaseComplete(0) || this.updateTick % 200L == 0L) {
                this.creatureStructure.refreshBuildTasks();
            }
            if (this.hasHome() && this.creatureStructure.getFinalPhaseBuildTaskSize() <= 10 && this.updateTick % 60L == 0L) {
                this.allyUpdate();
            }
        }
        if (!this.func_130014_f_().field_72995_K && this.func_70638_az() instanceof EntityConba && ((EntityConba)this.func_70638_az()).vespidInfection) {
            this.func_70624_b(null);
        }
    }

    @Override
    public void onBuildTaskComplete(CreatureBuildTask buildTask) {
        super.onBuildTaskComplete(buildTask);
        if (!this.hasHome()) {
            this.setHome(this.creatureStructure.getOrigin().func_177958_n(), this.creatureStructure.getOrigin().func_177956_o(), this.creatureStructure.getOrigin().func_177952_p(), 8.0f);
        }
    }

    @Override
    public void setHomePosition(int x, int y, int z) {
        super.setHomePosition(x, y, z);
        this.creatureStructure.setOrigin(new BlockPos(x, y, z));
    }

    @Override
    public boolean rollWanderChance() {
        if (this.hasHome()) {
            return false;
        }
        return this.func_70681_au().nextDouble() <= 8.0E-4;
    }

    public void allyUpdate() {
        EntityLivingBase minion;
        float random;
        if (this.func_130014_f_().field_72995_K) {
            return;
        }
        if (this.swarmLimit > 0 && this.nearbyCreatureCount(CreatureManager.getInstance().getCreature("vespid").getEntityClass(), 32.0) < this.swarmLimit && (random = this.field_70146_Z.nextFloat()) <= 0.05f && (minion = this.spawnAlly(this.field_70165_t - 2.0 + (double)(random * 4.0f), this.field_70163_u, this.field_70161_v - 2.0 + (double)(random * 4.0f))) instanceof AgeableCreatureEntity) {
            ((AgeableCreatureEntity)minion).setGrowingAge(((AgeableCreatureEntity)minion).growthTime);
        }
    }

    public EntityLivingBase spawnAlly(double x, double y, double z) {
        EntityLiving minion = CreatureManager.getInstance().getCreature("vespid").createEntity(this.func_130014_f_());
        minion.func_70012_b(x, y, z, this.field_70146_Z.nextFloat() * 360.0f, 0.0f);
        if (minion instanceof BaseCreatureEntity) {
            ((BaseCreatureEntity)minion).applyVariant(this.getVariantIndex());
        }
        this.func_130014_f_().func_72838_d((Entity)minion);
        if (this.func_70638_az() != null) {
            minion.func_70604_c(this.func_70638_az());
        }
        return minion;
    }

    @Override
    public boolean attackMelee(Entity target, double damageScale) {
        if (!super.attackMelee(target, damageScale)) {
            return false;
        }
        if (target instanceof EntityConba) {
            ((EntityConba)target).vespidInfection = true;
            return true;
        }
        return true;
    }

    @Override
    public boolean canAttackEntity(EntityLivingBase targetEntity) {
        if (targetEntity instanceof EntityConba && ((EntityConba)targetEntity).vespidInfection) {
            return false;
        }
        if (targetEntity instanceof EntityVespid && (!((EntityVespid)targetEntity).hasMaster() || ((EntityVespid)targetEntity).getMasterTarget() == this)) {
            return false;
        }
        return super.canAttackEntity(targetEntity);
    }

    @Override
    public boolean canAttackOwnSpecies() {
        return true;
    }

    @Override
    public boolean canBeTempted() {
        return true;
    }

    @Override
    public boolean isTamingItem(ItemStack itemStack) {
        CreatureTreatItem itemTreat;
        if (itemStack.func_190926_b() || this.creatureInfo.creatureType == null) {
            return false;
        }
        if (itemStack.func_77973_b() instanceof CreatureTreatItem && (itemTreat = (CreatureTreatItem)itemStack.func_77973_b()).getCreatureType() == this.creatureInfo.creatureType) {
            return true;
        }
        return super.isTamingItem(itemStack);
    }

    @Override
    public boolean isFlying() {
        return true;
    }

    @Override
    public boolean func_70104_M() {
        return false;
    }

    @Override
    public float getDamageModifier(DamageSource damageSrc) {
        if (damageSrc.func_76347_k()) {
            return 4.0f;
        }
        return 1.0f;
    }

    @Override
    public boolean isDamageTypeApplicable(String type, DamageSource source, float damage) {
        if (type.equals("inWall")) {
            return false;
        }
        return super.isDamageTypeApplicable(type, source, damage);
    }

    public void func_70106_y() {
        if (this.creatureStructure != null) {
            this.creatureStructure.removePitBLocks();
        }
        super.func_70106_y();
    }
}

