/*
 * Decompiled with CFR 0.152.
 */
package com.lycanitesmobs.core.entity.creature;

import com.lycanitesmobs.core.entity.TameableCreatureEntity;
import com.lycanitesmobs.core.entity.goals.actions.AttackMeleeGoal;
import com.lycanitesmobs.core.info.ObjectLists;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EnumCreatureAttribute;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.MobEffects;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumHand;
import net.minecraft.world.World;

public class EntityShambler
extends TameableCreatureEntity
implements IMob {
    public EntityShambler(World world) {
        super(world);
        this.attribute = EnumCreatureAttribute.UNDEFINED;
        this.spawnsUnderground = true;
        this.hasAttackSound = true;
        this.spreadFire = true;
        this.canGrow = true;
        this.babySpawnChance = 0.01;
        this.setupMob();
    }

    @Override
    protected void func_184651_r() {
        super.func_184651_r();
        this.field_70714_bg.func_75776_a(this.nextCombatGoalIndex++, (EntityAIBase)new AttackMeleeGoal(this).setTargetClass(EntityPlayer.class).setLongMemory(false));
        this.field_70714_bg.func_75776_a(this.nextCombatGoalIndex++, (EntityAIBase)new AttackMeleeGoal(this));
    }

    @Override
    public void func_70636_d() {
        super.func_70636_d();
        if (this.func_70086_ai() >= 0) {
            if (this.func_70090_H()) {
                this.func_70690_d(new PotionEffect(MobEffects.field_76428_l, 60, 2));
            } else if (this.waterContact()) {
                this.func_70690_d(new PotionEffect(MobEffects.field_76428_l, 60, 1));
            }
        }
    }

    @Override
    public boolean attackMelee(Entity target, double damageScale) {
        if (!super.attackMelee(target, damageScale)) {
            return false;
        }
        float leeching = this.getEffectStrength(this.getAttackDamage(damageScale) / 2.0f);
        this.func_70691_i(leeching);
        return true;
    }

    @Override
    public float getDamageModifier(DamageSource damageSrc) {
        if (damageSrc.func_76347_k()) {
            return 2.0f;
        }
        if (damageSrc.func_76346_g() != null) {
            EntityLivingBase entityLiving;
            ItemStack heldItem = ItemStack.field_190927_a;
            if (damageSrc.func_76346_g() instanceof EntityLivingBase && !(entityLiving = (EntityLivingBase)damageSrc.func_76346_g()).func_184586_b(EnumHand.MAIN_HAND).func_190926_b()) {
                heldItem = entityLiving.func_184586_b(EnumHand.MAIN_HAND);
            }
            if (ObjectLists.isAxe(heldItem)) {
                return 2.0f;
            }
        }
        return super.getDamageModifier(damageSrc);
    }

    @Override
    public int getNoBagSize() {
        return 0;
    }

    @Override
    public int getBagSize() {
        return this.creatureInfo.bagSize;
    }

    @Override
    public boolean petControlsEnabled() {
        return true;
    }
}

