/*
 * Decompiled with CFR 0.152.
 */
package com.lycanitesmobs.core.entity.creature;

import com.lycanitesmobs.ObjectManager;
import com.lycanitesmobs.PotionBase;
import com.lycanitesmobs.core.entity.TameableCreatureEntity;
import com.lycanitesmobs.core.entity.goals.actions.AttackMeleeGoal;
import com.lycanitesmobs.core.entity.goals.actions.abilities.StealthGoal;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EnumCreatureAttribute;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.Potion;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class EntityLurker
extends TameableCreatureEntity {
    public EntityLurker(World world) {
        super(world);
        this.attribute = EnumCreatureAttribute.ARTHROPOD;
        this.hasAttackSound = true;
        this.trueSight = true;
        this.setupMob();
    }

    @Override
    protected void func_184651_r() {
        super.func_184651_r();
        this.field_70714_bg.func_75776_a(this.nextPriorityGoalIndex++, (EntityAIBase)new StealthGoal(this).setStealthTime(20).setStealthAttack(true).setStealthMove(true));
        this.field_70714_bg.func_75776_a(this.nextCombatGoalIndex++, (EntityAIBase)new AttackMeleeGoal(this).setLongMemory(false));
    }

    @Override
    public void func_70636_d() {
        super.func_70636_d();
        if (this.func_70638_az() != null) {
            PotionBase stalkingEffect = ObjectManager.getEffect("plague");
            if (stalkingEffect != null && this.func_70638_az().func_70644_a((Potion)stalkingEffect)) {
                this.setAvoidTarget(this.func_70638_az());
            } else {
                this.setAvoidTarget(null);
            }
        } else {
            this.setAvoidTarget(null);
        }
        if (this.field_70122_E && !this.func_130014_f_().field_72995_K && this.field_70146_Z.nextInt(10) == 0) {
            if (this.hasAttackTarget()) {
                this.leap(6.0f, 0.4, (Entity)this.func_70638_az());
            } else if (this.hasAvoidTarget()) {
                this.leap(4.0, 0.4);
            }
        }
    }

    @Override
    public boolean canStealth() {
        if (this.func_130014_f_().field_72995_K) {
            return false;
        }
        if (this.hasAttackTarget()) {
            PotionBase stalkingEffect;
            if (this.func_70638_az() instanceof EntityPlayer) {
                EntityPlayer playerTarget = (EntityPlayer)this.func_70638_az();
                ItemStack itemstack = playerTarget.field_71071_by.func_70448_g();
                if (this.isTamingItem(itemstack)) {
                    return false;
                }
            }
            if ((stalkingEffect = ObjectManager.getEffect("plague")) != null && !this.func_70638_az().func_70644_a((Potion)stalkingEffect)) {
                return false;
            }
            if ((double)this.func_70032_d((Entity)this.func_70638_az()) < 25.0) {
                return false;
            }
        } else if (this.isMoving()) {
            return false;
        }
        return true;
    }

    @Override
    public void startStealth() {
        if (this.func_130014_f_().field_72995_K) {
            EnumParticleTypes particle = EnumParticleTypes.SMOKE_LARGE;
            double d0 = this.field_70146_Z.nextGaussian() * 0.02;
            double d1 = this.field_70146_Z.nextGaussian() * 0.02;
            double d2 = this.field_70146_Z.nextGaussian() * 0.02;
            for (int i = 0; i < 100; ++i) {
                this.func_130014_f_().func_175688_a(particle, this.field_70165_t + (double)(this.field_70146_Z.nextFloat() * this.field_70130_N * 2.0f) - (double)this.field_70130_N, this.field_70163_u + 0.5 + (double)(this.field_70146_Z.nextFloat() * this.field_70131_O), this.field_70161_v + (double)(this.field_70146_Z.nextFloat() * this.field_70130_N * 2.0f) - (double)this.field_70130_N, d0, d1, d2, new int[0]);
            }
        }
        super.startStealth();
    }

    @Override
    public boolean canClimb() {
        return true;
    }

    @Override
    public boolean petControlsEnabled() {
        return true;
    }

    @Override
    public int getNoBagSize() {
        return 0;
    }

    @Override
    public int getBagSize() {
        return this.creatureInfo.bagSize;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_98034_c(EntityPlayer player) {
        if (this.isTamed() && this.func_70902_q() == player) {
            return false;
        }
        return this.func_82150_aj();
    }
}

