/*
 * Decompiled with CFR 0.152.
 */
package com.lycanitesmobs.core.entity.creature;

import com.lycanitesmobs.core.entity.AgeableCreatureEntity;
import com.lycanitesmobs.core.entity.BaseCreatureEntity;
import com.lycanitesmobs.core.entity.creature.EntityConcapedeHead;
import com.lycanitesmobs.core.entity.goals.actions.FollowParentGoal;
import com.lycanitesmobs.core.info.CreatureManager;
import java.util.List;
import java.util.UUID;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EnumCreatureAttribute;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.DamageSource;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;

public class EntityConcapedeSegment
extends AgeableCreatureEntity {
    UUID parentUUID = null;
    public BaseCreatureEntity backSegment;

    public EntityConcapedeSegment(World world) {
        super(world);
        this.attribute = EnumCreatureAttribute.ARTHROPOD;
        this.hasAttackSound = true;
        this.hasStepSound = false;
        this.canGrow = true;
        this.babySpawnChance = 0.0;
        this.isAggressiveByDefault = false;
        this.setupMob();
    }

    @Override
    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(this.nextTravelGoalIndex++, (EntityAIBase)new FollowParentGoal(this).setSpeed(4.0).setStrayDistance(4.0));
        super.func_184651_r();
    }

    @Override
    public boolean environmentSpawnCheck(World world, BlockPos pos) {
        if (this.getNearbyEntities(EntityConcapedeHead.class, null, CreatureManager.getInstance().spawnConfig.spawnLimitRange).size() <= 0) {
            return false;
        }
        return super.environmentSpawnCheck(world, pos);
    }

    @Override
    public void getRandomVariant() {
        if (this.subspecies == null && !this.hasParent()) {
            this.subspecies = this.creatureInfo.getRandomSubspecies((EntityLivingBase)this);
        }
        if (this.hasParent() && this.getParentTarget() instanceof BaseCreatureEntity) {
            this.applyVariant(((BaseCreatureEntity)this.getParentTarget()).getSubspeciesIndex());
        }
    }

    @Override
    protected boolean func_70692_ba() {
        if (!super.func_70692_ba()) {
            return false;
        }
        return !this.hasParent();
    }

    @Override
    public void func_70071_h_() {
        if (!this.func_130014_f_().field_72995_K && !this.hasParent() && this.parentUUID != null && this.updateTick > 0L && this.updateTick % 40L == 0L) {
            double range = 64.0;
            List connections = this.func_130014_f_().func_72872_a(AgeableCreatureEntity.class, this.func_174813_aQ().func_72314_b(range, range, range));
            for (AgeableCreatureEntity possibleConnection : connections) {
                if (possibleConnection == this || !possibleConnection.func_110124_au().equals(this.parentUUID)) continue;
                this.setParentTarget((EntityLivingBase)possibleConnection);
                break;
            }
            this.parentUUID = null;
        }
        super.func_70071_h_();
        if (!this.func_130014_f_().field_72995_K) {
            if (this.backSegment != null && !this.backSegment.func_70089_S()) {
                this.backSegment = null;
            }
            if (this.hasParent() && !this.getParentTarget().func_70089_S()) {
                this.setParentTarget(null);
            }
            if (this.hasParent()) {
                this.func_70671_ap().func_75651_a((Entity)this.getParentTarget(), 360.0f, 360.0f);
                this.func_70625_a((Entity)this.getParentTarget(), 360.0f, 360.0f);
                Vec3d parentPos = this.getFacingPositionDouble(this.getParentTarget().field_70165_t, this.getParentTarget().field_70163_u, this.getParentTarget().field_70161_v, -0.65, this.getParentTarget().field_70177_z);
                double segmentPullThreshold = 0.15;
                double segmentDistance = Math.sqrt(this.func_70092_e(parentPos.field_72450_a, parentPos.field_72448_b, parentPos.field_72449_c));
                if (segmentDistance > segmentPullThreshold) {
                    double dragAmount = segmentPullThreshold / 2.0;
                    Vec3d dragPos = this.getFacingPositionDouble(parentPos.field_72450_a, parentPos.field_72448_b, parentPos.field_72449_c, dragAmount, this.func_174791_d().func_72430_b(parentPos));
                    double distY = parentPos.field_72448_b - this.field_70163_u;
                    double dragY = this.field_70163_u + distY / 2.0;
                    this.func_70107_b(dragPos.field_72450_a, dragY, dragPos.field_72449_c);
                }
            }
            if (!this.func_130014_f_().field_72995_K && this.getGrowingAge() <= 0) {
                this.setGrowingAge(-this.growthTime);
            }
        }
    }

    @Override
    public boolean rollLookChance() {
        if (this.hasParent()) {
            return false;
        }
        return super.rollLookChance();
    }

    @Override
    public boolean rollWanderChance() {
        if (this.hasParent()) {
            return false;
        }
        return super.rollWanderChance();
    }

    @Override
    public boolean isFlying() {
        return false;
    }

    @Override
    public boolean func_70685_l(Entity target) {
        return this.hasParent() && target == this.getParentTarget();
    }

    @Override
    public boolean func_70104_M() {
        return !this.hasParent();
    }

    @Override
    public void setGrowingAge(int age) {
        if (this.hasParent()) {
            age = -this.growthTime;
        }
        super.setGrowingAge(age);
        if (age == 0 && !this.func_130014_f_().field_72995_K) {
            EntityConcapedeHead concapedeHead = (EntityConcapedeHead)CreatureManager.getInstance().getCreature("concapede").createEntity(this.func_130014_f_());
            concapedeHead.func_82149_j((Entity)this);
            concapedeHead.firstSpawn = false;
            concapedeHead.setGrowingAge(-this.growthTime / 4);
            concapedeHead.setSizeScale(this.sizeScale);
            concapedeHead.applyVariant(this.getVariantIndex());
            this.func_130014_f_().func_72838_d((Entity)concapedeHead);
            if (this.backSegment != null) {
                this.backSegment.setParentTarget((EntityLivingBase)concapedeHead);
            }
            this.func_70106_y();
        }
    }

    @Override
    public boolean shouldFollowParent() {
        return true;
    }

    @Override
    public float getBlockPathWeight(int x, int y, int z) {
        IBlockState blockState = this.func_130014_f_().func_180495_p(new BlockPos(x, y - 1, z));
        Block block = blockState.func_177230_c();
        if (block != Blocks.field_150350_a) {
            if (blockState.func_185904_a() == Material.field_151577_b) {
                return 10.0f;
            }
            if (blockState.func_185904_a() == Material.field_151578_c) {
                return 7.0f;
            }
        }
        return super.getBlockPathWeight(x, y, z);
    }

    @Override
    public boolean func_184652_a(EntityPlayer player) {
        return !this.hasParent();
    }

    @Override
    public double getFallingMod() {
        if (this.func_130014_f_().field_72995_K) {
            return 0.0;
        }
        if (this.hasParent() && this.getParentTarget().field_70163_u > this.field_70163_u) {
            return 0.0;
        }
        return super.getFallingMod();
    }

    @Override
    public void setParentTarget(EntityLivingBase setTarget) {
        if (setTarget != this) {
            if (setTarget instanceof EntityConcapedeSegment) {
                ((EntityConcapedeSegment)setTarget).backSegment = this;
            }
            if (setTarget instanceof EntityConcapedeHead) {
                ((EntityConcapedeHead)setTarget).backSegment = this;
            }
        }
        super.setParentTarget(setTarget);
    }

    @Override
    public boolean renderVariantNameTag() {
        return !this.hasParent();
    }

    @Override
    public boolean canClimb() {
        return true;
    }

    @Override
    public int getNoBagSize() {
        return 0;
    }

    @Override
    public int getBagSize() {
        return this.creatureInfo.bagSize;
    }

    @Override
    public boolean isDamageTypeApplicable(String type, DamageSource source, float damage) {
        if (type.equals("inWall")) {
            return false;
        }
        return super.isDamageTypeApplicable(type, source, damage);
    }

    @Override
    public float getFallResistance() {
        return 100.0f;
    }

    @Override
    public AgeableCreatureEntity createChild(AgeableCreatureEntity partner) {
        return null;
    }

    @Override
    public boolean breed() {
        if (!this.canBreed()) {
            return false;
        }
        this.setGrowingAge(0);
        return true;
    }

    @Override
    public boolean canBreed() {
        return !this.hasParent();
    }

    @Override
    public boolean shouldFindParent() {
        return false;
    }

    @Override
    public void func_70037_a(NBTTagCompound nbtTagCompound) {
        if (nbtTagCompound.func_186855_b("ParentUUID")) {
            this.parentUUID = nbtTagCompound.func_186857_a("ParentUUID");
        }
        super.func_70037_a(nbtTagCompound);
    }

    @Override
    public void func_70014_b(NBTTagCompound nbtTagCompound) {
        super.func_70014_b(nbtTagCompound);
        if (this.hasParent()) {
            nbtTagCompound.func_186854_a("ParentUUID", this.getParentTarget().func_110124_au());
        }
    }
}

