/*
 * Decompiled with CFR 0.152.
 */
package com.lycanitesmobs.core.entity.creature;

import com.lycanitesmobs.core.entity.BaseCreatureEntity;
import com.lycanitesmobs.core.entity.goals.actions.AttackMeleeGoal;
import net.minecraft.block.BlockLog;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EnumCreatureAttribute;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.DamageSource;
import net.minecraft.world.World;

public class EntityCalpod
extends BaseCreatureEntity
implements IMob {
    private int swarmLimit = 5;
    private boolean griefing = true;

    public EntityCalpod(World world) {
        super(world);
        this.attribute = EnumCreatureAttribute.ARTHROPOD;
        this.hasAttackSound = true;
        this.setupMob();
    }

    @Override
    protected void func_184651_r() {
        super.func_184651_r();
        this.field_70714_bg.func_75776_a(this.nextCombatGoalIndex++, (EntityAIBase)new AttackMeleeGoal(this).setLongMemory(true));
    }

    @Override
    public void loadCreatureFlags() {
        this.swarmLimit = this.creatureInfo.getFlag("swarmLimit", this.swarmLimit);
        this.griefing = this.creatureInfo.getFlag("griefing", this.griefing);
    }

    @Override
    public void func_70636_d() {
        float distance;
        if (!this.func_130014_f_().field_72995_K && this.hasAttackTarget() && this.func_70638_az() instanceof EntityPlayer && this.updateTick % 60L == 0L) {
            this.allyUpdate();
        }
        if (!this.func_130014_f_().field_72995_K && this.func_70638_az() != null && this.func_130014_f_().func_82736_K().func_82766_b("mobGriefing") && this.griefing && (distance = this.func_70638_az().func_70032_d((Entity)this)) <= this.field_70130_N + 1.0f) {
            this.destroyAreaBlock((int)this.field_70165_t, (int)this.field_70163_u, (int)this.field_70161_v, BlockLog.class, true, 0);
        }
        super.func_70636_d();
    }

    public void allyUpdate() {
        float random;
        if (this.func_130014_f_().field_72995_K) {
            return;
        }
        if (this.swarmLimit > 0 && this.countAllies(64.0) < this.swarmLimit && (random = this.field_70146_Z.nextFloat()) <= 0.125f) {
            this.spawnAlly(this.field_70165_t - 2.0 + (double)(random * 4.0f), this.field_70163_u, this.field_70161_v - 2.0 + (double)(random * 4.0f));
        }
    }

    public void spawnAlly(double x, double y, double z) {
        BaseCreatureEntity minion = (BaseCreatureEntity)this.creatureInfo.createEntity(this.func_130014_f_());
        minion.func_70012_b(x, y, z, this.field_70146_Z.nextFloat() * 360.0f, 0.0f);
        minion.setMinion(true);
        minion.applyVariant(this.getVariantIndex());
        this.func_130014_f_().func_72838_d((Entity)minion);
        if (this.func_70638_az() != null) {
            minion.func_70604_c(this.func_70638_az());
        }
    }

    @Override
    public void func_70645_a(DamageSource par1DamageSource) {
        this.allyUpdate();
        super.func_70645_a(par1DamageSource);
    }

    @Override
    public boolean canClimb() {
        return true;
    }

    @Override
    public int getNoBagSize() {
        return 0;
    }

    @Override
    public int getBagSize() {
        return this.creatureInfo.bagSize;
    }

    @Override
    public float getFallResistance() {
        return 100.0f;
    }
}

