/*
 * Decompiled with CFR 0.152.
 */
package com.lycanitesmobs.core.entity;

import com.lycanitesmobs.GuiHandler;
import com.lycanitesmobs.LycanitesMobs;
import com.lycanitesmobs.client.localisation.LanguageManager;
import com.lycanitesmobs.core.VersionChecker;
import com.lycanitesmobs.core.entity.BaseCreatureEntity;
import com.lycanitesmobs.core.entity.PortalEntity;
import com.lycanitesmobs.core.info.Beastiary;
import com.lycanitesmobs.core.info.CreatureInfo;
import com.lycanitesmobs.core.info.CreatureKnowledge;
import com.lycanitesmobs.core.info.CreatureManager;
import com.lycanitesmobs.core.info.CreatureType;
import com.lycanitesmobs.core.item.equipment.ItemEquipment;
import com.lycanitesmobs.core.item.temp.ItemStaffSummoning;
import com.lycanitesmobs.core.network.MessagePetEntry;
import com.lycanitesmobs.core.network.MessagePetEntryRemove;
import com.lycanitesmobs.core.network.MessagePlayerStats;
import com.lycanitesmobs.core.network.MessageSummonSet;
import com.lycanitesmobs.core.network.MessageSummonSetSelection;
import com.lycanitesmobs.core.pets.PetEntry;
import com.lycanitesmobs.core.pets.PetManager;
import com.lycanitesmobs.core.pets.PlayerFamiliars;
import com.lycanitesmobs.core.pets.SummonSet;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.EnumHand;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class ExtendedPlayer {
    public EntityPlayer player;
    public Beastiary beastiary;
    public PetManager petManager;
    public long timePlayed = 0L;
    public CreatureType selectedCreatureType;
    public CreatureInfo selectedCreature;
    public int selectedSubspecies = 0;
    public int selectedVariant = 0;
    public int selectedPetType = 0;
    public PetEntry selectedPet;
    public long currentTick = 0L;
    public boolean needsFullSync = true;
    public IBlockState justBrokenBlock;
    protected int justBrokenClearTime;
    public byte controlStates = 0;
    public boolean hasAttacked = false;
    public int spiritCharge = 100;
    public int spiritMax;
    public int spirit = this.spiritMax = this.spiritCharge * 10;
    public int spiritReserved = 0;
    public int spiritRecharge = 10;
    public int selectedSummonSet = 1;
    public int summonFocusCharge = 600;
    public int summonFocusMax;
    public int summonFocus = this.summonFocusMax = this.summonFocusCharge * 10;
    public int summonFocusRecharge = 10;
    public Map<Integer, SummonSet> summonSets = new HashMap<Integer, SummonSet>();
    public int summonSetMax = 5;
    public PortalEntity staffPortal;
    public int creatureStudyCooldown = 0;
    public int creatureStudyCooldownMax = 200;
    private boolean initialSetup = false;

    public static ExtendedPlayer getForPlayer(EntityPlayer player) {
        if (player == null) {
            return null;
        }
        ExtendedPlayer extendedPlayer = (ExtendedPlayer)player.getCapability(LycanitesMobs.EXTENDED_PLAYER, null);
        if (extendedPlayer.player != player) {
            extendedPlayer.setPlayer(player);
        }
        return extendedPlayer;
    }

    public ExtendedPlayer() {
        this.beastiary = new Beastiary(this);
        this.petManager = new PetManager((EntityLivingBase)this.player);
        this.spiritRecharge = LycanitesMobs.config.getInt("Player", "Spirit Recharge", this.spiritRecharge, "How much spirit a player regains per second. Default is 10, was 1 in earlier versions.");
        this.summonFocusRecharge = LycanitesMobs.config.getInt("Player", "Summoning Focus Recharge", this.summonFocusRecharge, "How much summoning focus a player regains per second. Default is 10, was 1 in earlier versions.");
        this.creatureStudyCooldownMax = CreatureManager.getInstance().config.creatureStudyCooldown;
    }

    public void setPlayer(EntityPlayer player) {
        this.player = player;
        this.petManager.host = player;
    }

    public EntityPlayer getPlayer() {
        return this.player;
    }

    public boolean canMeleeBigEntity(Entity targetEntity) {
        double range;
        double distance;
        if (!(targetEntity instanceof EntityLivingBase)) {
            return false;
        }
        float targetWidth = targetEntity.field_70130_N;
        float targetHeight = targetEntity.field_70131_O;
        if (targetEntity instanceof BaseCreatureEntity) {
            BaseCreatureEntity targetCreature = (BaseCreatureEntity)targetEntity;
            targetWidth *= targetCreature.hitAreaWidthScale;
            targetHeight *= targetCreature.hitAreaHeightScale;
        }
        if (targetWidth <= 4.0f && targetHeight <= 4.0f) {
            return false;
        }
        double heightOffset = this.player.field_70163_u - targetEntity.field_70163_u;
        double heightCompensation = 0.0;
        if (heightOffset > 0.0) {
            heightCompensation = Math.min(heightOffset, (double)targetHeight);
        }
        return (distance = Math.sqrt(this.player.func_70032_d(targetEntity))) <= (range = 6.0 + heightCompensation + (double)(targetWidth / 2.0f));
    }

    public void meleeAttack(Entity targetEntity) {
        if (!this.hasAttacked && !this.player.func_184614_ca().func_190926_b() && this.canMeleeBigEntity(targetEntity)) {
            this.player.func_71059_n(targetEntity);
            this.player.func_184821_cY();
            this.player.func_184609_a(EnumHand.MAIN_HAND);
        }
    }

    public void onUpdate() {
        Object message;
        ++this.timePlayed;
        this.hasAttacked = false;
        boolean creative = this.player.field_71075_bZ.field_75098_d;
        boolean sync = false;
        if (this.justBrokenClearTime > 0 && --this.justBrokenClearTime <= 0) {
            this.justBrokenBlock = null;
        }
        this.spirit = Math.min(Math.max(this.spirit, 0), this.spiritMax - this.spiritReserved);
        if (this.spirit < this.spiritMax - this.spiritReserved) {
            this.spirit += this.spiritRecharge;
            if (!this.player.func_130014_f_().field_72995_K && this.currentTick % 20L == 0L || this.spirit == this.spiritMax - this.spiritReserved) {
                sync = true;
            }
        }
        this.summonFocus = Math.min(Math.max(this.summonFocus, 0), this.summonFocusMax);
        if (this.summonFocus < this.summonFocusMax) {
            this.summonFocus += this.summonFocusRecharge;
            if (!this.player.func_130014_f_().field_72995_K && !creative && this.currentTick % 20L == 0L || this.summonFocus < this.summonFocusMax || !this.player.func_184614_ca().func_190926_b() && this.player.func_184614_ca().func_77973_b() instanceof ItemStaffSummoning || !this.player.func_184592_cb().func_190926_b() && this.player.func_184592_cb().func_77973_b() instanceof ItemStaffSummoning) {
                sync = true;
            }
        }
        if (this.creatureStudyCooldown > 0) {
            --this.creatureStudyCooldown;
            sync = true;
        }
        if (!this.player.func_130014_f_().field_72995_K && sync) {
            message = new MessagePlayerStats(this);
            LycanitesMobs.packetHandler.sendToPlayer((IMessage)message, (EntityPlayerMP)this.player);
        }
        if (!this.initialSetup) {
            VersionChecker.VersionInfo latestVersion;
            if (!this.player.func_130014_f_().field_72995_K) {
                this.loadFamiliars();
            }
            if (this.player.func_130014_f_().field_72995_K && (latestVersion = VersionChecker.INSTANCE.getLatestVersion()) != null && latestVersion.isNewer && VersionChecker.INSTANCE.enabled) {
                this.player.func_145747_a((ITextComponent)new TextComponentString(LanguageManager.translate("lyc.version.newer").replace("{current}", "2.0.8.9").replace("{latest}", latestVersion.versionNumber)));
            }
            this.initialSetup = true;
        }
        if (!this.player.func_130014_f_().field_72995_K && this.needsFullSync) {
            this.beastiary.sendAllToClient();
            this.sendAllSummonSetsToPlayer();
            message = new MessageSummonSetSelection(this);
            LycanitesMobs.packetHandler.sendToPlayer((IMessage)message, (EntityPlayerMP)this.player);
            this.sendPetEntriesToPlayer("");
        }
        this.petManager.onUpdate(this.player.func_130014_f_());
        ++this.currentTick;
        this.needsFullSync = false;
        if (!this.isControlActive(CONTROL_ID.RIGHT_MOUSE) && (this.player.func_184614_ca().func_77973_b() instanceof ItemEquipment || this.player.func_184592_cb().func_77973_b() instanceof ItemEquipment)) {
            this.player.func_184597_cx();
        }
    }

    public void setJustBrokenBlock(IBlockState blockState) {
        this.justBrokenBlock = blockState;
        this.justBrokenClearTime = 60;
    }

    public SummonSet getSummonSet(int setID) {
        if (setID <= 0) {
            LycanitesMobs.logWarning("", "Attempted to access set " + setID + " but the minimum ID is 1. Player: " + this.player);
            return this.getSummonSet(1);
        }
        if (setID > this.summonSetMax) {
            LycanitesMobs.logWarning("", "Attempted to access set " + setID + " but the maximum set ID is " + this.summonSetMax + ". Player: " + this.player);
            return this.getSummonSet(this.summonSetMax);
        }
        if (!this.summonSets.containsKey(setID)) {
            this.summonSets.put(setID, new SummonSet(this));
        }
        return this.summonSets.get(setID);
    }

    public SummonSet getSelectedSummonSet() {
        return this.getSummonSet(this.selectedSummonSet);
    }

    public void setSelectedSummonSet(int targetSetID) {
        this.selectedSummonSet = targetSetID;
    }

    public int validateSummonSetID(int targetSetID) {
        for (targetSetID = Math.max(Math.min(targetSetID, this.summonSetMax), 1); !this.getSummonSet(targetSetID).isUseable() && targetSetID > 1 && !"".equals(this.getSummonSet((int)targetSetID).summonType); --targetSetID) {
        }
        return targetSetID;
    }

    public Beastiary getBeastiary() {
        return this.beastiary;
    }

    public void loadFamiliars() {
        Map<UUID, PetEntry> playerFamiliars = PlayerFamiliars.INSTANCE.getFamiliarsForPlayer(this.player);
        if (!playerFamiliars.isEmpty()) {
            for (PetEntry petEntry : playerFamiliars.values()) {
                if (this.petManager.hasEntry(petEntry)) {
                    PetEntry currentFamiliarEntry = this.petManager.getEntry(petEntry.petEntryID);
                    currentFamiliarEntry.copy(petEntry);
                    continue;
                }
                this.petManager.addEntry(petEntry);
                petEntry.entity = null;
            }
            this.sendPetEntriesToPlayer("familiar");
        }
    }

    public boolean studyCreature(Entity entity, int experience, boolean useCooldown, boolean alwaysShowMessage) {
        if (!(entity instanceof BaseCreatureEntity)) {
            if (useCooldown && !this.player.func_130014_f_().field_72995_K) {
                this.player.func_146105_b((ITextComponent)new TextComponentString(LanguageManager.translate("message.beastiary.unknown")), true);
            }
            return false;
        }
        if (useCooldown && this.creatureStudyCooldown > 0) {
            if (!this.player.func_130014_f_().field_72995_K) {
                this.player.func_146105_b((ITextComponent)new TextComponentString(LanguageManager.translate("message.beastiary.study.recharging")), true);
            }
            return false;
        }
        BaseCreatureEntity creature = (BaseCreatureEntity)entity;
        if (creature.isTamed()) {
            return false;
        }
        CreatureKnowledge newKnowledge = this.beastiary.addCreatureKnowledge((Entity)creature, experience = creature.scaleKnowledgeExperience(experience));
        if (newKnowledge != null) {
            if (useCooldown) {
                this.creatureStudyCooldown = this.creatureStudyCooldownMax;
            }
            if (!this.player.func_130014_f_().field_72995_K) {
                if (newKnowledge.getMaxExperience() == 0) {
                    this.player.func_146105_b((ITextComponent)new TextComponentString(LanguageManager.translate("message.beastiary.study.full") + " " + creature.creatureInfo.getTitle()), true);
                } else if (experience > 0) {
                    boolean showMessage = alwaysShowMessage;
                    if (!showMessage) {
                        float messageThreshold = (float)newKnowledge.getMaxExperience() * 0.25f;
                        int fromExperience = Math.max(0, newKnowledge.experience - experience);
                        int wrappedExperience = fromExperience % (int)messageThreshold;
                        boolean bl = showMessage = (float)(wrappedExperience + experience) >= messageThreshold;
                    }
                    if (showMessage) {
                        this.player.func_146105_b((ITextComponent)new TextComponentString(" " + LanguageManager.translate("message.beastiary.study") + newKnowledge.getCreatureInfo().getTitle() + " " + newKnowledge.experience + "/" + newKnowledge.getMaxExperience() + " (+" + experience + ")"), true);
                    }
                }
            }
            return true;
        }
        if (useCooldown && !this.player.func_130014_f_().field_72995_K) {
            this.player.func_146105_b((ITextComponent)new TextComponentString(LanguageManager.translate("message.beastiary.study.full") + " " + creature.creatureInfo.getTitle()), true);
        }
        return false;
    }

    public void onDeath() {
    }

    public void sendPetEntriesToPlayer(String entryType) {
        if (this.player.func_130014_f_().field_72995_K) {
            return;
        }
        LycanitesMobs.logDebug("Packets", "Sending all pet entries to client.");
        for (PetEntry petEntry : this.petManager.entries.values()) {
            if (!entryType.equals(petEntry.getType()) && !"".equals(entryType)) continue;
            MessagePetEntry message = new MessagePetEntry(this, petEntry);
            LycanitesMobs.packetHandler.sendToPlayer(message, (EntityPlayerMP)this.player);
        }
    }

    public void sendPetEntryToPlayer(PetEntry petEntry) {
        if (this.player.func_130014_f_().field_72995_K) {
            return;
        }
        MessagePetEntry message = new MessagePetEntry(this, petEntry);
        LycanitesMobs.packetHandler.sendToPlayer(message, (EntityPlayerMP)this.player);
    }

    public void sendPetEntryRemoveToPlayer(PetEntry petEntry) {
        if (this.player.func_130014_f_().field_72995_K) {
            return;
        }
        MessagePetEntryRemove message = new MessagePetEntryRemove(this, petEntry);
        LycanitesMobs.packetHandler.sendToPlayer(message, (EntityPlayerMP)this.player);
    }

    public void sendPetEntryToServer(PetEntry petEntry) {
        if (!this.player.func_130014_f_().field_72995_K) {
            return;
        }
        MessagePetEntry message = new MessagePetEntry(this, petEntry);
        LycanitesMobs.packetHandler.sendToServer(message);
    }

    public void sendPetEntryRemoveRequest(PetEntry petEntry) {
        if (!this.player.func_130014_f_().field_72995_K) {
            return;
        }
        petEntry.remove();
        MessagePetEntryRemove message = new MessagePetEntryRemove(this, petEntry);
        LycanitesMobs.packetHandler.sendToServer(message);
    }

    public void sendAllSummonSetsToPlayer() {
        if (this.player.func_130014_f_().field_72995_K) {
            return;
        }
        LycanitesMobs.logDebug("Packets", "Sending all summoning sets to client.");
        for (byte setID = 1; setID <= this.summonSetMax; setID = (byte)(setID + 1)) {
            MessageSummonSet message = new MessageSummonSet(this, setID);
            LycanitesMobs.packetHandler.sendToPlayer(message, (EntityPlayerMP)this.player);
        }
    }

    public void sendSummonSetToServer(byte setID) {
        if (!this.player.func_130014_f_().field_72995_K) {
            return;
        }
        MessageSummonSet message = new MessageSummonSet(this, setID);
        LycanitesMobs.packetHandler.sendToServer(message);
    }

    public void updateControlStates(byte controlStates) {
        this.controlStates = controlStates;
    }

    public boolean isControlActive(CONTROL_ID controlID) {
        return (this.controlStates & controlID.id) > 0;
    }

    public void requestGUI(byte guiID) {
        if (guiID == GuiHandler.Beastiary.PETS.id) {
            this.sendPetEntriesToPlayer("pet");
        }
        if (guiID == GuiHandler.Beastiary.PETS.id) {
            this.sendPetEntriesToPlayer("mount");
        }
        if (guiID == GuiHandler.Beastiary.PETS.id) {
            this.sendPetEntriesToPlayer("familiar");
        }
    }

    public void readNBT(NBTTagCompound nbtTagCompound) {
        NBTTagCompound extTagCompound = nbtTagCompound.func_74775_l("LycanitesMobsPlayer");
        this.beastiary.readFromNBT(extTagCompound);
        this.petManager.readFromNBT(extTagCompound);
        if (extTagCompound.func_74764_b("SummonFocus")) {
            this.summonFocus = extTagCompound.func_74762_e("SummonFocus");
        }
        if (extTagCompound.func_74764_b("Spirit")) {
            this.spirit = extTagCompound.func_74762_e("Spirit");
        }
        if (extTagCompound.func_74764_b("CreatureStudyCooldown")) {
            this.creatureStudyCooldown = extTagCompound.func_74762_e("CreatureStudyCooldown");
        }
        if (extTagCompound.func_74764_b("SelectedSummonSet")) {
            this.selectedSummonSet = extTagCompound.func_74762_e("SelectedSummonSet");
        }
        if (extTagCompound.func_74764_b("SummonSets")) {
            NBTTagList nbtSummonSets = extTagCompound.func_150295_c("SummonSets", 10);
            for (int setID = 0; setID < this.summonSetMax; ++setID) {
                NBTTagCompound nbtSummonSet = nbtSummonSets.func_150305_b(setID);
                SummonSet summonSet = new SummonSet(this);
                summonSet.readFromNBT(nbtSummonSet);
                this.summonSets.put(setID + 1, summonSet);
            }
        }
        if (extTagCompound.func_74764_b("TimePlayed")) {
            this.timePlayed = extTagCompound.func_74763_f("TimePlayed");
        }
    }

    public void writeNBT(NBTTagCompound nbtTagCompound) {
        NBTTagCompound extTagCompound = new NBTTagCompound();
        this.beastiary.writeToNBT(extTagCompound);
        this.petManager.writeToNBT(extTagCompound);
        extTagCompound.func_74768_a("SummonFocus", this.summonFocus);
        extTagCompound.func_74768_a("Spirit", this.spirit);
        extTagCompound.func_74768_a("CreatureStudyCooldown", this.creatureStudyCooldown);
        extTagCompound.func_74768_a("SelectedSummonSet", this.selectedSummonSet);
        extTagCompound.func_74772_a("TimePlayed", this.timePlayed);
        NBTTagList nbtSummonSets = new NBTTagList();
        for (int setID = 0; setID < this.summonSetMax; ++setID) {
            NBTTagCompound nbtSummonSet = new NBTTagCompound();
            SummonSet summonSet = this.getSummonSet(setID + 1);
            summonSet.writeToNBT(nbtSummonSet);
            nbtSummonSets.func_74742_a((NBTBase)nbtSummonSet);
        }
        extTagCompound.func_74782_a("SummonSets", (NBTBase)nbtSummonSets);
        nbtTagCompound.func_74782_a("LycanitesMobsPlayer", (NBTBase)extTagCompound);
    }

    public static enum CONTROL_ID {
        JUMP(1),
        MOUNT_DISMOUNT(2),
        MOUNT_ABILITY(4),
        MOUNT_INVENTORY(8),
        ATTACK(16),
        DESCEND(32),
        RIGHT_MOUSE(64);

        public byte id;

        private CONTROL_ID(byte i) {
            this.id = i;
        }
    }
}

