/*
 * Decompiled with CFR 0.152.
 */
package com.lycanitesmobs.core.entity;

import com.lycanitesmobs.client.AssetManager;
import com.lycanitesmobs.core.entity.BaseCreatureEntity;
import com.lycanitesmobs.core.entity.TameableCreatureEntity;
import com.lycanitesmobs.core.info.CreatureManager;
import com.lycanitesmobs.core.info.ModInfo;
import net.minecraft.block.BlockTallGrass;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.projectile.EntityThrowable;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.DamageSource;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.player.AttackEntityEvent;
import net.minecraftforge.fml.common.eventhandler.Event;

public class BaseProjectileEntity
extends EntityThrowable {
    public String entityName = "projectile";
    public ModInfo modInfo;
    public long updateTick;
    public boolean movement = true;
    public float projectileScale = 1.0f;
    public int projectileLife = 200;
    public int damage = 1;
    public int pierce = 1;
    public double weight = 1.0;
    public double knockbackChance = 1.0;
    public int bonusDamage = 0;
    public boolean waterProof = false;
    public boolean lavaProof = false;
    public boolean cutsGrass = false;
    public boolean ripper = false;
    public boolean pierceBlocks = false;
    public int animationFrame = 0;
    public int animationFrameMax = 0;
    public int textureTiling = 1;
    public float textureScale = 1.0f;
    public float textureOffsetY = 0.0f;
    public boolean clientOnly = false;
    public float rollSpeed = 0.0f;
    protected static final DataParameter<Float> SCALE = EntityDataManager.func_187226_a(BaseProjectileEntity.class, (DataSerializer)DataSerializers.field_187193_c);

    public BaseProjectileEntity(World world) {
        super(world);
        this.field_70180_af.func_187214_a(SCALE, (Object)Float.valueOf(this.projectileScale));
        this.setProjectileScale(this.projectileScale);
        this.setup();
    }

    public BaseProjectileEntity(World world, EntityLivingBase entityLiving) {
        super(world, entityLiving);
        this.func_184538_a((Entity)entityLiving, entityLiving.field_70125_A, entityLiving.field_70177_z, 0.0f, 1.1f, 1.0f);
        this.field_70180_af.func_187214_a(SCALE, (Object)Float.valueOf(this.projectileScale));
        this.setProjectileScale(this.projectileScale);
        this.setup();
    }

    public BaseProjectileEntity(World world, double x, double y, double z) {
        super(world, x, y, z);
        this.field_70180_af.func_187214_a(SCALE, (Object)Float.valueOf(this.projectileScale));
        this.setProjectileScale(this.projectileScale);
        this.setup();
    }

    public void setup() {
    }

    public String getStringFromDataManager(DataParameter<String> key) {
        try {
            return (String)this.func_184212_Q().func_187225_a(key);
        }
        catch (Exception e) {
            return null;
        }
    }

    public void func_70071_h_() {
        ++this.updateTick;
        if (!this.movement) {
            this.field_174854_a = false;
            this.field_71088_bW = this.func_82147_ab();
        }
        double initX = this.field_70165_t;
        double initY = this.field_70163_u;
        double initZ = this.field_70161_v;
        super.func_70071_h_();
        if (!this.movement) {
            this.field_70165_t = initX;
            this.field_70163_u = initY;
            this.field_70161_v = initZ;
            this.field_70159_w = 0.0;
            this.field_70181_x = 0.0;
            this.field_70179_y = 0.0;
            this.func_70107_b(this.field_70165_t, this.field_70163_u, this.field_70161_v);
        }
        this.field_70134_J = false;
        if (!this.func_130014_f_().field_72995_K) {
            if (!this.waterProof && this.func_70090_H()) {
                this.func_70106_y();
            } else if (!this.lavaProof && this.func_180799_ab()) {
                this.func_70106_y();
            }
        }
        if ((!this.func_130014_f_().field_72995_K || this.clientOnly) && this.projectileLife-- <= 0) {
            this.func_70106_y();
        }
        if (this.func_130014_f_().field_72995_K) {
            this.projectileScale = ((Float)this.field_70180_af.func_187225_a(SCALE)).floatValue();
        }
        if (this.animationFrameMax > 0) {
            this.animationFrame = this.animationFrame == this.animationFrameMax || this.animationFrame < 0 ? 0 : ++this.animationFrame;
        }
    }

    public boolean func_180799_ab() {
        return false;
    }

    protected float func_70185_h() {
        return (float)this.weight * 0.03f;
    }

    public void func_174830_Y() {
    }

    public boolean func_70072_I() {
        return this.field_70171_ac;
    }

    protected void func_70184_a(RayTraceResult rayTraceResult) {
        int j;
        int i;
        boolean collided = false;
        boolean entityCollision = false;
        boolean doDamage = true;
        boolean blockCollision = false;
        BlockPos impactPos = this.func_180425_c();
        if (rayTraceResult.field_72308_g != null) {
            EntityLivingBase target;
            float damage;
            if (this.func_85052_h() != null && rayTraceResult.field_72308_g == this.func_85052_h()) {
                return;
            }
            if (rayTraceResult.field_72308_g instanceof EntityLivingBase) {
                doDamage = this.canDamage((EntityLivingBase)rayTraceResult.field_72308_g);
            }
            if (!(this.func_130014_f_().field_72995_K || this.func_85052_h() != null && rayTraceResult.field_72308_g == this.func_85052_h())) {
                this.onEntityCollision(rayTraceResult.field_72308_g);
            }
            if (doDamage && rayTraceResult.field_72308_g instanceof EntityLivingBase && (damage = this.getDamage((Entity)(target = (EntityLivingBase)rayTraceResult.field_72308_g))) != 0.0f) {
                boolean attackSuccess;
                float damageInit = damage;
                double targetKnockbackResistance = 0.0;
                boolean stopKnockback = false;
                if (this.knockbackChance < 1.0 && (this.knockbackChance <= 0.0 || this.field_70146_Z.nextDouble() <= this.knockbackChance)) {
                    targetKnockbackResistance = target.func_110148_a(SharedMonsterAttributes.field_111266_c).func_111126_e();
                    target.func_110148_a(SharedMonsterAttributes.field_111266_c).func_111128_a(1.0);
                    stopKnockback = true;
                }
                if (this.func_85052_h() instanceof BaseCreatureEntity) {
                    BaseCreatureEntity creatureThrower = (BaseCreatureEntity)this.func_85052_h();
                    boolean blocked = this.isBlockedByEntity((Entity)target, rayTraceResult.field_72307_f);
                    attackSuccess = creatureThrower.doRangedDamage((Entity)target, this, damage, blocked);
                } else {
                    double pierceDamage = this.pierce;
                    if ((double)damage <= pierceDamage) {
                        attackSuccess = target.func_70097_a(DamageSource.func_76356_a((Entity)this, (Entity)this.func_85052_h()).func_76348_h().func_151518_m(), damage);
                    } else {
                        int hurtResistantTimeBefore = target.field_70172_ad;
                        target.func_70097_a(DamageSource.func_76356_a((Entity)this, (Entity)this.func_85052_h()).func_76348_h().func_151518_m(), (float)pierceDamage);
                        target.field_70172_ad = hurtResistantTimeBefore;
                        damage = (float)((double)damage - pierceDamage);
                        attackSuccess = target.func_70097_a(DamageSource.func_76356_a((Entity)this, (Entity)this.func_85052_h()), damage);
                    }
                }
                this.onEntityLivingDamage(target);
                this.onDamage(target, damageInit, attackSuccess);
                if (stopKnockback) {
                    target.func_110148_a(SharedMonsterAttributes.field_111266_c).func_111128_a(targetKnockbackResistance);
                }
            }
            collided = true;
            entityCollision = true;
            i = (int)Math.floor(rayTraceResult.field_72308_g.field_70165_t);
            j = (int)Math.floor(rayTraceResult.field_72308_g.field_70163_u);
            int k = (int)Math.floor(rayTraceResult.field_72308_g.field_70161_v);
            impactPos = new BlockPos(i, j, k);
            if (!this.func_130014_f_().field_72995_K && this.canDestroyBlock(impactPos)) {
                try {
                    this.placeBlock(this.func_130014_f_(), impactPos);
                }
                catch (Exception damageInit) {}
            }
        } else {
            i = rayTraceResult.func_178782_a().func_177958_n();
            j = rayTraceResult.func_178782_a().func_177956_o();
            int k = rayTraceResult.func_178782_a().func_177952_p();
            BlockPos blockPos = new BlockPos(i, j, k);
            IBlockState blockState = this.func_130014_f_().func_180495_p(blockPos);
            if (blockState.func_177230_c() instanceof BlockTallGrass || blockState.func_177230_c() == Blocks.field_150398_cm) {
                if (this.cutsGrass) {
                    this.field_70170_p.func_175655_b(blockPos, false);
                }
            } else {
                collided = blockState.func_185904_a().func_76220_a();
                if (!this.waterProof && blockState.func_185904_a() == Material.field_151586_h) {
                    collided = true;
                }
                if (!this.lavaProof && blockState.func_185904_a() == Material.field_151587_i) {
                    collided = true;
                }
            }
            if (collided) {
                blockCollision = true;
                switch (rayTraceResult.field_178784_b) {
                    case DOWN: {
                        --j;
                        break;
                    }
                    case UP: {
                        ++j;
                        break;
                    }
                    case SOUTH: {
                        --k;
                        break;
                    }
                    case NORTH: {
                        ++k;
                        break;
                    }
                    case WEST: {
                        --i;
                        break;
                    }
                    case EAST: {
                        ++i;
                    }
                }
                impactPos = new BlockPos(i, j, k);
                if (!this.func_130014_f_().field_72995_K && this.canDestroyBlock(impactPos)) {
                    try {
                        this.placeBlock(this.func_130014_f_(), impactPos);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
        }
        if (collided && (!entityCollision || doDamage)) {
            boolean blockPierced;
            if (!this.func_130014_f_().field_72995_K) {
                this.onImpactComplete(impactPos);
            } else {
                this.onImpactVisuals();
            }
            boolean entityPierced = this.ripper && entityCollision;
            boolean bl = blockPierced = this.pierceBlocks && blockCollision;
            if (!(this.func_130014_f_().field_72995_K || entityPierced || blockPierced)) {
                this.func_70106_y();
                if (this.getImpactSound() != null) {
                    this.func_184185_a(this.getImpactSound(), 1.0f, 1.0f / (this.func_130014_f_().field_73012_v.nextFloat() * 0.4f + 0.8f));
                }
            }
        }
    }

    public boolean isBlockedByEntity(Entity targetEntity, Vec3d damagePostition) {
        if (!(targetEntity instanceof EntityLivingBase)) {
            return false;
        }
        EntityLivingBase targetLiving = (EntityLivingBase)targetEntity;
        return targetLiving.func_184585_cz();
    }

    public boolean canDamage(EntityLivingBase targetEntity) {
        if (this.func_130014_f_().field_72995_K) {
            return false;
        }
        EntityLivingBase owner = this.func_85052_h();
        if (owner != null) {
            BaseCreatureEntity ownerCreature;
            if (owner instanceof BaseCreatureEntity && !(ownerCreature = (BaseCreatureEntity)owner).canAttackEntity(targetEntity)) {
                return false;
            }
            if (owner instanceof EntityPlayer) {
                TameableCreatureEntity targetCreature;
                if (MinecraftForge.EVENT_BUS.post((Event)new AttackEntityEvent((EntityPlayer)owner, (Entity)targetEntity))) {
                    return false;
                }
                if (targetEntity instanceof TameableCreatureEntity && (targetCreature = (TameableCreatureEntity)targetEntity).getPlayerOwner() == owner) {
                    return false;
                }
            }
            if (!this.func_130014_f_().func_73046_m().func_71219_W() && owner instanceof EntityPlayer) {
                TameableCreatureEntity tamedTarget;
                if (targetEntity instanceof EntityPlayer) {
                    return false;
                }
                if (targetEntity instanceof TameableCreatureEntity && (tamedTarget = (TameableCreatureEntity)targetEntity).isTamed()) {
                    return false;
                }
            }
            if (owner.func_184191_r((Entity)targetEntity) && CreatureManager.getInstance().config.friendlyFire) {
                return false;
            }
        }
        return true;
    }

    public void onDamage(EntityLivingBase target, float damage, boolean attackSuccess) {
    }

    public void onEntityCollision(Entity entity) {
    }

    public boolean onEntityLivingDamage(EntityLivingBase entityLiving) {
        return true;
    }

    public boolean canDestroyBlock(BlockPos pos) {
        if (this.func_130014_f_().func_175623_d(pos)) {
            return true;
        }
        IBlockState blockState = this.func_130014_f_().func_180495_p(pos);
        return !blockState.func_185904_a().func_76220_a();
    }

    public void placeBlock(World world, BlockPos pos) {
    }

    public void onImpactComplete(BlockPos impactPos) {
    }

    public void onImpactVisuals() {
    }

    public boolean func_70067_L() {
        return false;
    }

    public boolean func_70097_a(DamageSource damageSource, float damage) {
        return false;
    }

    public void setProjectileScale(float scale) {
        this.projectileScale = scale;
        if (this.func_130014_f_().field_72995_K && !this.clientOnly) {
            this.func_70105_a(this.projectileScale, this.projectileScale);
            return;
        }
        if (this.func_85052_h() != null && this.func_85052_h() instanceof BaseCreatureEntity) {
            this.projectileScale = (float)((double)this.projectileScale * ((BaseCreatureEntity)this.func_85052_h()).sizeScale);
        }
        this.func_70105_a(this.projectileScale, this.projectileScale);
        this.field_70180_af.func_187227_b(SCALE, (Object)Float.valueOf(this.projectileScale));
    }

    public float getProjectileScale() {
        return this.projectileScale;
    }

    public float getTextureOffsetY() {
        return 0.0f;
    }

    public void setDamage(int damage) {
        this.damage = damage;
    }

    public float getDamage(Entity entity) {
        float damage = (float)this.damage + (float)this.bonusDamage;
        if (this.func_85052_h() != null && (this.func_85052_h() instanceof EntityPlayer || this.func_85052_h().func_184179_bs() instanceof EntityPlayer) && !(entity instanceof EntityPlayer)) {
            damage *= 1.2f;
        }
        return damage;
    }

    public void setPierce(int pierce) {
        this.pierce = pierce;
    }

    public int getPierce() {
        return this.pierce;
    }

    public int getEffectDuration(int seconds) {
        if (this.func_85052_h() != null && this.func_85052_h() instanceof BaseCreatureEntity) {
            return Math.round((float)((BaseCreatureEntity)this.func_85052_h()).getEffectDuration(seconds) / 5.0f);
        }
        return seconds * 20;
    }

    public float getEffectStrength(float value) {
        if (this.func_85052_h() != null && this.func_85052_h() instanceof BaseCreatureEntity) {
            return ((BaseCreatureEntity)this.func_85052_h()).getEffectStrength(value);
        }
        return value;
    }

    public void setBonusDamage(int bonusDamage) {
        this.bonusDamage = bonusDamage;
    }

    public double[] getFacingPosition(double distance) {
        return this.getFacingPosition((Entity)this, distance, 0.0);
    }

    public double[] getFacingPosition(Entity entity, double distance, double angleOffset) {
        double angle = Math.toRadians(entity.field_70177_z) + angleOffset;
        double xAmount = -Math.sin(angle);
        double zAmount = Math.cos(angle);
        double[] coords = new double[]{entity.field_70165_t + distance * xAmount, entity.field_70163_u, entity.field_70161_v + distance * zAmount};
        return coords;
    }

    public void func_70014_b(NBTTagCompound compound) {
        super.func_70014_b(compound);
        compound.func_74776_a("ProjectileScale", this.projectileScale);
        compound.func_74768_a("ProjectileLife", this.projectileLife);
    }

    public void func_70037_a(NBTTagCompound compound) {
        super.func_70037_a(compound);
        if (compound.func_74764_b("ProjectileScale")) {
            this.setProjectileScale(compound.func_74760_g("ProjectileScale"));
        }
        if (compound.func_74764_b("ProjectileLife")) {
            this.projectileLife = compound.func_74762_e("ProjectileLife");
        }
    }

    public String getTextureName() {
        return this.entityName.toLowerCase();
    }

    public ResourceLocation getTexture() {
        if (AssetManager.getTexture(this.getTextureName()) == null) {
            AssetManager.addTexture(this.getTextureName(), this.modInfo, "textures/items/" + this.getTextureName() + ".png");
        }
        return AssetManager.getTexture(this.getTextureName());
    }

    public SoundEvent getLaunchSound() {
        return AssetManager.getSound(this.entityName);
    }

    public SoundEvent getImpactSound() {
        return AssetManager.getSound(this.entityName + "_impact");
    }

    public SoundEvent getBeamSound() {
        return this.getLaunchSound();
    }
}

