/*
 * Decompiled with CFR 0.152.
 */
package com.lycanitesmobs.client.renderer;

import com.lycanitesmobs.ObjectManager;
import com.lycanitesmobs.client.renderer.RenderFactoryCreature;
import com.lycanitesmobs.client.renderer.RenderFactoryNone;
import com.lycanitesmobs.client.renderer.RenderFactoryProjectile;
import com.lycanitesmobs.core.entity.CustomProjectileEntity;
import com.lycanitesmobs.core.entity.CustomProjectileModelEntity;
import com.lycanitesmobs.core.info.CreatureInfo;
import com.lycanitesmobs.core.info.CreatureManager;
import com.lycanitesmobs.core.info.ModInfo;
import com.lycanitesmobs.core.info.projectile.ProjectileManager;
import net.minecraft.entity.Entity;
import net.minecraftforge.fml.client.registry.RenderingRegistry;

public class RenderRegister {
    public ModInfo modInfo;

    public RenderRegister(ModInfo modInfo) {
        this.modInfo = modInfo;
    }

    public void registerRenderFactories() {
        Class<? extends Entity> projectileClass;
        for (CreatureInfo creatureInfo : CreatureManager.getInstance().creatures.values()) {
            if (creatureInfo.dummy) {
                RenderingRegistry.registerEntityRenderingHandler(creatureInfo.entityClass, new RenderFactoryNone(creatureInfo.entityClass));
            }
            RenderingRegistry.registerEntityRenderingHandler(creatureInfo.entityClass, new RenderFactoryCreature(creatureInfo));
        }
        RenderingRegistry.registerEntityRenderingHandler(CustomProjectileModelEntity.class, new RenderFactoryProjectile(true));
        RenderingRegistry.registerEntityRenderingHandler(CustomProjectileEntity.class, new RenderFactoryProjectile(false));
        for (String string : ProjectileManager.getInstance().oldSpriteProjectiles.keySet()) {
            projectileClass = ProjectileManager.getInstance().oldSpriteProjectiles.get(string);
            RenderingRegistry.registerEntityRenderingHandler(projectileClass, new RenderFactoryProjectile(string, projectileClass, false));
        }
        for (String string : ProjectileManager.getInstance().oldModelProjectiles.keySet()) {
            projectileClass = ProjectileManager.getInstance().oldModelProjectiles.get(string);
            RenderingRegistry.registerEntityRenderingHandler(projectileClass, new RenderFactoryProjectile(string, projectileClass, true));
        }
        for (Class clazz : ObjectManager.specialEntities.values()) {
            RenderingRegistry.registerEntityRenderingHandler((Class)clazz, new RenderFactoryNone(clazz));
        }
    }
}

