/*
 * Decompiled with CFR 0.152.
 */
package com.lycanitesmobs.client.localisation;

import com.google.common.base.Splitter;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.lycanitesmobs.LycanitesMobs;
import com.lycanitesmobs.Utilities;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.regex.Pattern;
import net.minecraft.client.resources.IResourceManager;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.translation.I18n;
import net.minecraftforge.fml.common.FMLCommonHandler;
import org.apache.commons.io.IOUtils;

public class LanguageManager {
    public static LanguageManager INSTANCE;
    protected static final Splitter SPLITTER;
    protected static final Pattern PATTERN;
    protected Map<String, String> map = new HashMap<String, String>();

    public static LanguageManager getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new LanguageManager();
        }
        return INSTANCE;
    }

    public static String translate(String key) {
        return I18n.func_74838_a((String)key);
    }

    public void loadLocaleData(InputStream inputStreamIn) throws IOException {
        inputStreamIn = FMLCommonHandler.instance().loadLanguage(this.map, inputStreamIn);
        if (inputStreamIn == null) {
            return;
        }
        for (String s : IOUtils.readLines((InputStream)inputStreamIn, (Charset)StandardCharsets.UTF_8)) {
            String[] splitters;
            if (s.isEmpty() || s.charAt(0) == '#' || (splitters = (String[])Iterables.toArray((Iterable)SPLITTER.split((CharSequence)s), String.class)) == null || splitters.length != 2) continue;
            String s1 = splitters[0];
            String s2 = PATTERN.matcher(splitters[1]).replaceAll("%$1s");
            this.map.put(s1, s2);
        }
    }

    public void loadLanguage(String mainLanguage, IResourceManager resourceManager) {
        LycanitesMobs.logDebug("Localisation", "Loading additional lang files...");
        ArrayList languageList = Lists.newArrayList((Object[])new String[]{mainLanguage});
        if (!"en_us".equals(mainLanguage)) {
            languageList.add(mainLanguage);
        }
        int laodedLangFiles = 0;
        for (String language : languageList) {
            String languageDir = String.format("lang/%s/", language);
            Path languageWalkPath = Utilities.getAssetPath(LycanitesMobs.modInfo.getClass(), LycanitesMobs.modInfo.modid, "lang/en_us/");
            try {
                Iterator languageDirIter = Files.walk(languageWalkPath, new FileVisitOption[0]).iterator();
                String languageSubdir = "";
                while (languageDirIter.hasNext()) {
                    Path subdirPath = (Path)languageDirIter.next();
                    if (!Files.isDirectory(subdirPath, new LinkOption[0])) {
                        try {
                            if (!subdirPath.toString().replace("\\", "/").contains(languageSubdir)) {
                                languageSubdir = "";
                            }
                            String languagePath = languageDir + languageSubdir + subdirPath.getFileName();
                            LycanitesMobs.logDebug("Language", "Reading translations from lang: " + languagePath + " Subdir Path:" + subdirPath.toString().replace("en_us", language));
                            ResourceLocation langLocation = new ResourceLocation(LycanitesMobs.modInfo.modid, languagePath);
                            LanguageManager.getInstance().loadLocaleData(resourceManager.func_110536_a(langLocation).func_110527_b());
                        }
                        catch (Exception e) {
                            LycanitesMobs.logWarning("", "Error reading translations from lang: " + languageDir + languageSubdir + subdirPath.getFileName() + " Subdir: " + languageSubdir + " Subdir Path: " + subdirPath.toString().replace("en_us", language));
                        }
                        ++laodedLangFiles;
                        continue;
                    }
                    languageSubdir = subdirPath.getName(subdirPath.getNameCount() - 1).toString().replace("\\", "/");
                    if (!languageSubdir.substring(languageSubdir.length() - 1).equals("/")) {
                        languageSubdir = languageSubdir + "/";
                    }
                    LycanitesMobs.logDebug("Language", "Setting Subdir: " + languageSubdir);
                }
            }
            catch (Exception exception) {
            }
        }
        LycanitesMobs.logDebug("Localisation", laodedLangFiles + " Additional lang files loaded! Test translation: " + LanguageManager.translate("lycanitesmobs.test"));
    }

    static {
        SPLITTER = Splitter.on((char)'=').limit(2);
        PATTERN = Pattern.compile("%(\\d+\\$)?[\\d\\.]*[df]");
    }
}

