/*
 * Decompiled with CFR 0.152.
 */
package com.lycanitesmobs.client.gui.beastiary.lists;

import com.lycanitesmobs.client.gui.beastiary.BeastiaryScreen;
import com.lycanitesmobs.core.info.CreatureInfo;
import com.lycanitesmobs.core.info.Subspecies;
import com.lycanitesmobs.core.info.Variant;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.Tessellator;
import net.minecraftforge.fml.client.GuiScrollingList;

public class SubspeciesList
extends GuiScrollingList {
    private BeastiaryScreen parentGui;
    private CreatureInfo creature;
    private Map<Integer, Entry> entryList = new HashMap<Integer, Entry>();
    private boolean summoning;

    public SubspeciesList(BeastiaryScreen parentGui, boolean summoning, int width, int height, int top, int bottom, int x) {
        super(Minecraft.func_71410_x(), width, height, top, bottom, x, 24, width, height);
        this.parentGui = parentGui;
        this.summoning = summoning;
        this.refreshList();
    }

    public void refreshList() {
        this.entryList.clear();
        this.creature = !this.summoning ? this.parentGui.playerExt.selectedCreature : this.parentGui.playerExt.getSelectedSummonSet().getCreatureInfo();
        if (this.creature == null) {
            return;
        }
        int index = 0;
        for (Subspecies subspecies : this.creature.subspecies.values()) {
            this.entryList.put(index++, new Entry(subspecies.index, 0));
            for (int variantIndex : subspecies.variants.keySet()) {
                Variant variant;
                if (!this.parentGui.playerExt.getBeastiary().hasKnowledgeRank(this.creature.getName(), 2) || (variant = subspecies.getVariant(variantIndex)) == null || this.summoning && "rare".equals(variant.rarity)) continue;
                this.entryList.put(index++, new Entry(subspecies.index, variant.index));
            }
        }
    }

    protected int getSize() {
        return this.entryList.size();
    }

    protected void elementClicked(int index, boolean doubleClick) {
        this.selectedIndex = index;
        if (!this.summoning) {
            this.parentGui.playerExt.selectedSubspecies = this.entryList.get((Object)Integer.valueOf((int)index)).subspeciesIndex;
            this.parentGui.playerExt.selectedVariant = this.entryList.get((Object)Integer.valueOf((int)index)).variantIndex;
        } else {
            this.parentGui.playerExt.getSelectedSummonSet().setSubspecies(this.entryList.get((Object)Integer.valueOf((int)index)).subspeciesIndex);
            this.parentGui.playerExt.getSelectedSummonSet().setVariant(this.entryList.get((Object)Integer.valueOf((int)index)).variantIndex);
            this.parentGui.playerExt.sendSummonSetToServer((byte)this.parentGui.playerExt.selectedSummonSet);
        }
    }

    protected boolean isSelected(int index) {
        if (!this.summoning) {
            return this.parentGui.playerExt.selectedSubspecies == this.entryList.get((Object)Integer.valueOf((int)index)).subspeciesIndex && this.parentGui.playerExt.selectedVariant == this.entryList.get((Object)Integer.valueOf((int)index)).variantIndex;
        }
        return this.parentGui.playerExt.getSelectedSummonSet().getSubspecies() == this.entryList.get((Object)Integer.valueOf((int)index)).subspeciesIndex && this.parentGui.playerExt.getSelectedSummonSet().getVariant() == this.entryList.get((Object)Integer.valueOf((int)index)).variantIndex;
    }

    protected void drawBackground() {
        if (!this.summoning) {
            if (this.creature != this.parentGui.playerExt.selectedCreature) {
                this.refreshList();
            }
        } else if (this.creature != this.parentGui.playerExt.getSelectedSummonSet().getCreatureInfo()) {
            this.refreshList();
        }
    }

    protected int getContentHeight() {
        return this.getSize() * this.slotHeight;
    }

    protected void drawSlot(int index, int boxRight, int boxTop, int boxBottom, Tessellator tessellator) {
        int subspeciesId = this.entryList.get((Object)Integer.valueOf((int)index)).subspeciesIndex;
        Subspecies subspecies = this.creature.getSubspecies(subspeciesId);
        String subspeciesName = "";
        if (subspecies.name != null) {
            subspeciesName = " " + subspecies.getTitle();
        }
        int variantId = this.entryList.get((Object)Integer.valueOf((int)index)).variantIndex;
        Variant variant = subspecies.getVariant(variantId);
        String variantName = "Normal";
        if (variant != null) {
            variantName = variant.getTitle();
        }
        int nameY = boxTop + 6;
        this.parentGui.getFontRenderer().func_78276_b(variantName + subspeciesName, this.left + 10, nameY, 0xFFFFFF);
    }

    public static class Entry {
        int subspeciesIndex;
        int variantIndex;

        public Entry(int subspeciesIndex, int variantIndex) {
            this.subspeciesIndex = subspeciesIndex;
            this.variantIndex = variantIndex;
        }
    }
}

