/*
 * Decompiled with CFR 0.152.
 */
package com.lycanitesmobs.client.gui.beastiary.lists;

import com.lycanitesmobs.client.gui.beastiary.ElementsBeastiaryScreen;
import com.lycanitesmobs.core.info.ElementInfo;
import com.lycanitesmobs.core.info.ElementManager;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.Tessellator;
import net.minecraftforge.fml.client.GuiScrollingList;

public class ElementList
extends GuiScrollingList {
    private ElementsBeastiaryScreen parentGui;
    private Map<Integer, String> elementNames = new HashMap<Integer, String>();

    public ElementList(ElementsBeastiaryScreen parentGui, int width, int height, int top, int bottom, int x) {
        super(Minecraft.func_71410_x(), width, height, top, bottom, x, 24, width, height);
        this.parentGui = parentGui;
        int i = 0;
        ArrayList<ElementInfo> elements = new ArrayList<ElementInfo>();
        elements.addAll(ElementManager.getInstance().elements.values());
        elements.sort(Comparator.comparing(ElementInfo::getTitle));
        for (ElementInfo elementInfo : elements) {
            this.elementNames.put(i++, elementInfo.name);
        }
    }

    protected int getSize() {
        return this.elementNames.size();
    }

    protected void elementClicked(int index, boolean doubleClick) {
        this.selectedIndex = index;
        this.parentGui.elementInfo = ElementManager.getInstance().getElement(this.elementNames.get(index));
    }

    protected boolean isSelected(int index) {
        return this.selectedIndex == index;
    }

    protected void drawBackground() {
    }

    protected int getContentHeight() {
        return this.getSize() * this.slotHeight;
    }

    protected void drawSlot(int index, int boxRight, int boxTop, int boxBottom, Tessellator tessellator) {
        ElementInfo elementInfo = ElementManager.getInstance().getElement(this.elementNames.get(index));
        if (elementInfo == null) {
            return;
        }
        this.parentGui.getFontRenderer().func_78276_b(elementInfo.getTitle(), this.left + 4, boxTop + 4, 0xFFFFFF);
    }
}

