/*
 * Decompiled with CFR 0.152.
 */
package com.lycanitesmobs.client.gui;

import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.util.ResourceLocation;

public class DrawHelper {
    protected Minecraft minecraft;
    protected FontRenderer fontRenderer;

    public DrawHelper(Minecraft minecraft, FontRenderer fontRenderer) {
        this.minecraft = minecraft;
        this.fontRenderer = fontRenderer;
    }

    public Minecraft getMinecraft() {
        return this.minecraft;
    }

    public FontRenderer getFontRenderer() {
        if (this.fontRenderer == null) {
            this.fontRenderer = this.minecraft.field_71466_p;
        }
        return this.fontRenderer;
    }

    public int getStringWidth(String text) {
        return this.getFontRenderer().func_78256_a(text);
    }

    public int getWordWrappedHeight(String text, int wrapWidth) {
        return this.getFontRenderer().func_78267_b(text, wrapWidth);
    }

    public void drawTexture(ResourceLocation texture, float x, float y, float z, float u, float v, float width, float height) {
        this.preDraw();
        this.getMinecraft().func_110434_K().func_110577_a(texture);
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder buffer = tessellator.func_178180_c();
        buffer.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        buffer.func_181662_b((double)x, (double)(y + height), (double)z).func_187315_a(0.0, (double)v).func_181675_d();
        buffer.func_181662_b((double)(x + width), (double)(y + height), (double)z).func_187315_a((double)u, (double)v).func_181675_d();
        buffer.func_181662_b((double)(x + width), (double)y, (double)z).func_187315_a((double)u, 0.0).func_181675_d();
        buffer.func_181662_b((double)x, (double)y, (double)z).func_187315_a(0.0, 0.0).func_181675_d();
        tessellator.func_78381_a();
        this.postDraw();
    }

    public void drawTextureTiled(ResourceLocation texture, float x, float y, float z, float u, float v, float width, float height, float resolution) {
        float scaleX;
        this.preDraw();
        this.getMinecraft().func_110434_K().func_110577_a(texture);
        float scaleY = scaleX = 0.00390625f * resolution;
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder buffer = tessellator.func_178180_c();
        buffer.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        buffer.func_181662_b((double)(x + 0.0f), (double)(y + height), (double)z).func_187315_a((double)((u + 0.0f) * scaleX), (double)((v + height) * scaleY)).func_181675_d();
        buffer.func_181662_b((double)(x + width), (double)(y + height), (double)z).func_187315_a((double)((u + width) * scaleX), (double)((v + height) * scaleY)).func_181675_d();
        buffer.func_181662_b((double)(x + width), (double)(y + 0.0f), (double)z).func_187315_a((double)((u + width) * scaleX), (double)((v + 0.0f) * scaleY)).func_181675_d();
        buffer.func_181662_b((double)(x + 0.0f), (double)(y + 0.0f), (double)z).func_187315_a((double)((u + 0.0f) * scaleX), (double)((v + 0.0f) * scaleY)).func_181675_d();
        tessellator.func_78381_a();
        this.postDraw();
    }

    public void drawBar(ResourceLocation texture, int x, int y, float z, float width, float height, int segments, int segmentLimit) {
        boolean reverse;
        boolean bl = reverse = segmentLimit < 0;
        if (reverse) {
            segmentLimit = -segmentLimit;
        }
        for (int i = 0; i < segments; ++i) {
            int currentSegment = i;
            if (reverse) {
                currentSegment = segmentLimit - i - 1;
            }
            this.drawTexture(texture, (float)x + width * (float)currentSegment, y, z, 1.0f, 1.0f, width, height);
        }
    }

    public void preDraw() {
        GlStateManager.func_179147_l();
        GlStateManager.func_179097_i();
        GlStateManager.func_179132_a((boolean)false);
        GlStateManager.func_187401_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_179118_c();
    }

    public void postDraw() {
        GlStateManager.func_179084_k();
        GlStateManager.func_179126_j();
        GlStateManager.func_179132_a((boolean)true);
        GlStateManager.func_179141_d();
    }

    public void drawTexturedModalRect(int x, int y, int u, int v, int width, int height) {
        this.drawTexturedModalRect(x, y, u, v, width, height, 1);
    }

    public void drawTexturedModalRect(int x, int y, int u, int v, int width, int height, int resolution) {
        float scaleX;
        this.preDraw();
        float scaleY = scaleX = 0.00390625f * (float)resolution;
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder buffer = tessellator.func_178180_c();
        buffer.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        buffer.func_181662_b((double)x, (double)(y + height), 0.0).func_187315_a((double)((float)u * scaleX), (double)((float)(v + height) * scaleY)).func_181675_d();
        buffer.func_181662_b((double)(x + width), (double)(y + height), 0.0).func_187315_a((double)((float)(u + width) * scaleX), (double)((float)(v + height) * scaleY)).func_181675_d();
        buffer.func_181662_b((double)(x + width), (double)y, 0.0).func_187315_a((double)((float)(u + width) * scaleX), (double)((float)v * scaleY)).func_181675_d();
        buffer.func_181662_b((double)x, (double)y, 0.0).func_187315_a((double)((float)u * scaleX), (double)((float)v * scaleY)).func_181675_d();
        tessellator.func_78381_a();
        this.postDraw();
    }
}

