/*
 * Decompiled with CFR 0.152.
 */
package com.lycanitesmobs.client;

import com.lycanitesmobs.CommonProxy;
import com.lycanitesmobs.LycanitesMobs;
import com.lycanitesmobs.client.AssetManager;
import com.lycanitesmobs.client.ClientEventListener;
import com.lycanitesmobs.client.KeyHandler;
import com.lycanitesmobs.client.gui.buttons.MainTab;
import com.lycanitesmobs.client.gui.buttons.TabManager;
import com.lycanitesmobs.client.gui.overlays.BaseOverlay;
import com.lycanitesmobs.client.localisation.LanguageLoader;
import com.lycanitesmobs.client.localisation.LanguageManager;
import com.lycanitesmobs.client.model.EquipmentPartModelLoader;
import com.lycanitesmobs.client.model.projectile.AetherwaveModel;
import com.lycanitesmobs.client.model.projectile.ChaosOrbModel;
import com.lycanitesmobs.client.model.projectile.CrystalShardModel;
import com.lycanitesmobs.client.model.projectile.LightBallModel;
import com.lycanitesmobs.client.renderer.EquipmentPartRenderer;
import com.lycanitesmobs.client.renderer.EquipmentRenderer;
import com.lycanitesmobs.client.renderer.RenderRegister;
import com.lycanitesmobs.core.block.BlockFluidBase;
import com.lycanitesmobs.core.info.CreatureInfo;
import com.lycanitesmobs.core.info.ModInfo;
import com.lycanitesmobs.core.info.Subspecies;
import com.lycanitesmobs.core.item.ItemBase;
import com.lycanitesmobs.core.item.equipment.ItemEquipment;
import com.lycanitesmobs.core.item.equipment.ItemEquipmentPart;
import com.lycanitesmobs.core.tileentity.TileEntityEquipment;
import com.lycanitesmobs.core.tileentity.TileEntityEquipmentPart;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.block.model.ModelBakery;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.renderer.block.statemap.IStateMapper;
import net.minecraft.client.renderer.block.statemap.StateMapperBase;
import net.minecraft.client.renderer.color.IItemColor;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.client.resources.IReloadableResourceManager;
import net.minecraft.client.resources.IResourceManager;
import net.minecraft.client.resources.IResourceManagerReloadListener;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemAir;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.ForgeHooksClient;
import net.minecraftforge.client.model.ICustomModelLoader;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.client.model.ModelLoaderRegistry;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.client.registry.ClientRegistry;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ClientProxy
extends CommonProxy {
    FontRenderer fontRenderer;
    public static IItemColor itemColor = (stack, tintIndex) -> {
        Item item = stack.func_77973_b();
        if (item == null || !(item instanceof ItemBase)) {
            return 0xFFFFFF;
        }
        ItemBase itemBase = (ItemBase)item;
        return itemBase.getColorFromItemstack(stack, tintIndex);
    };

    @Override
    public void initLanguageManager() {
        LanguageManager.getInstance();
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public FontRenderer getFontRenderer() {
        return Minecraft.func_71410_x().field_71466_p;
    }

    @Override
    public void registerEvents() {
        FMLCommonHandler.instance().bus().register((Object)new KeyHandler(Minecraft.func_71410_x()));
        MinecraftForge.EVENT_BUS.register((Object)new BaseOverlay(Minecraft.func_71410_x()));
        MinecraftForge.EVENT_BUS.register((Object)new ClientEventListener());
        IResourceManager resourceManager = Minecraft.func_71410_x().func_110442_L();
        if (resourceManager instanceof IReloadableResourceManager) {
            ((IReloadableResourceManager)resourceManager).func_110542_a((IResourceManagerReloadListener)LanguageLoader.getInstance());
        }
    }

    @Override
    public void registerTextures() {
        ModInfo group = LycanitesMobs.modInfo;
        AssetManager.addTexture("GUIBeastiaryBackground", group, "textures/guis/beastiary/background.png");
        AssetManager.addTexture("GUIPetLevel", group, "textures/guis/beastiary/level.png");
        AssetManager.addTexture("GUIPetSpirit", group, "textures/guis/beastiary/spirit.png");
        AssetManager.addTexture("GUIPetSpiritEmpty", group, "textures/guis/beastiary/spirit_empty.png");
        AssetManager.addTexture("GUIPetSpiritUsed", group, "textures/guis/beastiary/spirit_used.png");
        AssetManager.addTexture("GUIPetSpiritFilling", group, "textures/guis/beastiary/spirit_filling.png");
        AssetManager.addTexture("GUIPetBarHealth", group, "textures/guis/beastiary/bar_health.png");
        AssetManager.addTexture("GUIPetBarRespawn", group, "textures/guis/beastiary/bar_respawn.png");
        AssetManager.addTexture("GUIBarExperience", group, "textures/guis/beastiary/bar_experience.png");
        AssetManager.addTexture("GUIPetBarEmpty", group, "textures/guis/beastiary/bar_empty.png");
        AssetManager.addTexture("GUIInventoryCreature", group, "textures/guis/inventory_creature.png");
        AssetManager.addTexture("GUIMinionLg", group, "textures/guis/minion_lg.png");
        AssetManager.addTexture("GUIEquipmentForge", group, "textures/guis/equipmentforge.png");
        TabManager.registerTab(new MainTab(0));
    }

    @Override
    public void registerRenders(ModInfo modInfo) {
        AssetManager.addModel("lightball", new LightBallModel());
        AssetManager.addModel("crystalshard", new CrystalShardModel());
        AssetManager.addModel("aetherwave", new AetherwaveModel());
        AssetManager.addModel("chaosorb", new ChaosOrbModel());
        ModelLoaderRegistry.registerLoader((ICustomModelLoader)new EquipmentPartModelLoader());
        ClientRegistry.bindTileEntitySpecialRenderer(TileEntityEquipmentPart.class, (TileEntitySpecialRenderer)new EquipmentPartRenderer());
        ClientRegistry.bindTileEntitySpecialRenderer(TileEntityEquipment.class, (TileEntitySpecialRenderer)new EquipmentRenderer());
        RenderRegister renderRegister = new RenderRegister(modInfo);
        renderRegister.registerRenderFactories();
    }

    @Override
    public void registerModels(ModInfo groupInfo) {
        AssetManager.registerModels();
    }

    @Override
    public void loadCreatureModel(CreatureInfo creature, String modelClassName) throws ClassNotFoundException {
        creature.modelClass = Class.forName(modelClassName);
    }

    @Override
    public void loadSubspeciesModel(Subspecies subspecies, String modelClassName) throws ClassNotFoundException {
        subspecies.modelClass = Class.forName(modelClassName);
    }

    @Override
    public EntityPlayer getClientPlayer() {
        return Minecraft.func_71410_x().field_71439_g;
    }

    @Override
    public void addBlockRender(ModInfo group, Block block) {
        if (block instanceof BlockFluidBase) {
            BlockFluidBase blockFluid = (BlockFluidBase)block;
            Item item = Item.func_150898_a((Block)block);
            ModelBakery.registerItemVariants((Item)item, (ResourceLocation[])new ResourceLocation[0]);
            final ModelResourceLocation fluidLocation = new ModelResourceLocation(blockFluid.group.modid + ":fluid", blockFluid.getFluid().getName());
            ModelLoader.setCustomMeshDefinition((Item)item, itemStack -> fluidLocation);
            ModelLoader.setCustomStateMapper((Block)block, (IStateMapper)new StateMapperBase(){

                protected ModelResourceLocation func_178132_a(IBlockState state) {
                    return fluidLocation;
                }
            });
            return;
        }
        this.addItemRender(group, Item.func_150898_a((Block)block));
    }

    @Override
    public void addItemRender(ModInfo group, Item item) {
        if (group == null) {
            group = LycanitesMobs.modInfo;
        }
        if (item instanceof ItemEquipmentPart) {
            ForgeHooksClient.registerTESRItemStack((Item)item, (int)0, TileEntityEquipmentPart.class);
        }
        if (item instanceof ItemEquipment) {
            ForgeHooksClient.registerTESRItemStack((Item)item, (int)0, TileEntityEquipment.class);
        }
        if (item instanceof ItemBase) {
            ItemBase itemBase = (ItemBase)item;
            ModelLoader.setCustomModelResourceLocation((Item)item, (int)0, (ModelResourceLocation)itemBase.getModelResourceLocation());
            return;
        }
        if (item instanceof ItemAir) {
            return;
        }
        ModelLoader.setCustomModelResourceLocation((Item)item, (int)0, (ModelResourceLocation)new ModelResourceLocation(item.getRegistryName(), "inventory"));
    }

    @Override
    public EntityPlayer getPlayer(MessageContext ctx) {
        if (ctx.side == Side.CLIENT) {
            return Minecraft.func_71410_x().field_71439_g;
        }
        return ctx.getServerHandler().field_147369_b;
    }
}

