/*
 * Decompiled with CFR 0.152.
 */
package com.lycanitesmobs;

import com.lycanitesmobs.LycanitesMobs;
import com.lycanitesmobs.core.config.ConfigBase;
import java.net.URI;
import java.net.URL;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EntitySelectors;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import org.apache.commons.io.FilenameUtils;

public class Utilities {
    protected static Calendar easterCalendar;

    public static void addDungeonLoot(ItemStack itemStack, int minAmount, int maxAmount, int weight) {
        ConfigBase config = LycanitesMobs.config;
        config.setCategoryComment("Dungeon Loot Enabled", "Here you can enable/disable dungeon loot for various types of dungeons.");
        if (config.getBool("Dungeon Loot Enabled", "Dungeons", true, "These are most dungeons from underground mob spawner dungeons to pyramids, mineshafts and jungle temples.")) {
            // empty if block
        }
    }

    public static void addStrongholdLoot(ItemStack itemStack, int minAmount, int maxAmount, int weight) {
        ConfigBase config = LycanitesMobs.config;
        if (config.getBool("Dungeon Loot Enabled", "Strongholds", true, "Stronghold dungeons including corridors, libraries and other parts.")) {
            // empty if block
        }
    }

    public static void addVillageLoot(ItemStack itemStack, int minAmount, int maxAmount, int weight) {
        ConfigBase config = LycanitesMobs.config;
        if (config.getBool("Dungeon Loot Enabled", "Blacksmiths", true, "These are the chests found in village blacksmiths homes.")) {
            // empty if block
        }
    }

    public static RayTraceResult raytrace(World world, Vec3d start, Vec3d end, boolean stopOnLiquid, boolean ignoreBlockWithoutBoundingBox, float rayWidth, @Nullable Predicate<Entity> entityPredicate) {
        RayTraceResult blockResult = Utilities.raytraceBlocks(world, start, end, stopOnLiquid, ignoreBlockWithoutBoundingBox);
        RayTraceResult entityResult = Utilities.raytraceEntities(world, start, end, rayWidth, entityPredicate);
        if (blockResult != null && blockResult.field_72313_a != RayTraceResult.Type.MISS) {
            if (entityResult != null && entityResult.field_72313_a != RayTraceResult.Type.MISS) {
                if (start.func_72436_e(blockResult.field_72307_f) <= start.func_72436_e(entityResult.field_72307_f)) {
                    return blockResult;
                }
                return entityResult;
            }
            return blockResult;
        }
        if (entityResult != null && entityResult.field_72313_a != RayTraceResult.Type.MISS) {
            return entityResult;
        }
        return new RayTraceResult(RayTraceResult.Type.MISS, end, null, new BlockPos(end));
    }

    public static RayTraceResult raytraceBlocks(World world, Vec3d start, Vec3d end, boolean stopOnLiquid, boolean ignoreBlockWithoutBoundingBox) {
        RayTraceResult result = world.func_147447_a(start, end, stopOnLiquid, ignoreBlockWithoutBoundingBox, false);
        if (result == null || result.field_72313_a == RayTraceResult.Type.MISS) {
            return new RayTraceResult(RayTraceResult.Type.MISS, end, null, new BlockPos(end));
        }
        return result;
    }

    public static <T extends Entity> RayTraceResult raytraceEntities(World world, Vec3d start, Vec3d end, float rayWidth, @Nullable Predicate<Entity> predicate) {
        AxisAlignedBB aabb = new AxisAlignedBB(start.field_72450_a, start.field_72448_b, start.field_72449_c, end.field_72450_a, end.field_72448_b, end.field_72449_c);
        if (rayWidth != 0.0f) {
            aabb = aabb.func_186662_g((double)rayWidth);
        }
        List possibleEntities = world.func_175647_a(Entity.class, aabb, predicate != null ? predicate::test : null);
        Entity closestHitEntity = null;
        Vec3d closestHitLocation = null;
        double closestHitDistSqr = Double.POSITIVE_INFINITY;
        for (Entity entity : possibleEntities) {
            double currentHitDistSqr;
            RayTraceResult currentHit;
            AxisAlignedBB entityAabb = entity.func_174813_aQ();
            if (rayWidth + entity.func_70111_Y() != 0.0f) {
                entityAabb = entityAabb.func_186662_g((double)(rayWidth + entity.func_70111_Y()));
            }
            if ((currentHit = entityAabb.func_72327_a(start, end)) == null || !((currentHitDistSqr = start.func_72436_e(currentHit.field_72307_f)) < closestHitDistSqr)) continue;
            closestHitEntity = entity;
            closestHitLocation = currentHit.field_72307_f;
            closestHitDistSqr = currentHitDistSqr;
        }
        if (closestHitEntity == null || closestHitLocation == null) {
            return new RayTraceResult(RayTraceResult.Type.MISS, end, null, new BlockPos(end));
        }
        return new RayTraceResult(closestHitEntity, closestHitLocation);
    }

    public static Predicate<Entity> collidable() {
        return entity -> EntitySelectors.field_180132_d.test(entity) && entity.func_70067_L();
    }

    public static Predicate<Entity> collidableExlcuding(Entity entityToIgnore) {
        if (entityToIgnore == null) {
            return Utilities.collidable();
        }
        return entity -> EntitySelectors.field_180132_d.test(entity) && entity.func_70067_L() && entity != entityToIgnore;
    }

    public static Predicate<Entity> collidableExlcuding(Entity entityToIgnore1, Entity entityToIgnore2) {
        if (entityToIgnore1 == null) {
            return Utilities.collidableExlcuding(entityToIgnore2);
        }
        if (entityToIgnore2 == null) {
            return Utilities.collidableExlcuding(entityToIgnore1);
        }
        return entity -> EntitySelectors.field_180132_d.test(entity) && entity.func_70067_L() && entity != entityToIgnore1 && entity != entityToIgnore2;
    }

    public static Predicate<Entity> collidableExlcuding(Entity entityToIgnore1, Entity entityToIgnore2, Entity entityToIgnore3) {
        if (entityToIgnore1 == null) {
            return Utilities.collidableExlcuding(entityToIgnore2, entityToIgnore3);
        }
        if (entityToIgnore2 == null) {
            return Utilities.collidableExlcuding(entityToIgnore1, entityToIgnore3);
        }
        if (entityToIgnore3 == null) {
            return Utilities.collidableExlcuding(entityToIgnore1, entityToIgnore2);
        }
        return entity -> EntitySelectors.field_180132_d.test(entity) && entity.func_70067_L() && entity != entityToIgnore1 && entity != entityToIgnore2 && entity != entityToIgnore3;
    }

    public static Predicate<Entity> collidableExlcuding(Entity ... entities) {
        if (entities.length >= 0 && entities.length < 4) {
            if (entities.length == 0) {
                return Utilities.collidable();
            }
            if (entities.length == 1) {
                return Utilities.collidableExlcuding(entities[0]);
            }
            if (entities.length == 2) {
                return Utilities.collidableExlcuding(entities[0], entities[1]);
            }
            if (entities.length == 3) {
                return Utilities.collidableExlcuding(entities[0], entities[1], entities[2]);
            }
        }
        Set entitySet = Arrays.stream(entities).filter(Objects::nonNull).collect(Collectors.toSet());
        return entity -> EntitySelectors.field_180132_d.test(entity) && entity.func_70067_L() && !entitySet.contains(entity);
    }

    public static boolean isValentines() {
        Calendar calendar = Calendar.getInstance();
        return calendar.get(2) == 1 && calendar.get(5) >= 7 && calendar.get(5) <= 14;
    }

    public static boolean isEaster() {
        long daysUntilEaster;
        Calendar calendar = Calendar.getInstance();
        if (easterCalendar == null) {
            int Y = calendar.get(1);
            int a = Y % 19;
            int b = Y / 100;
            int c = Y % 100;
            int d = b / 4;
            int e = b % 4;
            int f = (b + 8) / 25;
            int g = (b - f + 1) / 3;
            int h = (19 * a + b - d - g + 15) % 30;
            int i = c / 4;
            int k = c % 4;
            int L = (32 + 2 * e + 2 * i - h - k) % 7;
            int m = (a + 11 * h + 22 * L) / 451;
            int easterMonth = (h + L - 7 * m + 114) / 31;
            int easterDay = (h + L - 7 * m + 114) % 31 + 1;
            easterCalendar = new GregorianCalendar(Y, easterMonth, easterDay);
        }
        return (daysUntilEaster = ChronoUnit.DAYS.between(calendar.toInstant(), easterCalendar.toInstant())) <= 7L && daysUntilEaster >= 0L;
    }

    public static boolean isMidsummer() {
        Calendar calendar = Calendar.getInstance();
        return calendar.get(2) == 6 && calendar.get(5) >= 10 && calendar.get(5) <= 20;
    }

    public static boolean isHalloween() {
        block4: {
            block3: {
                Calendar calendar;
                block2: {
                    calendar = Calendar.getInstance();
                    if (calendar.get(5) < 25) break block2;
                    if (calendar.get(2) == 9) break block3;
                }
                if (calendar.get(5) != 1) break block4;
                if (calendar.get(2) != 10) break block4;
            }
            return true;
        }
        return false;
    }

    public static boolean isYuletide() {
        Calendar calendar = Calendar.getInstance();
        return calendar.get(2) == 11 && calendar.get(5) >= 10 && calendar.get(5) <= 25;
    }

    public static boolean isYuletidePeak() {
        Calendar calendar = Calendar.getInstance();
        return calendar.get(2) == 11 && calendar.get(5) == 25;
    }

    public static boolean isNewYear() {
        Calendar calendar = Calendar.getInstance();
        return calendar.get(2) == 0 && calendar.get(5) == 1;
    }

    public static int daysBetween(Date d1, Date d2) {
        return (int)((d2.getTime() - d1.getTime()) / 86400000L);
    }

    public static Path getAssetPath(Class clazz, String assetDomain, String assetPath) {
        Path path;
        block6: {
            path = null;
            String assetDir = "/assets/" + assetDomain + (!"".equals(assetPath) ? "/" + assetPath : "");
            try {
                FileSystem filesystem;
                URL url = clazz.getResource("/assets/" + assetDomain + "/.root");
                URI uri = url.toURI();
                if ("file".equals(uri.getScheme())) {
                    path = Paths.get(clazz.getResource(assetDir).toURI());
                    break block6;
                }
                if (!"jar".equals(uri.getScheme())) {
                    LycanitesMobs.logWarning("", "Unsupported file scheme: " + uri.getScheme());
                    return null;
                }
                try {
                    filesystem = FileSystems.getFileSystem(uri);
                }
                catch (Exception e) {
                    filesystem = FileSystems.newFileSystem(uri, Collections.emptyMap());
                }
                path = filesystem.getPath(assetDir, new String[0]);
            }
            catch (Exception e) {
                LycanitesMobs.logWarning("", "No data found in: " + assetDir);
            }
        }
        return path;
    }

    public static List<ResourceLocation> getPathResourceLocations(Path path, String assetDomain, String fileType) {
        ArrayList<ResourceLocation> resourceLocations = new ArrayList<ResourceLocation>();
        try {
            Iterator iterator = Files.walk(path, new FileVisitOption[0]).iterator();
            while (iterator.hasNext()) {
                Path filePath = (Path)iterator.next();
                if (fileType != null && !fileType.equals(FilenameUtils.getExtension((String)filePath.toString()))) continue;
                Path relativePath = path.relativize(filePath);
                String resourceLocationPath = FilenameUtils.removeExtension((String)relativePath.toString()).replaceAll("\\\\", "/");
                ResourceLocation resourceLocation = new ResourceLocation(assetDomain, resourceLocationPath);
                resourceLocations.add(resourceLocation);
            }
        }
        catch (Exception e) {
            LycanitesMobs.logWarning("", "There was a problem getting ResourceLocations for: " + path + ", " + fileType + ",  \n" + e.toString());
        }
        return resourceLocations;
    }
}

