/*
 * Decompiled with CFR 0.152.
 */
package xzeroair.trinkets.util.config;

import java.util.TreeMap;
import java.util.function.BiFunction;
import java.util.function.Function;
import javax.annotation.Nonnull;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityList;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemHoe;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemSword;
import net.minecraft.item.ItemTool;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.ResourceLocation;
import xzeroair.trinkets.Trinkets;
import xzeroair.trinkets.util.TrinketsConfig;
import xzeroair.trinkets.util.compat.OreDictionaryCompat;
import xzeroair.trinkets.util.helpers.StringUtils;

public class ConfigHelper {
    private static String nameRegex = "([a-zA-Z0-9_*]{1,})";
    private static String itemIDRegex = "(" + nameRegex + ":" + nameRegex + ")";
    private static String materialRegex = "(material" + nameRegex + ")";
    private static String metaRegex = "(([0-9]*)|([*]))";
    private static String metaRegexOptional = "(;" + metaRegex + ")?";
    private static String doubleRegex = "(([-])?([0-9]{1,})([.][0-9]{1,})?)";
    private static String doubleRegexOptional = "(;" + doubleRegex + ")?";
    private static String optionalWordRegex = "(;[a-zA-Z]*)?";

    public static String cleanConfigEntry(String config) {
        String configEntry = config.replaceAll("([\\[\\]\\|,;] ?)|(  )", " ").trim().replace(" ", ";");
        return configEntry;
    }

    public static AttributeEntry getAttributeEntry(String string) {
        String configEntry = ConfigHelper.cleanConfigEntry(string.replaceFirst("[nN][aA][mM][eE][:]", "").replaceFirst("[aA][mM][oO][uU][nN][tT][:]", "").replaceFirst("[oO][pP][eE][rR][aA][tT][iI][oO][nN][:]", ""));
        String[] vars = configEntry.split(";");
        String arg1 = StringUtils.getStringFromArray(vars, 0);
        String arg2 = StringUtils.getStringFromArray(vars, 1);
        String arg3 = StringUtils.getStringFromArray(vars, 2);
        String arg4 = StringUtils.getStringFromArray(vars, 3);
        String attributeRegex = "([a-zA-Z0-9_.]*)";
        String amountRegex = doubleRegex;
        String opRegex = "([0-2])";
        String boolRegex = "(true)|(false)";
        String attribute = "";
        double amount = 0.0;
        int op = 0;
        boolean saved = false;
        boolean isAttribute = false;
        if (!arg1.isEmpty() && arg1.matches(attributeRegex)) {
            attribute = arg1;
            if (!arg2.isEmpty() && arg2.matches(amountRegex)) {
                try {
                    amount = Double.parseDouble(arg2.replace("+", ""));
                    isAttribute = true;
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                if (!arg3.isEmpty() && arg3.matches(opRegex)) {
                    try {
                        op = Integer.parseInt(arg3);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
                if (!arg4.isEmpty() && arg4.toLowerCase().matches(boolRegex) && arg4.equalsIgnoreCase("true")) {
                    saved = true;
                }
            }
        }
        if (isAttribute && !attribute.isEmpty() && amount != 0.0) {
            return new AttributeEntry(attribute, amount, op, saved);
        }
        return null;
    }

    private static <T> T continueCommand(String string, Function<String, T> func) {
        return func.apply(string);
    }

    private static <T> T continueCommand(String arg1, String arg2, BiFunction<String, String, T> func) {
        return func.apply(arg1, arg2);
    }

    public static class ObjectPair<A, B> {
        private A first;
        private B second;

        public ObjectPair(A first, B second) {
            this.first = first;
            this.second = second;
        }

        public A getFirst() {
            return this.first;
        }

        public B getSecond() {
            return this.second;
        }
    }

    public static enum EntryType {
        UNKNOWN,
        NORMAL,
        ITEM,
        BLOCK,
        ENTITY,
        MATERIAL,
        POTION,
        OREDICTIONARY;

    }

    public static class ConfigObject {
        protected String originalEntry;
        protected String modID;
        protected String objectID;
        protected int meta;
        protected String[] objectArgs;
        protected EntryType objectType;

        public ConfigObject(String modID, String objectID, int meta) {
            this(modID, objectID, meta, new String[0]);
        }

        public ConfigObject(String config) {
            this("minecraft", "air", OreDictionaryCompat.wildcard);
            this.originalEntry = config;
            this.generateConfigObject(config);
        }

        public ConfigObject(String modID, String objectID, int meta, String[] args) {
            this.originalEntry = modID + ":" + objectID + ";" + meta;
            this.modID = modID;
            this.objectID = objectID;
            this.meta = meta;
            this.objectType = EntryType.UNKNOWN;
            this.objectArgs = args;
        }

        public final String getModID() {
            return this.modID;
        }

        public final String getObjectID() {
            return this.objectID;
        }

        public final String getObjectRegistryName() {
            return this.getModID() + ":" + this.getObjectID();
        }

        public final int getMeta() {
            return this.meta;
        }

        public final EntryType getObjectType() {
            return this.objectType;
        }

        public final String[] getObjectArgs() {
            return this.objectArgs;
        }

        public final String getOriginalEntry() {
            return this.originalEntry;
        }

        public final boolean isEmpty() {
            String reg = this.getObjectRegistryName();
            boolean flag1 = reg.contentEquals("minecraft:air");
            boolean flag2 = reg.contentEquals("*:air");
            return flag1 || flag2;
        }

        protected void generateConfigObject(String configEntry) {
            String[] checkArgs = (configEntry = ConfigHelper.cleanConfigEntry(configEntry)).split(";", 2);
            String entry = StringUtils.getStringFromArray(checkArgs, 0);
            if (!entry.isEmpty()) {
                String[] configArgs = StringUtils.getStringFromArray(checkArgs, 1).split(";", 2);
                boolean existsInOreDict = OreDictionaryCompat.existsInOreDictionary(entry);
                if (existsInOreDict) {
                    this.objectType = EntryType.OREDICTIONARY;
                    this.modID = "oreDict";
                    this.objectID = entry;
                    String leftoverArgs = StringUtils.getStringFromArray(configArgs, 0);
                    if (!leftoverArgs.isEmpty()) {
                        this.objectArgs = leftoverArgs.split(";");
                    }
                } else if (EntityList.func_180125_b((ResourceLocation)new ResourceLocation(entry))) {
                    this.objectType = EntryType.ENTITY;
                    if (entry.contains(":")) {
                        String[] entryArgs = entry.split(":");
                        String mod = StringUtils.getStringFromArray(entryArgs, 0);
                        String entity = StringUtils.getStringFromArray(entryArgs, 1);
                        if (!mod.isEmpty()) {
                            this.modID = mod;
                        }
                        if (!entity.isEmpty()) {
                            this.objectID = entity;
                        }
                    } else {
                        this.objectID = entry;
                    }
                    String leftoverArgs = StringUtils.getStringFromArray(configArgs, 0);
                    if (!leftoverArgs.isEmpty()) {
                        this.objectArgs = leftoverArgs.split(";");
                    }
                } else if (entry.matches(itemIDRegex)) {
                    this.objectType = EntryType.NORMAL;
                    String[] itemArgs = entry.split(":");
                    String mod = StringUtils.getStringFromArray(itemArgs, 0);
                    String item = StringUtils.getStringFromArray(itemArgs, 1);
                    if (!mod.isEmpty()) {
                        this.modID = mod;
                    }
                    if (!item.isEmpty()) {
                        this.objectID = item;
                    }
                    if (mod.equalsIgnoreCase("minecraft") && item.equalsIgnoreCase("potion")) {
                        String leftoverArgs = StringUtils.getStringFromArray(configArgs, 0);
                        if (!leftoverArgs.isEmpty()) {
                            this.objectArgs = leftoverArgs.split(";");
                        }
                    } else {
                        String leftoverArgs;
                        String Meta = StringUtils.getStringFromArray(configArgs, 0);
                        if (!Meta.contentEquals("*") && Meta.matches("([0-9]{1,})")) {
                            try {
                                int wildcard = OreDictionaryCompat.wildcard;
                                this.meta = Integer.parseInt(Meta);
                                if (this.meta > wildcard) {
                                    this.meta = wildcard;
                                }
                                if (this.meta < 0) {
                                    this.meta = wildcard;
                                }
                            }
                            catch (Exception e) {
                                e.printStackTrace();
                            }
                        }
                        if (!(leftoverArgs = StringUtils.getStringFromArray(configArgs, 1)).isEmpty()) {
                            this.objectArgs = leftoverArgs.split(";");
                        }
                    }
                } else if (entry.startsWith("material") && !entry.replaceFirst("material", "").isEmpty()) {
                    this.objectType = EntryType.MATERIAL;
                    this.modID = "ObjectMaterial";
                    this.objectID = entry.replaceFirst("material", "");
                    String leftoverArgs = StringUtils.getStringFromArray(configArgs, 0);
                    if (!leftoverArgs.isEmpty()) {
                        this.objectArgs = leftoverArgs.split(";");
                    }
                } else {
                    this.objectType = EntryType.UNKNOWN;
                    this.modID = "unknown";
                    this.objectID = entry;
                    String leftoverArgs = StringUtils.getStringFromArray(configArgs, 0);
                    if (!leftoverArgs.isEmpty()) {
                        this.objectArgs = leftoverArgs.split(";");
                    }
                }
            }
        }

        public boolean doesItemMatchEntry(@Nonnull ItemStack stack) {
            if (stack == null || stack.func_190926_b() || this.isEmpty()) {
                return false;
            }
            EntryType type = this.getObjectType();
            if (type.equals((Object)EntryType.OREDICTIONARY)) {
                for (String oreDictionary : OreDictionaryCompat.getOreNames(stack)) {
                    if (!oreDictionary.equalsIgnoreCase(this.objectID)) continue;
                    return true;
                }
                return false;
            }
            if (type.equals((Object)EntryType.MATERIAL)) {
                if (stack.func_77973_b() instanceof ItemArmor) {
                    ItemArmor armor = (ItemArmor)stack.func_77973_b();
                    ItemArmor.ArmorMaterial material = armor.func_82812_d();
                    return material.toString().equalsIgnoreCase(this.objectID);
                }
                if (stack.func_77973_b() instanceof ItemTool) {
                    ItemTool tool = (ItemTool)stack.func_77973_b();
                    return tool.func_77861_e().equalsIgnoreCase(this.objectID);
                }
                if (stack.func_77973_b() instanceof ItemSword) {
                    ItemSword sword = (ItemSword)stack.func_77973_b();
                    return sword.func_150932_j().equalsIgnoreCase(this.objectID);
                }
                if (stack.func_77973_b() instanceof ItemHoe) {
                    ItemHoe sword = (ItemHoe)stack.func_77973_b();
                    return sword.func_77842_f().equalsIgnoreCase(this.objectID);
                }
                return false;
            }
            String mod = stack.func_77973_b().getRegistryName().func_110624_b();
            String item = stack.func_77973_b().getRegistryName().func_110623_a();
            if (this.modID.contentEquals("*") || this.modID.contentEquals(mod)) {
                boolean metaMatches;
                boolean bl = metaMatches = this.meta == OreDictionaryCompat.wildcard || stack.func_77960_j() == this.meta;
                if (this.objectID.contentEquals(item) && metaMatches) {
                    return true;
                }
                String objectEntry = this.objectID.replace("*", "");
                boolean startWildcard = this.objectID.startsWith("*");
                boolean endWildcard = this.objectID.endsWith("*");
                if (startWildcard && endWildcard ? item.contains(objectEntry) && metaMatches : (endWildcard ? item.startsWith(objectEntry) && metaMatches : startWildcard && item.endsWith(objectEntry) && metaMatches)) {
                    return true;
                }
            }
            return false;
        }

        public boolean doesBlockMatchEntry(@Nonnull IBlockState state) {
            if (state == null || this.isEmpty()) {
                return false;
            }
            ItemStack blockStack = new ItemStack(state.func_177230_c(), 1, state.func_177230_c().func_176201_c(state));
            return this.doesItemMatchEntry(blockStack);
        }
    }

    public static class AttributeEntry {
        private String attribute;
        private double amount;
        private int operation;
        private boolean isSaved;

        public AttributeEntry(String attribute, double amount, int operation, boolean isSaved) {
            this.attribute = attribute;
            this.amount = amount;
            this.operation = operation;
            this.isSaved = isSaved;
        }

        public String getAttribute() {
            return this.attribute;
        }

        public double getAmount() {
            return this.amount;
        }

        public int getOperation() {
            return this.operation;
        }

        public boolean isSaved() {
            return this.isSaved;
        }

        public String toString() {
            return "AttributeEntry [attribute=" + this.attribute + ", amount=" + this.amount + ", operation=" + this.operation + ", isSaved=" + this.isSaved + "]";
        }
    }

    public static class PotionEntry
    extends ConfigObject {
        protected Potion potion;
        protected PotionEffect effect;
        protected int duration;
        protected int amplifier;

        public PotionEntry(String ConfigEntry) {
            super(ConfigEntry);
        }

        @Override
        public boolean doesItemMatchEntry(ItemStack stack) {
            if (stack == null || stack.func_190926_b() || this.isEmpty()) {
                return false;
            }
            return super.doesItemMatchEntry(stack);
        }
    }

    public static class ArmorEntry
    extends ConfigObject {
        protected double weight;

        public ArmorEntry(String configEntry) {
            super(configEntry);
            this.weight = TrinketsConfig.SERVER.races.faelis.penalty_amount;
            this.initValues(this.getObjectArgs());
        }

        @Override
        public boolean doesItemMatchEntry(ItemStack stack) {
            if (stack == null || stack.func_190926_b() || this.isEmpty()) {
                return false;
            }
            boolean superMatched = super.doesItemMatchEntry(stack);
            if (stack.func_77973_b() instanceof ItemArmor) {
                ItemArmor armor = (ItemArmor)stack.func_77973_b();
                String armorType = armor.field_77881_a.func_188450_d();
                String optionalType = StringUtils.getStringFromArray(this.getObjectArgs(), 0);
                if (!optionalType.isEmpty() && optionalType.matches("([a-zA-Z]{1,})")) {
                    String fixedType = this.fixArmorType(optionalType);
                    return superMatched && armorType.equalsIgnoreCase(fixedType);
                }
            }
            return superMatched;
        }

        private void initValues(String[] args) {
            String optionalType = StringUtils.getStringFromArray(this.getObjectArgs(), 0);
            if (!optionalType.isEmpty()) {
                if (optionalType.matches(doubleRegex)) {
                    try {
                        this.weight = Double.parseDouble(optionalType);
                    }
                    catch (Exception e) {
                        Trinkets.log.error("Invalid format for entry: " + this.getOriginalEntry());
                        e.printStackTrace();
                        this.weight = 0.0;
                    }
                } else {
                    String optionalWeight = StringUtils.getStringFromArray(this.getObjectArgs(), 1);
                    if (!optionalWeight.isEmpty() && optionalWeight.matches(doubleRegex)) {
                        try {
                            this.weight = Double.parseDouble(optionalWeight);
                        }
                        catch (Exception e) {
                            Trinkets.log.error("Invalid format for entry: " + this.getOriginalEntry());
                            e.printStackTrace();
                            this.weight = 0.0;
                        }
                    }
                }
            }
        }

        protected String fixArmorType(String string) {
            return string.replace("boot", "feet").replace("boots", "feet").replace("feets", "feet").replace("leggings", "legs").replace("pants", "legs").replace("chestplate", "chest").replace("shirt", "chest").replace("helm", "head").replace("hat", "head");
        }

        public final double getWeight() {
            return this.weight;
        }
    }

    public static class MPRecoveryItem
    extends ConfigObject {
        protected float amount;
        protected boolean multiplied;

        public MPRecoveryItem(String configEntry) {
            super(configEntry);
            this.initValues(this.getObjectArgs());
        }

        private void initValues(String[] args) {
            String Amount = StringUtils.getStringFromArray(args, 0);
            if (!Amount.isEmpty()) {
                if (Amount.endsWith("%")) {
                    this.multiplied = true;
                }
                Amount = Amount.replace("%", "");
                try {
                    this.amount = Float.parseFloat(Amount);
                }
                catch (Exception e) {
                    Trinkets.log.error("Invalid format for entry: " + this.getOriginalEntry());
                    e.printStackTrace();
                    this.amount = 0.0f;
                }
            }
        }

        public final float getAmount() {
            return this.amount;
        }

        public final boolean isMultiplied() {
            return this.multiplied;
        }
    }

    public static class TreasureEntry
    extends ConfigObject {
        protected int color = 16766720;

        public TreasureEntry(String configEntry) {
            super(configEntry);
            this.initValues(this.getObjectArgs());
        }

        private void initValues(String[] args) {
            String Color = StringUtils.getStringFromArray(args, 0);
            if (!Color.isEmpty()) {
                try {
                    this.color = Integer.parseInt(Color.replace("*", OreDictionaryCompat.wildcard + ""));
                }
                catch (Exception e) {
                    Trinkets.log.error("Invalid format for entry: " + this.getOriginalEntry());
                    e.printStackTrace();
                    this.color = 16766720;
                }
            }
        }

        public final int getColor() {
            return this.color;
        }
    }

    public static class TrinketConfigStorage {
        public static TreeMap<String, MPRecoveryItem> MagicRecoveryItems = new TreeMap();
        public static TreeMap<Integer, TreasureEntry> TreasureBlocks = new TreeMap();
        public static TreeMap<String, ConfigObject> ClimbableBlocks = new TreeMap();
        public static TreeMap<String, ArmorEntry> ArmorWeightValues = new TreeMap();

        public static void init() {
            TrinketConfigStorage.initRecoveryItems();
            TrinketConfigStorage.initArmorWeightValues();
            TrinketConfigStorage.initTreasureBlocks();
        }

        private static void initTreasureBlocks() {
            if (!TreasureBlocks.isEmpty()) {
                TreasureBlocks.clear();
            }
            String[] treasures = TrinketsConfig.SERVER.Items.DRAGON_EYE.BLOCKS.Blocks;
            int index = 0;
            for (String entry : treasures) {
                TreasureEntry treasure = new TreasureEntry(entry);
                if (treasure.isEmpty()) continue;
                TreasureBlocks.put(index, treasure);
                ++index;
            }
        }

        private static void initArmorWeightValues() {
            String[] weightValues;
            if (!ArmorWeightValues.isEmpty()) {
                ArmorWeightValues.clear();
            }
            for (String entry : weightValues = TrinketsConfig.SERVER.races.faelis.heavyArmor) {
                ArmorEntry weightValue = new ArmorEntry(entry);
                if (weightValue.isEmpty()) continue;
                ArmorWeightValues.put(weightValue.getObjectRegistryName(), weightValue);
            }
        }

        private static void initRecoveryItems() {
            String[] recovery;
            if (!MagicRecoveryItems.isEmpty()) {
                MagicRecoveryItems.clear();
            }
            for (String entry : recovery = TrinketsConfig.SERVER.mana.recovery) {
                MPRecoveryItem recoveryItem = new MPRecoveryItem(entry);
                if (recoveryItem.isEmpty()) continue;
                MagicRecoveryItems.put(recoveryItem.getObjectRegistryName(), recoveryItem);
            }
        }
    }
}

