/*
 * Decompiled with CFR 0.152.
 */
package xzeroair.trinkets.traits.abilities;

import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import xzeroair.trinkets.Trinkets;
import xzeroair.trinkets.capabilities.Capabilities;
import xzeroair.trinkets.capabilities.statushandler.StatusHandler;
import xzeroair.trinkets.capabilities.statushandler.TrinketStatusEffect;
import xzeroair.trinkets.network.NetworkHandler;
import xzeroair.trinkets.network.particles.EffectsRenderPacket;
import xzeroair.trinkets.traits.abilities.Ability;
import xzeroair.trinkets.traits.abilities.interfaces.IMovementAbility;
import xzeroair.trinkets.traits.abilities.interfaces.ITickableAbility;
import xzeroair.trinkets.traits.statuseffects.StatusEffectsEnum;
import xzeroair.trinkets.util.TrinketsConfig;
import xzeroair.trinkets.util.config.trinkets.ConfigArcingOrb;
import xzeroair.trinkets.util.handlers.Counter;

public class AbilityDodge
extends Ability
implements ITickableAbility,
IMovementAbility {
    public final ConfigArcingOrb serverConfig;
    int keyPresses;
    String keyPressed;
    int direction;
    Long lastKeyPress;
    boolean trigger;

    public AbilityDodge() {
        super("dodging");
        this.serverConfig = TrinketsConfig.SERVER.Items.ARCING_ORB;
        this.keyPresses = 0;
        this.direction = -1;
        this.lastKeyPress = -1L;
    }

    @Override
    public void tickAbility(EntityLivingBase entity) {
        Counter counter = this.tickHandler.getCounter("lastKeyPress");
        if (counter != null && counter.Tick()) {
            this.reset();
        }
    }

    public void handleDodge(Entity entity, int direction) {
        if (entity == null) {
            return;
        }
        float yaw = entity.field_70177_z;
        Vec3d look = entity.func_70040_Z();
        EnumFacing.AxisDirection facing = entity.func_174811_aO().func_176743_c();
        EnumFacing.Axis axis = entity.func_174811_aO().func_176740_k();
        double x = 0.0;
        double z = 0.0;
        if (axis == EnumFacing.Axis.Z) {
            if (facing == EnumFacing.AxisDirection.POSITIVE) {
                x = entity.func_70040_Z().field_72449_c;
                z = -entity.func_70040_Z().field_72450_a;
            } else {
                x = entity.func_70040_Z().field_72449_c;
                z = -entity.func_70040_Z().field_72450_a;
            }
        } else if (facing == EnumFacing.AxisDirection.POSITIVE) {
            x = entity.func_70040_Z().field_72449_c;
            z = -entity.func_70040_Z().field_72450_a;
        } else {
            x = entity.func_70040_Z().field_72449_c;
            z = -entity.func_70040_Z().field_72450_a;
        }
        double spd = 1.25;
        double xV = 0.0;
        double yV = 0.0;
        double zV = 0.0;
        if (direction == 1) {
            xV = look.field_72449_c * 1.25;
            yV = 0.3;
            zV = -look.field_72450_a * 1.25;
        } else if (direction == 3) {
            xV = -look.field_72449_c * 1.25;
            yV = 0.3;
            zV = look.field_72450_a * 1.25;
        } else if (direction == 2) {
            xV = look.field_72450_a * 1.25;
            yV = 0.3;
            zV = look.field_72449_c * 1.25;
        } else if (direction == 0) {
            xV = -look.field_72450_a * 2.0;
            yV = 0.5;
            zV = -look.field_72449_c * 2.0;
        } else {
            xV = 0.0;
            yV = 0.0;
            zV = 0.0;
        }
        if (entity.field_70122_E) {
            if (entity.field_70170_p.field_72995_K) {
                entity.func_70016_h(xV, yV, zV);
            } else {
                this.dodge(entity);
            }
        }
    }

    public void dodge(Entity entity) {
        World w;
        if (!entity.func_130014_f_().field_72995_K && (w = entity.func_130014_f_()) instanceof WorldServer) {
            WorldServer world = (WorldServer)w;
            NetworkHandler.sendToClients(world, entity.func_180425_c(), new EffectsRenderPacket(entity, entity.field_70165_t, entity.field_70163_u + (double)(entity.field_70131_O * 0.5f), entity.field_70161_v, entity.field_70165_t, entity.field_70163_u, entity.field_70161_v, 2515356, 2, 1.0f, 1.0f));
        }
        double distance = TrinketsConfig.SERVER.Items.ARCING_ORB.stunDistance;
        List stunTargets = entity.field_70170_p.func_72872_a(EntityLivingBase.class, entity.func_174813_aQ().func_72314_b(distance, 1.0, distance));
        for (EntityLivingBase targetEntity : stunTargets) {
            StatusHandler status;
            if (targetEntity == entity || (status = Capabilities.getStatusHandler((Entity)targetEntity)) == null) continue;
            TrinketStatusEffect effect = new TrinketStatusEffect(StatusEffectsEnum.paralysis, 60, 1, entity);
            status.apply(effect);
        }
    }

    public boolean triggerDodge(Entity entity) {
        if (this.trigger) {
            this.trigger = false;
            if (entity.field_70170_p.field_72995_K && (!entity.field_70122_E || entity.func_70093_af())) {
                return false;
            }
            if (Trinkets.ElenaiDodge1 && TrinketsConfig.compat.elenaiDodge) {
                return false;
            }
            float cost = this.serverConfig.dodgeCost;
            return Capabilities.getMagicStats(entity, true, (magic, rtn) -> magic.spendMana(cost));
        }
        return false;
    }

    @Override
    public boolean left(Entity entity, int state) {
        if (state == 0) {
            if (this.handleKeys(EnumDirection.Left)) {
                if (this.triggerDodge(entity)) {
                    this.handleDodge(entity, 1);
                } else {
                    return false;
                }
            }
            return true;
        }
        if (state == 1) {
            return true;
        }
        return true;
    }

    @Override
    public boolean right(Entity entity, int state) {
        if (state == 0) {
            if (this.handleKeys(EnumDirection.Right)) {
                if (this.triggerDodge(entity)) {
                    this.handleDodge(entity, 3);
                } else {
                    return false;
                }
            }
            return true;
        }
        if (state == 1) {
            return true;
        }
        return true;
    }

    @Override
    public boolean forward(Entity entity, int state) {
        if (state == 0) {
            if (this.handleKeys(EnumDirection.Forward)) {
                if (this.triggerDodge(entity)) {
                    this.handleDodge(entity, 2);
                } else {
                    return false;
                }
            }
            return true;
        }
        if (state == 1) {
            return true;
        }
        return true;
    }

    @Override
    public boolean back(Entity entity, int state) {
        if (state == 0) {
            if (this.handleKeys(EnumDirection.Back)) {
                if (this.triggerDodge(entity)) {
                    this.handleDodge(entity, 0);
                } else {
                    return false;
                }
            }
            return true;
        }
        if (state == 1) {
            return true;
        }
        return true;
    }

    @Override
    public boolean jump(Entity entity, int state) {
        return false;
    }

    @Override
    public boolean sneak(Entity entity, int state) {
        return false;
    }

    private void reset() {
        this.trigger = false;
        this.keyPresses = 0;
        this.lastKeyPress = -1L;
        this.direction = -1;
        this.tickHandler.removeCounter("lastKeyPress");
    }

    private boolean handleKeys(int direction) {
        Counter counter;
        if (this.direction != direction) {
            this.reset();
        }
        if ((counter = this.tickHandler.getCounter("lastKeyPress")) != null) {
            ++this.keyPresses;
        } else {
            Counter newCounter = this.tickHandler.getCounter("lastKeyPress", 3, true, true, true, false);
            this.direction = direction;
            this.keyPresses = 1;
        }
        if (this.keyPresses >= 2) {
            this.reset();
            this.trigger = true;
        }
        return this.trigger;
    }

    private boolean handleKeys(EnumDirection direction) {
        return this.handleKeys(direction.getID());
    }

    private static enum EnumDirection {
        Left(1),
        Right(3),
        Forward(2),
        Back(0),
        Up(4),
        Down(5);

        private final int ID;

        private EnumDirection(int direction) {
            this.ID = direction;
        }

        public int getID() {
            return this.ID;
        }
    }
}

