/*
 * Decompiled with CFR 0.152.
 */
package xzeroair.trinkets.traits;

import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.Potion;
import net.minecraft.util.NonNullList;
import xzeroair.trinkets.Trinkets;
import xzeroair.trinkets.api.TrinketHelper;
import xzeroair.trinkets.capabilities.Capabilities;
import xzeroair.trinkets.init.EntityRaces;
import xzeroair.trinkets.races.EntityRace;
import xzeroair.trinkets.traits.abilities.interfaces.IAbilityInterface;
import xzeroair.trinkets.traits.abilities.interfaces.IContainerAbility;
import xzeroair.trinkets.traits.abilities.interfaces.IEquippedAbility;
import xzeroair.trinkets.traits.abilities.interfaces.IHeldAbility;
import xzeroair.trinkets.traits.abilities.interfaces.ITickableAbility;
import xzeroair.trinkets.traits.abilities.interfaces.ITickableInventoryAbility;

public class AbilityHandler {
    protected Map<String, AbilityHolder> active = new TreeMap<String, AbilityHolder>();
    protected boolean hasChanged = false;
    protected EntityLivingBase entity;

    public AbilityHandler(EntityLivingBase entity) {
        this.entity = entity;
    }

    public Map<String, AbilityHolder> getActiveAbilities() {
        return this.active;
    }

    public void registerAbilities(String source, List<? extends IAbilityInterface> abilities) {
        for (IAbilityInterface iAbilityInterface : abilities) {
            this.registerAbility(source, new TrinketHelper.SlotInformation(TrinketHelper.SlotInformation.ItemHandlerType.OTHER), iAbilityInterface);
        }
    }

    public void registerAbilities(String source, TrinketHelper.SlotInformation info, List<? extends IAbilityInterface> abilities) {
        for (IAbilityInterface iAbilityInterface : abilities) {
            this.registerAbility(source, info, iAbilityInterface);
        }
    }

    public void registerRaceAbility(String source, IAbilityInterface ability) {
        this.replaceAbility(source, new TrinketHelper.SlotInformation(TrinketHelper.SlotInformation.ItemHandlerType.RACE), ability);
    }

    public void replaceAbility(String source, TrinketHelper.SlotInformation info, IAbilityInterface ability) {
        AbilityHolder value;
        String key = ability.getRegistryName().toString();
        if (info == null) {
            info = new TrinketHelper.SlotInformation(TrinketHelper.SlotInformation.ItemHandlerType.OTHER);
        }
        if ((value = this.active.get(key)) == null) {
            ability.onAbilityAdded(this.entity);
            AbilityHolder holder = new AbilityHolder(source, info, ability);
            this.active.put(key, holder);
            this.hasChanged = true;
        } else {
            boolean sameSlot;
            boolean sameSource = value.getSourceID().contentEquals(source);
            boolean sameHandler = value.getInfo().getHandlerType() == info.getHandlerType();
            boolean bl = sameSlot = value.getInfo().getSlot() == info.getSlot();
            if (!(sameSource && sameHandler && sameSlot)) {
                value.getAbility().onAbilityRemoved(this.entity);
                ability.onAbilityAdded(this.entity);
                AbilityHolder holder = new AbilityHolder(source, info, ability);
                this.active.put(key, holder);
                this.hasChanged = true;
            }
        }
    }

    @Nullable
    public IAbilityInterface registerAbility(String source, IAbilityInterface ability) {
        return this.registerAbility(source, new TrinketHelper.SlotInformation(TrinketHelper.SlotInformation.ItemHandlerType.OTHER), ability);
    }

    @Nullable
    public IAbilityInterface registerAbility(String source, TrinketHelper.SlotInformation info, IAbilityInterface ability) {
        String key = ability.getRegistryName().toString();
        if (info == null) {
            info = new TrinketHelper.SlotInformation(TrinketHelper.SlotInformation.ItemHandlerType.OTHER);
        }
        if (!this.active.containsKey(key)) {
            ability.onAbilityAdded(this.entity);
            AbilityHolder holder = new AbilityHolder(source, info, ability);
            this.active.put(key, holder);
            this.hasChanged = true;
            return null;
        }
        return ability;
    }

    @Nullable
    public IAbilityInterface removeAbility(String ability) {
        if (this.active.containsKey(ability)) {
            AbilityHolder oldHolder = this.active.remove(ability);
            IAbilityInterface oldAbility = oldHolder.getAbility();
            oldAbility.onAbilityRemoved(this.entity);
            this.hasChanged = true;
            return oldAbility;
        }
        return null;
    }

    @Nullable
    public AbilityHolder getAbilityHolder(String ability) {
        if (this.active.containsKey(ability)) {
            return this.active.get(ability);
        }
        return null;
    }

    @Nullable
    public IAbilityInterface getAbility(String ability) {
        AbilityHolder holder = this.getAbilityHolder(ability);
        if (holder != null) {
            return holder.getAbility();
        }
        return null;
    }

    public void updateAbilityHandler() {
        this.active.values().removeIf(cache -> cache.getAbility().shouldRemove());
        for (Map.Entry<String, AbilityHolder> entry : this.active.entrySet()) {
            NBTTagCompound data;
            String key = entry.getKey();
            AbilityHolder cache2 = entry.getValue();
            String source = cache2.getSourceID();
            TrinketHelper.SlotInformation sourceInfo = cache2.getInfo();
            IAbilityInterface ability = cache2.getAbility();
            boolean remove = this.shouldRemove(sourceInfo, source, this.entity);
            if (this.hasChanged && (data = Capabilities.getEntityProperties((Entity)this.entity, new NBTTagCompound(), (prop, rtn) -> prop.getTag())).func_74764_b("Abilities")) {
                NBTTagCompound tag = data.func_74775_l("Abilities");
                this.loadAbilityFromNBT(ability, tag);
            }
            this.processAbility(ability, this.entity);
            if (!remove && !ability.shouldRemove()) continue;
            ability.scheduleRemoval();
            ability.onAbilityRemoved(this.entity);
            NBTTagCompound entityTag = Capabilities.getEntityProperties((Entity)this.entity, new NBTTagCompound(), (prop, rtn) -> prop.getTag());
            if (!entityTag.func_74764_b("Abilities")) {
                entityTag.func_74782_a("Abilities", (NBTBase)new NBTTagCompound());
            }
            NBTTagCompound abilitiesTag = entityTag.func_74775_l("Abilities");
            this.saveAbilityToNBT(ability, abilitiesTag);
        }
        if (this.hasChanged) {
            this.hasChanged = false;
        }
    }

    private void processAbility(IAbilityInterface ability, EntityLivingBase entity) {
        try {
            IAbilityInterface a;
            TrinketHelper.SlotInformation info;
            AbilityHolder holder = this.getAbilityHolder(ability.getRegistryName().toString());
            TrinketHelper.SlotInformation slotInformation = info = holder != null ? holder.getInfo() : null;
            if (ability instanceof ITickableAbility) {
                ((ITickableAbility)ability).tickAbility(entity);
            }
            if (ability instanceof IEquippedAbility) {
                a = (IEquippedAbility)ability;
                a.head(entity.func_184582_a(EntityEquipmentSlot.HEAD), entity);
                a.chest(entity.func_184582_a(EntityEquipmentSlot.CHEST), entity);
                a.legs(entity.func_184582_a(EntityEquipmentSlot.LEGS), entity);
                a.feet(entity.func_184582_a(EntityEquipmentSlot.FEET), entity);
            }
            if (ability instanceof IHeldAbility) {
                a = (IHeldAbility)ability;
                a.heldMainHand(entity.func_184614_ca(), entity);
                a.heldOffhand(entity.func_184592_cb(), entity);
            }
            if (entity instanceof EntityPlayer) {
                IContainerAbility a2;
                EntityPlayer player = (EntityPlayer)entity;
                if (ability instanceof IContainerAbility) {
                    a2 = (IContainerAbility)ability;
                    a2.inventoryContainer(player.field_71069_bz);
                    a2.openContainer(player.field_71070_bA);
                    a2.playerInventory(player.field_71071_by);
                }
                if (ability instanceof ITickableInventoryAbility) {
                    a2 = (ITickableInventoryAbility)ability;
                    int inHand = player.field_71071_by.field_70461_c;
                    if (info != null) {
                        ItemStack stack = info.getStackFromHandler((EntityLivingBase)player);
                        if (!stack.func_190926_b()) {
                            int slot = info.getSlot();
                            boolean selected = info.getHandlerType().equals((Object)TrinketHelper.SlotInformation.ItemHandlerType.MAINHAND) && inHand == slot;
                            a2.onUpdate(stack, player.field_70170_p, (Entity)player, slot, selected);
                        } else {
                            NonNullList inventory = player.field_71071_by.field_70462_a;
                            for (int index = 0; index < inventory.size(); ++index) {
                                ItemStack IStack = (ItemStack)inventory.get(index);
                                if (IStack.func_190926_b()) continue;
                                a2.onUpdate(IStack, player.field_70170_p, (Entity)player, index, inHand == index);
                            }
                        }
                    }
                }
            }
        }
        catch (Exception e) {
            Trinkets.log.error("Error with ability:" + ability.getRegistryName().toString());
            e.printStackTrace();
        }
    }

    private boolean shouldRemove(TrinketHelper.SlotInformation info, String source, EntityLivingBase entity) {
        switch (info.getHandlerType()) {
            case NONE: {
                return true;
            }
            case OTHER: {
                return false;
            }
            case RACE: {
                EntityRace race = Capabilities.getEntityProperties((Entity)entity, EntityRaces.none, (prop, rtn) -> prop.getCurrentRace());
                return race.isNone() || !race.getRegistryName().toString().contentEquals(source);
            }
            case POTION: {
                Potion potion = Potion.func_180142_b((String)source);
                return potion == null ? true : !entity.func_70644_a(potion);
            }
        }
        ItemStack s = info.getStackFromHandler(entity);
        boolean remove = s.func_190926_b() || !s.func_77973_b().getRegistryName().toString().contentEquals(source);
        return remove;
    }

    public void copyFrom(AbilityHandler source, boolean wasDeath, boolean keepInv) {
        if (!wasDeath) {
            this.active = source.active;
        }
    }

    public NBTTagCompound saveAbilityToNBT(IAbilityInterface ability, NBTTagCompound compound) {
        String key = ability.getRegistryName().toString();
        if (!compound.func_74764_b(key)) {
            compound.func_74782_a(key, (NBTBase)new NBTTagCompound());
        }
        ability.saveStorage(compound.func_74775_l(key));
        return compound;
    }

    public void loadAbilityFromNBT(IAbilityInterface ability, NBTTagCompound compound) {
        String key = ability.getRegistryName().toString();
        if (compound.func_74764_b(key)) {
            ability.loadStorage(compound.func_74775_l(key));
        }
    }

    public NBTTagCompound saveAbilitiesToNBT(NBTTagCompound compound) {
        if (!compound.func_74764_b("Abilities")) {
            compound.func_74782_a("Abilities", (NBTBase)new NBTTagCompound());
        }
        NBTTagCompound abilityNBT = compound.func_74775_l("Abilities");
        for (Map.Entry<String, AbilityHolder> entry : this.active.entrySet()) {
            String key = entry.getKey();
            AbilityHolder value = entry.getValue();
            try {
                this.saveAbilityToNBT(value.getAbility(), abilityNBT);
            }
            catch (Exception e) {
                Trinkets.log.error("Error when saving ability:" + key);
                e.printStackTrace();
            }
        }
        return compound;
    }

    public void loadAbilitiesFromNBT(NBTTagCompound compound) {
        if (compound.func_74764_b("Abilities")) {
            NBTTagCompound abilityNBT = compound.func_74775_l("Abilities");
            for (Map.Entry<String, AbilityHolder> entry : this.active.entrySet()) {
                String key = entry.getKey();
                AbilityHolder value = entry.getValue();
                try {
                    this.loadAbilityFromNBT(value.getAbility(), abilityNBT);
                }
                catch (Exception e) {
                    Trinkets.log.error("Error when saving ability:" + key);
                    e.printStackTrace();
                }
            }
        }
    }

    public class AbilityHolder {
        protected String source;
        protected TrinketHelper.SlotInformation info;
        protected IAbilityInterface ability;

        public AbilityHolder(String source, TrinketHelper.SlotInformation info, IAbilityInterface ability) {
            this.source = source;
            this.info = info;
            this.ability = ability.cacheAbilityHolder(this);
        }

        public final String getSourceID() {
            return this.source;
        }

        public final TrinketHelper.SlotInformation getInfo() {
            return this.info;
        }

        public final IAbilityInterface getAbility() {
            return this.ability;
        }
    }
}

