/*
 * Decompiled with CFR 0.152.
 */
package xzeroair.trinkets.races.titan;

import java.util.Arrays;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.client.renderer.entity.RenderPlayer;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.registry.EntityRegistry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import xzeroair.trinkets.init.EntityRaces;
import xzeroair.trinkets.races.EntityRacePropertiesHandler;
import xzeroair.trinkets.races.titan.config.TitanConfig;
import xzeroair.trinkets.traits.abilities.other.AbilityHeavy;
import xzeroair.trinkets.traits.abilities.other.AbilityLargeHands;
import xzeroair.trinkets.util.TrinketsConfig;

public class RaceTitan
extends EntityRacePropertiesHandler {
    public static final TitanConfig serverConfig = TrinketsConfig.SERVER.races.titan;
    public static List<String> disallowedMounts = Arrays.asList(RaceTitan.serverConfig.mountBlacklist);

    public RaceTitan(@Nonnull EntityLivingBase e) {
        super(e, EntityRaces.titan);
        disallowedMounts = Arrays.asList(RaceTitan.serverConfig.mountBlacklist);
    }

    @Override
    public void startTransformation() {
        this.addAbility(new AbilityLargeHands());
        if (RaceTitan.serverConfig.sink) {
            this.addAbility(new AbilityHeavy());
        }
    }

    @Override
    public void whileTransformed() {
        Entity mount;
        if (!this.entity.field_70170_p.field_72995_K && this.entity.func_184218_aH() && (mount = this.entity.func_184187_bx()) != null && !this.mountEntity(mount)) {
            this.entity.func_184210_p();
        }
    }

    @Override
    public boolean mountEntity(Entity mount) {
        if (this.isCreativePlayer()) {
            return true;
        }
        if (!RaceTitan.serverConfig.canMount) {
            return false;
        }
        if (!disallowedMounts.isEmpty()) {
            try {
                ResourceLocation regName = EntityRegistry.getEntry(mount.getClass()).getRegistryName();
                String modID = regName.func_110624_b();
                String entityID = regName.func_110623_a();
                boolean doesWildcardExist = disallowedMounts.contains(modID + ":*");
                boolean exists = disallowedMounts.contains(regName.toString());
                if (doesWildcardExist || exists) {
                    return RaceTitan.serverConfig.whitelist;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return !RaceTitan.serverConfig.whitelist;
        }
        return true;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void doRenderPlayerPre(EntityPlayer entity, double x, double y, double z, RenderPlayer renderer, float partialTick) {
        super.doRenderPlayerPre(entity, x, y, z, renderer, partialTick);
        if (entity.field_70721_aZ > 0.0f) {
            entity.field_70721_aZ -= 0.04f;
        }
    }
}

