/*
 * Decompiled with CFR 0.152.
 */
package xzeroair.trinkets.races.elf;

import java.util.Set;
import java.util.UUID;
import javax.annotation.Nonnull;
import net.minecraft.client.model.ModelBase;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.entity.RenderLivingBase;
import net.minecraft.client.renderer.entity.RenderPlayer;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import xzeroair.trinkets.attributes.JumpAttribute;
import xzeroair.trinkets.attributes.UpdatingAttribute;
import xzeroair.trinkets.client.model.ElfEars;
import xzeroair.trinkets.init.EntityRaces;
import xzeroair.trinkets.races.EntityRacePropertiesHandler;
import xzeroair.trinkets.races.elf.config.ElfConfig;
import xzeroair.trinkets.traits.abilities.AbilityChargedShot;
import xzeroair.trinkets.util.TrinketsConfig;
import xzeroair.trinkets.util.helpers.AttributeHelper;
import xzeroair.trinkets.util.helpers.ColorHelper;
import xzeroair.trinkets.util.helpers.DrawingHelper;

public class RaceElf
extends EntityRacePropertiesHandler {
    public static final ElfConfig serverConfig = TrinketsConfig.SERVER.races.elf;
    protected UpdatingAttribute bonusSpeed;
    protected UpdatingAttribute bonusAtkSpeed;
    protected UpdatingAttribute jump;
    private ModelBase ears = new ElfEars();
    public static final ResourceLocation TEXTURE = new ResourceLocation("xat:textures/ears.png");
    public static final ResourceLocation TEXTURE_INNER = new ResourceLocation("xat:textures/inner_ears.png");
    public static final ResourceLocation TEXTURE_OUTER = new ResourceLocation("xat:textures/outer_ears.png");

    public RaceElf(@Nonnull EntityLivingBase e) {
        super(e, EntityRaces.elf);
        this.bonusSpeed = new UpdatingAttribute(UUID.fromString("628dedc0-5f63-4b45-bccb-ecb0fe881b49"), SharedMonsterAttributes.field_111263_d).setSavedInNBT(false);
        this.bonusAtkSpeed = new UpdatingAttribute(UUID.fromString("628dedc0-5f63-4b45-bccb-ecb0fe881b49"), SharedMonsterAttributes.field_188790_f).setSavedInNBT(false);
        this.jump = new UpdatingAttribute(UUID.fromString("628dedc0-5f63-4b45-bccb-ecb0fe881b49"), JumpAttribute.Jump).setSavedInNBT(false);
    }

    @Override
    public void startTransformation() {
        if (RaceElf.serverConfig.charge_shot) {
            this.addAbility(new AbilityChargedShot());
        }
    }

    @Override
    public void whileTransformed() {
        if (this.entity.field_70170_p.field_72995_K) {
            return;
        }
        try {
            if (this.entity.field_70170_p.func_180494_b(this.entity.func_180425_c()) != null) {
                Set biomeType = BiomeDictionary.getTypes((Biome)this.entity.field_70170_p.func_180494_b(this.entity.func_180425_c()));
                if (biomeType.contains(BiomeDictionary.Type.FOREST)) {
                    this.bonusSpeed.addModifier(this.entity, 0.2, 2);
                    this.bonusAtkSpeed.addModifier(this.entity, 0.5, 2);
                    this.jump.addModifier(this.entity, 0.2, 2);
                } else {
                    this.bonusSpeed.removeModifier(this.entity);
                    this.bonusAtkSpeed.removeModifier(this.entity);
                    this.jump.removeModifier(this.entity);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void endTransformation() {
        AttributeHelper.removeAttributes(this.entity, UUID.fromString("628dedc0-5f63-4b45-bccb-ecb0fe881b49"));
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void doRenderLayer(RenderLivingBase renderer, boolean isFake, boolean isSlim, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch, float scale) {
        if (!TrinketsConfig.CLIENT.rendering || !this.showTraits()) {
            return;
        }
        this.ears = new ElfEars();
        GlStateManager.func_179094_E();
        if (this.entity.func_70093_af()) {
            GlStateManager.func_179137_b((double)0.0, (double)0.2, (double)0.0);
        }
        if (renderer instanceof RenderPlayer) {
            RenderPlayer rend = (RenderPlayer)renderer;
            rend.func_177087_b().field_78116_c.func_78794_c(scale);
        }
        if (this.entity.func_190630_a(EntityEquipmentSlot.HEAD)) {
            GlStateManager.func_179109_b((float)0.0f, (float)-0.02f, (float)-0.045f);
            GlStateManager.func_179152_a((float)1.1f, (float)1.1f, (float)1.1f);
        }
        float[] rgb = ColorHelper.getRGBColor(this.getTraitVariant() == 1 ? this.getAltTraitColor() : this.getTraitColor());
        float[] rgb2 = ColorHelper.getRGBColor(this.getTraitVariant() == 1 ? this.getTraitColor() : this.getAltTraitColor());
        float fscale = 0.3f;
        GlStateManager.func_179152_a((float)0.3f, (float)0.3f, (float)0.3f);
        double x = 0.0;
        double y = -1.5;
        double height = 1.0;
        double width = 1.0;
        double z = -0.4;
        float u = 16.0f;
        float v = 0.0f;
        int uWidth = 16;
        int vHeight = 16;
        float tileWidth = 64.0f;
        float tileHeight = 32.0f;
        double xR = 0.72;
        double xL = -0.72;
        float rot = 26.0f;
        int solidVariant = 2;
        GlStateManager.func_179140_f();
        GlStateManager.func_179129_p();
        GlStateManager.func_179147_l();
        GlStateManager.func_179120_a((int)770, (int)771, (int)1, (int)0);
        GlStateManager.func_179114_b((float)(-rot), (float)0.0f, (float)1.0f, (float)0.0f);
        if (this.getTraitVariant() == 2) {
            DrawingHelper.Draw(TEXTURE, 0.72, -1.5, -0.4, 16.0f, 0.0f, 16, 16, 1.0, 1.0, 64.0f, 32.0f, rgb[0], rgb[1], rgb[2], 1.0f);
            DrawingHelper.Draw(TEXTURE, 0.72, -1.5, -0.39990000000000003, 16.0f, 16.0f, 16, 16, 1.0, 1.0, 64.0f, 32.0f, rgb[0], rgb[1], rgb[2], 1.0f);
        } else {
            DrawingHelper.Draw(TEXTURE_INNER, 0.72, -1.5, -0.4, 16.0f, 0.0f, 16, 16, 1.0, 1.0, 64.0f, 32.0f, rgb[0], rgb[1], rgb[2], 1.0f);
            DrawingHelper.Draw(TEXTURE_OUTER, 0.72, -1.5, -0.4, 16.0f, 0.0f, 16, 16, 1.0, 1.0, 64.0f, 32.0f, rgb2[0], rgb2[1], rgb2[2], 1.0f);
            DrawingHelper.Draw(TEXTURE_OUTER, 0.72, -1.5, -0.39990000000000003, 16.0f, 16.0f, 16, 16, 1.0, 1.0, 64.0f, 32.0f, rgb2[0], rgb2[1], rgb2[2], 1.0f);
        }
        GlStateManager.func_179114_b((float)(rot * 2.0f), (float)0.0f, (float)1.0f, (float)0.0f);
        if (this.getTraitVariant() == 2) {
            DrawingHelper.Draw(TEXTURE, -0.72, -1.5, -0.4, 16.0f, 0.0f, 16, 16, -1.0, 1.0, 64.0f, 32.0f, rgb[0], rgb[1], rgb[2], 1.0f);
            DrawingHelper.Draw(TEXTURE, -0.72, -1.5, -0.39990000000000003, 16.0f, 16.0f, 16, 16, -1.0, 1.0, 64.0f, 32.0f, rgb[0], rgb[1], rgb[2], 1.0f);
        } else {
            DrawingHelper.Draw(TEXTURE_INNER, -0.72, -1.5, -0.4, 16.0f, 0.0f, 16, 16, -1.0, 1.0, 64.0f, 32.0f, rgb[0], rgb[1], rgb[2], 1.0f);
            DrawingHelper.Draw(TEXTURE_OUTER, -0.72, -1.5, -0.4, 16.0f, 0.0f, 16, 16, -1.0, 1.0, 64.0f, 32.0f, rgb2[0], rgb2[1], rgb2[2], 1.0f);
            DrawingHelper.Draw(TEXTURE_OUTER, -0.72, -1.5, -0.39990000000000003, 16.0f, 16.0f, 16, 16, -1.0, 1.0, 64.0f, 32.0f, rgb2[0], rgb2[1], rgb2[2], 1.0f);
        }
        GlStateManager.func_179145_e();
        GlStateManager.func_179089_o();
        GlStateManager.func_179084_k();
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_179121_F();
    }
}

