/*
 * Decompiled with CFR 0.152.
 */
package xzeroair.trinkets.races;

import java.util.function.BiFunction;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiChat;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.entity.RenderLivingBase;
import net.minecraft.client.renderer.entity.RenderPlayer;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.ai.attributes.IAttributeInstance;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import xzeroair.trinkets.Trinkets;
import xzeroair.trinkets.attributes.UpdatingAttribute;
import xzeroair.trinkets.capabilities.Capabilities;
import xzeroair.trinkets.capabilities.race.EntityProperties;
import xzeroair.trinkets.client.gui.entityPropertiesGui.GuiEntityProperties;
import xzeroair.trinkets.client.gui.hud.mana.ManaHud;
import xzeroair.trinkets.init.EntityRaces;
import xzeroair.trinkets.network.IncreasedReachPacket;
import xzeroair.trinkets.network.NetworkHandler;
import xzeroair.trinkets.races.EntityRace;
import xzeroair.trinkets.races.IRaceHandler;
import xzeroair.trinkets.traits.abilities.interfaces.IAbilityInterface;
import xzeroair.trinkets.util.Reference;
import xzeroair.trinkets.util.TrinketsConfig;
import xzeroair.trinkets.util.compat.artemislib.SizeAttribute;
import xzeroair.trinkets.util.config.ConfigHelper;
import xzeroair.trinkets.util.handlers.SizeHandler;
import xzeroair.trinkets.util.helpers.ColorHelper;
import xzeroair.trinkets.util.helpers.RayTraceHelper;
import xzeroair.trinkets.util.helpers.StringUtils;

public abstract class EntityRacePropertiesHandler
implements IRaceHandler {
    protected boolean firstUpdate;
    protected boolean firstTransformUpdate;
    protected EntityLivingBase entity;
    protected int targetWidth = 100;
    protected int targetHeight = 100;
    protected EntityRace race;
    protected boolean showTraits;
    protected String traitColor;
    protected String traitColorAlt;
    protected int traitVariant;
    protected EntityProperties properties;
    protected float healthBeforeTransformation;
    protected float maxHealthBeforeTranformation;
    protected double progress = 0.0;
    protected float cooldown = 0.0f;

    public EntityRacePropertiesHandler(EntityLivingBase e, EntityRace race) {
        this.entity = e;
        this.firstUpdate = true;
        this.firstTransformUpdate = true;
        this.showTraits = true;
        this.race = race;
        this.traitColor = ColorHelper.convertDecimalColorToHexadecimal(race.getPrimaryColor());
        this.traitColorAlt = ColorHelper.convertDecimalColorToHexadecimal(race.getSecondaryColor());
        this.traitVariant = 0;
        this.setTargetHeight(race.getRaceHeight());
        this.setTargetWidth(race.getRaceWidth());
    }

    protected void initAttributes() {
        double d = Double.parseDouble(Reference.DECIMALFORMAT.format(this.TransformationProgress()));
        if (d != 0.0) {
            World world = this.entity.func_130014_f_();
            String[] raceAttributes = this.race.getRaceAttributes().getAttributes();
            if (raceAttributes.length > 0) {
                for (String entry : raceAttributes) {
                    ConfigHelper.AttributeEntry attributeShell = ConfigHelper.getAttributeEntry(entry);
                    if (attributeShell == null) continue;
                    String name = attributeShell.getAttribute();
                    double amount = attributeShell.getAmount();
                    int operation = attributeShell.getOperation();
                    boolean isSaved = attributeShell.isSaved();
                    UpdatingAttribute attribute = new UpdatingAttribute(this.race.getName() + "." + name, this.race.getUUID(), name).setSavedInNBT(true);
                    attribute.addModifier(this.entity, amount * d, operation);
                }
            }
        }
    }

    public EntityRacePropertiesHandler setEntityProperties(EntityProperties properties) {
        this.properties = properties;
        return this;
    }

    public EntityRacePropertiesHandler setFirstUpdate(boolean firstUpdate) {
        this.firstUpdate = firstUpdate;
        return this;
    }

    public EntityRace getRace() {
        return this.race;
    }

    public void addAbility(IAbilityInterface ability) {
        if (this.properties != null) {
            this.properties.getAbilityHandler().registerRaceAbility(this.getRace().getRegistryName().toString(), ability);
        }
    }

    @Nullable
    public IAbilityInterface getAbility(String ability) {
        if (this.properties != null) {
            return this.properties.getAbilityHandler().getAbility(ability);
        }
        return null;
    }

    public void removeAbility(String ability) {
        if (this.properties != null) {
            this.properties.getAbilityHandler().removeAbility(ability);
        }
    }

    public void onTransform() {
        this.firstTransformUpdate = true;
        this.healthBeforeTransformation = this.entity.func_110143_aJ();
        this.maxHealthBeforeTranformation = this.entity.func_110138_aP();
        if (this.properties == null) {
            this.properties = Capabilities.getEntityProperties((Entity)this.entity);
        }
        this.startTransformation();
        try {
            this.loadNBTData(this.properties.getTag());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void onTransformEnd() {
        this.endTransformation();
        SizeAttribute artemis = this.getArtemisAttributeSize();
        if (artemis != null) {
            artemis.removeModifiers();
        }
        try {
            this.savedNBTData(this.properties.getTag());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void onTick() {
        this.updateSize();
        SizeHandler.setSize(this.entity, this.getHeight(), this.getWidth());
        this.initAttributes();
        this.eyeHeightHandler();
        if (this.isTransformed()) {
            SizeAttribute artemis = this.getArtemisAttributeSize();
            if (artemis != null) {
                artemis.addModifiers();
            }
            this.whileTransformed();
            this.firstTransformUpdate = false;
        }
        this.cooldown = this.cooldown > 0.0f ? (this.cooldown -= 1.0f) : 0.0f;
    }

    @Override
    public void interact(PlayerInteractEvent event) {
        if (TrinketsConfig.SERVER.misc.reach) {
            EntityPlayer player = event.getEntityPlayer();
            boolean isClient = player.field_70170_p.field_72995_K;
            if (isClient) {
                RayTraceResult result;
                if (this.cooldown != 0.0f) {
                    return;
                }
                KeyBinding lClick = Minecraft.func_71410_x().field_71474_y.field_74312_F;
                KeyBinding rClick = Minecraft.func_71410_x().field_71474_y.field_74313_G;
                IAttributeInstance reach = player.func_110140_aT().func_111151_a(EntityPlayer.REACH_DISTANCE);
                if (reach.func_111126_e() > 5.0 && (result = RayTraceHelper.rayTrace((EntityLivingBase)player, reach.func_111126_e() * 0.8)) != null && result.field_72313_a == RayTraceResult.Type.ENTITY) {
                    Entity entity = result.field_72308_g;
                    Vec3d vec = result.field_72307_f;
                    if (lClick.func_151470_d()) {
                        NetworkHandler.sendToServer(new IncreasedReachPacket((EntityLivingBase)player, EnumHand.MAIN_HAND, entity, vec.field_72450_a, vec.field_72448_b, vec.field_72449_c));
                        this.cooldown = player.func_184818_cX();
                        Trinkets.proxy.renderEffect(3, player.func_130014_f_(), result.field_72307_f.field_72450_a, result.field_72307_f.field_72448_b + (double)(entity.field_70131_O * 0.5f), result.field_72307_f.field_72449_c, 0.0, 0.0, 0.0, 0, 1.0f, 1.0f);
                    } else if (rClick.func_151470_d()) {
                        NetworkHandler.sendToServer(new IncreasedReachPacket((EntityLivingBase)player, EnumHand.OFF_HAND, entity, vec.field_72450_a, vec.field_72448_b, vec.field_72449_c));
                    }
                }
            }
        }
    }

    public boolean isTransforming() {
        return this.properties.getHeightValue() != this.getTargetHeight() || this.properties.getWidthValue() != this.getTargetWidth();
    }

    public boolean isTransformed() {
        return this.properties.getHeightValue() == this.getTargetHeight() && this.properties.getWidthValue() == this.getTargetWidth();
    }

    public double TransformationProgress() {
        if (!this.isTransformed() && !this.isTransforming()) {
            return 1.0;
        }
        return this.progress;
    }

    protected void updateSize() {
        if (!this.isTransformed() && this.isTransforming() || this.TransformationProgress() < 1.0) {
            float heal;
            double finalValue;
            int height = this.properties.getHeightValue();
            int width = this.properties.getWidthValue();
            BiFunction<Integer, Integer, Integer> increment = (x, y) -> {
                if (x < y) {
                    return x + 1;
                }
                if (x > y) {
                    return x - 1;
                }
                return x;
            };
            int h = increment.apply(height, this.getTargetHeight());
            this.properties.setHeightValue(h);
            int w = increment.apply(width, this.getTargetWidth());
            this.properties.setWidthValue(w);
            int previousRaceTargetHeight = this.properties.getPreviousRace().getRaceHeight();
            int previousRaceTargetWidth = this.properties.getPreviousRace().getRaceWidth();
            double heightProgress = this.transformProgress(previousRaceTargetHeight, this.getTargetHeight(), height);
            double widthProgress = this.transformProgress(previousRaceTargetWidth, this.getTargetWidth(), width);
            double d = finalValue = this.isTransformed() ? 1.0 : StringUtils.getAccurateDouble(heightProgress * widthProgress);
            if (finalValue >= 0.0 && finalValue <= 1.0 && this.progress != finalValue) {
                this.progress = finalValue;
            }
            if (this.TransformationProgress() >= 1.0 && (heal = (float)StringUtils.getAccurateDouble(this.entity.func_110138_aP() - this.maxHealthBeforeTranformation - (this.maxHealthBeforeTranformation - this.healthBeforeTransformation))) > 0.0f) {
                this.entity.func_70691_i(heal);
            }
        }
    }

    protected double transformProgress(int previousTarget, int currentTarget, int currentValue) {
        double rtn = MathHelper.func_181160_c((double)((double)currentValue + 0.0), (double)((double)previousTarget + 0.0), (double)((double)currentTarget + 0.0));
        if (rtn < 0.01) {
            return 0.0;
        }
        if (rtn > 1.0) {
            return 1.0;
        }
        return rtn;
    }

    protected void eyeHeightHandler() {
        if (this.entity instanceof EntityPlayer) {
            if (!TrinketsConfig.CLIENT.cameraHeight) {
                return;
            }
            EntityPlayer player = (EntityPlayer)this.entity;
            float defaultEyeHeight = player.getDefaultEyeHeight();
            if (this.isTransforming() || this.isTransformed()) {
                Entity mount;
                float f = (float)StringUtils.getAccurateDouble(this.getHeight() * 0.85f);
                if (player.func_70608_bn()) {
                    f = 0.2f;
                } else if (!player.func_70093_af()) {
                    if (player.func_184613_cA()) {
                        f *= 0.2f;
                    }
                } else {
                    f -= f / 20.0f;
                }
                if (player.func_184218_aH() && (mount = player.func_184187_bx()) != null) {
                    float mountHeight = mount.field_70131_O;
                    double mountOffset = mount.func_70042_X();
                    double t = (double)mountHeight - mountOffset;
                    f = MathHelper.func_76131_a((float)f, (float)mountHeight, (float)f);
                }
                player.eyeHeight = f;
            } else if (player.eyeHeight != defaultEyeHeight) {
                player.eyeHeight = defaultEyeHeight;
            }
        }
    }

    public int getTargetHeight() {
        return this.targetHeight;
    }

    public void setTargetHeight(int targetHeight) {
        this.targetHeight = targetHeight;
    }

    public int getTargetWidth() {
        return this.targetWidth;
    }

    public void setTargetWidth(int targetWidth) {
        this.targetWidth = targetWidth;
    }

    public float getHeight() {
        float TLHeight = (float)((double)this.properties.getDefaultHeight() * ((double)this.properties.getHeightValue() * 0.01));
        return TLHeight;
    }

    public float getWidth() {
        float TLWidth = (float)((double)this.properties.getDefaultWidth() * ((double)this.properties.getWidthValue() * 0.01));
        return TLWidth;
    }

    private SizeAttribute getArtemisAttributeSize() {
        if (Trinkets.ArtemisLib && TrinketsConfig.compat.artemislib) {
            double h = (double)(this.getTargetHeight() - 100) * 0.01;
            double w = (double)(this.getTargetWidth() - 100) * 0.01;
            return new SizeAttribute(this.entity, h, w, 0);
        }
        return null;
    }

    public void copyFrom(EntityRacePropertiesHandler source, boolean wasDeath, boolean keepInv) {
        if (this.race == source.race) {
            boolean isNormal;
            boolean bl = isNormal = this.race == null ? true : this.race.equals(EntityRaces.none);
            if (wasDeath && keepInv && isNormal) {
                return;
            }
            this.progress = source.progress;
            this.showTraits = source.showTraits;
            this.traitColor = source.traitColor;
            this.traitColorAlt = source.traitColorAlt;
            this.traitVariant = source.traitVariant;
            this.targetHeight = source.targetHeight;
            this.targetWidth = source.targetWidth;
        }
    }

    public boolean isCreativePlayer() {
        boolean flag = this.entity instanceof EntityPlayer && (((EntityPlayer)this.entity).func_184812_l_() || ((EntityPlayer)this.entity).func_175149_v());
        return flag;
    }

    public boolean canFly() {
        return this.race == null ? false : this.race.canFly();
    }

    @Override
    public NBTTagCompound savedNBTData(NBTTagCompound compound) {
        if (this.race != null && !this.race.isNone()) {
            String key = this.race.getRegistryName().toString();
            if (!compound.func_74764_b(key)) {
                compound.func_74782_a(key, (NBTBase)new NBTTagCompound());
            }
            NBTTagCompound rTag = compound.func_74775_l(key);
            rTag.func_74757_a("trait_shown", this.showTraits);
            rTag.func_74778_a("trait_color", this.traitColor);
            rTag.func_74778_a("trait_color_alt", this.traitColorAlt);
            rTag.func_74768_a("trait_variant", this.traitVariant);
            rTag.func_74780_a("transformation_progress", this.progress);
        }
        return compound;
    }

    @Override
    public void loadNBTData(NBTTagCompound compound) {
        String key;
        if (this.race != null && !this.race.isNone() && compound.func_74764_b(key = this.race.getRegistryName().toString())) {
            NBTTagCompound rTag = compound.func_74775_l(key);
            if (rTag.func_74764_b("trait_shown")) {
                this.showTraits = rTag.func_74767_n("trait_shown");
            }
            if (rTag.func_74764_b("trait_color")) {
                this.traitColor = rTag.func_74779_i("trait_color");
            }
            if (rTag.func_74764_b("trait_color_alt")) {
                this.traitColorAlt = rTag.func_74779_i("trait_color_alt");
            }
            if (rTag.func_74764_b("trait_variant")) {
                this.traitVariant = rTag.func_74762_e("trait_variant");
            }
            if (rTag.func_74764_b("transformation_progress")) {
                this.progress = rTag.func_74769_h("transformation_progress");
            }
        }
    }

    public boolean showTraits() {
        return this.showTraits;
    }

    public void setShowTraits(boolean showTraits) {
        this.showTraits = showTraits;
    }

    public String getTraitColor() {
        return this.traitColor;
    }

    public void setTraitColor(String color) {
        this.traitColor = color;
    }

    public String getAltTraitColor() {
        return this.traitColorAlt;
    }

    public void setAltTraitColor(String color) {
        this.traitColorAlt = color;
    }

    public int getTraitVariant() {
        return this.traitVariant;
    }

    public void setTraitVariant(int variant) {
        this.traitVariant = variant;
    }

    @Override
    public void doRenderPlayerPre(EntityPlayer entity, double x, double y, double z, RenderPlayer renderer, float partialTick) {
        GuiScreen screen = Minecraft.func_71410_x().field_71462_r;
        if (!(entity != Minecraft.func_71410_x().field_71439_g || screen == null || screen instanceof GuiChat || screen instanceof GuiEntityProperties || screen instanceof ManaHud)) {
            return;
        }
        if ((this.isTransforming() || this.isTransformed()) && !this.properties.isNormalSize()) {
            double hScale = (double)this.properties.getHeightValue() * 0.01;
            double wScale = (double)this.properties.getWidthValue() * 0.01;
            double xLoc = x / wScale - x;
            double yLoc = y / hScale - y;
            double zLoc = z / wScale - z;
            double yOffset = entity.func_70033_W();
            Entity mount = entity.func_184187_bx();
            double mountedOffset = entity.func_184218_aH() && mount != null ? mount.func_70042_X() : 0.0;
            double retMountedOffset = -(mountedOffset + yOffset) - 0.1;
            if (entity.func_184218_aH()) {
                GlStateManager.func_179137_b((double)0.0, (double)mountedOffset, (double)0.0);
                GlStateManager.func_179137_b((double)0.0, (double)(-yOffset), (double)0.0);
                GlStateManager.func_179137_b((double)0.0, (double)retMountedOffset, (double)0.0);
            }
            GlStateManager.func_179139_a((double)wScale, (double)hScale, (double)wScale);
            if (entity.func_184218_aH()) {
                GlStateManager.func_179137_b((double)0.0, (double)(-retMountedOffset), (double)0.0);
                GlStateManager.func_179137_b((double)0.0, (double)yOffset, (double)0.0);
                GlStateManager.func_179137_b((double)0.0, (double)(-mountedOffset), (double)0.0);
            }
            GlStateManager.func_179137_b((double)xLoc, (double)yLoc, (double)zLoc);
        }
    }

    @Override
    public void doRenderPlayerPost(EntityPlayer entity, double x, double y, double z, RenderPlayer renderer, float partialTick) {
    }

    @Override
    public <T extends EntityLivingBase> void doRenderLivingSpecialsPre(EntityLivingBase entity, double x, double y, double z, RenderLivingBase<T> renderer, float partialTick) {
        if (entity instanceof EntityPlayer && (this.isTransforming() || this.isTransformed()) && !this.properties.isNormalSize()) {
            GlStateManager.func_179094_E();
            float t2 = this.properties.getDefaultHeight() - entity.field_70131_O;
            GlStateManager.func_179109_b((float)0.0f, (float)t2, (float)0.0f);
        }
    }

    @Override
    public <T extends EntityLivingBase> void doRenderLivingSpecialsPost(EntityLivingBase entity, double x, double y, double z, RenderLivingBase<T> renderer, float partialTick) {
        if (entity instanceof EntityPlayer && (this.isTransforming() || this.isTransformed()) && !this.properties.isNormalSize()) {
            GlStateManager.func_179121_F();
        }
    }

    @Override
    public <T extends EntityLivingBase> void doRenderLivingPre(EntityLivingBase entity, double x, double y, double z, RenderLivingBase<T> renderer, float partialTick) {
        if ((this.isTransforming() || this.isTransformed()) && !this.properties.isNormalSize()) {
            GlStateManager.func_179094_E();
            double hScale = (double)this.properties.getHeightValue() * 0.01;
            double wScale = (double)this.properties.getWidthValue() * 0.01;
            double xLoc = x / wScale - x;
            double yLoc = y / hScale - y;
            double zLoc = z / wScale - z;
            double yOffset = entity.func_70033_W();
            Entity mount = entity.func_184187_bx();
            double mountedOffset = entity.func_184218_aH() && mount != null ? mount.func_70042_X() : 0.0;
            double retMountedOffset = -(mountedOffset + yOffset) - 0.1;
            if (entity.func_184218_aH()) {
                GlStateManager.func_179137_b((double)0.0, (double)mountedOffset, (double)0.0);
                GlStateManager.func_179137_b((double)0.0, (double)(-yOffset), (double)0.0);
                GlStateManager.func_179137_b((double)0.0, (double)retMountedOffset, (double)0.0);
            }
            GlStateManager.func_179139_a((double)wScale, (double)hScale, (double)wScale);
            if (entity.func_184218_aH()) {
                GlStateManager.func_179137_b((double)0.0, (double)(-retMountedOffset), (double)0.0);
                GlStateManager.func_179137_b((double)0.0, (double)yOffset, (double)0.0);
                GlStateManager.func_179137_b((double)0.0, (double)(-mountedOffset), (double)0.0);
            }
            GlStateManager.func_179137_b((double)xLoc, (double)yLoc, (double)zLoc);
        }
    }

    @Override
    public <T extends EntityLivingBase> void doRenderLivingPost(EntityLivingBase entity, double x, double y, double z, RenderLivingBase<T> renderer, float partialTick) {
        if ((this.isTransforming() || this.isTransformed()) && !this.properties.isNormalSize()) {
            GlStateManager.func_179121_F();
        }
    }
}

