/*
 * Decompiled with CFR 0.152.
 */
package xzeroair.trinkets.proxy;

import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.util.IThreadListener;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.network.IGuiHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.fml.relauncher.Side;
import xzeroair.trinkets.container.TrinketInventoryContainer;
import xzeroair.trinkets.util.compat.OreDictionaryCompat;
import xzeroair.trinkets.util.registry.EventRegistry;

@Mod.EventBusSubscriber
public class CommonProxy
implements IGuiHandler {
    public Side getSide() {
        return Side.SERVER;
    }

    public void preInit(FMLPreInitializationEvent e) {
        EventRegistry.preInit();
        EventRegistry.modCompatPreInit();
    }

    public void init(FMLInitializationEvent e) {
        OreDictionaryCompat.registerOres();
        EventRegistry.serverInit();
        EventRegistry.init();
        EventRegistry.modCompatInit();
    }

    public void postInit(FMLPostInitializationEvent e) {
        EventRegistry.postInit();
        EventRegistry.modCompatPostInit();
    }

    public void renderEffect(int effectID, World world, double x, double y, double z, double x2, double y2, double z2, int color, float alpha, float intensity) {
    }

    public void registerItemRenderer(Item item, int meta, String id) {
    }

    public IThreadListener getThreadListener(MessageContext context) {
        if (context.side.isServer()) {
            return context.getServerHandler().field_147369_b.func_71121_q();
        }
        throw new WrongSideException("Tried to get the IThreadListener from a client-side MessageContext on the dedicated server");
    }

    public EntityPlayer getPlayer(MessageContext context) {
        if (context.side.isServer()) {
            return context.getServerHandler().field_147369_b;
        }
        throw new WrongSideException("Tried to get the player from a client-side MessageContext on the dedicated server");
    }

    @Nullable
    public EntityLivingBase getEntityLivingBase(MessageContext context, int entityID) {
        if (context.side.isServer()) {
            Entity entity = context.getServerHandler().field_147369_b.field_70170_p.func_73045_a(entityID);
            return entity instanceof EntityLivingBase ? (EntityLivingBase)entity : null;
        }
        throw new WrongSideException("Tried to get the player from a client-side MessageContext on the dedicated server");
    }

    public Object getClientGuiElement(int ID, EntityPlayer player, World world, int x, int y, int z) {
        return null;
    }

    public Object getServerGuiElement(int ID, EntityPlayer player, World world, int x, int y, int z) {
        if (world instanceof WorldServer) {
            switch (ID) {
                case 0: {
                    return new TrinketInventoryContainer(player.field_71071_by, !world.field_72995_K, player);
                }
            }
            return null;
        }
        return null;
    }

    public void spawnParticle(int effectID, World world, double x, double y, double z, double motX, double motY, double motZ, int color, float alpha) {
    }

    class WrongSideException
    extends RuntimeException {
        public WrongSideException(String message) {
            super(message);
        }

        public WrongSideException(String message, Throwable cause) {
            super(message, cause);
        }
    }
}

