/*
 * Decompiled with CFR 0.152.
 */
package xzeroair.trinkets.items.trinkets;

import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.client.renderer.block.model.ModelBakery;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.renderer.entity.RenderPlayer;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.Potion;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.World;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import xzeroair.trinkets.Trinkets;
import xzeroair.trinkets.capabilities.Capabilities;
import xzeroair.trinkets.items.base.AccessoryBase;
import xzeroair.trinkets.traits.abilities.AbilityResistance;
import xzeroair.trinkets.traits.abilities.compat.firstaid.AbilityIgnoreHeadshot;
import xzeroair.trinkets.traits.abilities.interfaces.IAbilityInterface;
import xzeroair.trinkets.util.TrinketsConfig;
import xzeroair.trinkets.util.config.ClientConfig;
import xzeroair.trinkets.util.config.trinkets.ConfigDamageShield;
import xzeroair.trinkets.util.helpers.TranslationHelper;

public class TrinketDamageShield
extends AccessoryBase {
    public static final ConfigDamageShield serverConfig = TrinketsConfig.SERVER.Items.DAMAGE_SHIELD;
    public static final ClientConfig.ClientConfigItems.ClientConfigDamageShield clientConfig = TrinketsConfig.CLIENT.items.DAMAGE_SHIELD;

    public TrinketDamageShield(String name) {
        super(name);
        this.setUUID("c0885371-20dd-4c56-86eb-78f24d9fe777");
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    protected String customItemInformation(ItemStack stack, World world, ITooltipFlag flagIn, int index, String translation) {
        TranslationHelper helper = TranslationHelper.INSTANCE;
        TranslationHelper.LangEntry key = new TranslationHelper.LangEntry(this.func_77667_c(stack), "explosionresist", TrinketDamageShield.serverConfig.explosion_resist);
        TranslationHelper.OptionEntry key1 = new TranslationHelper.OptionEntry("explosionresistamount", TrinketDamageShield.serverConfig.explosion_resist, 100.0f - TrinketDamageShield.serverConfig.explosion_amount * 100.0f + "%");
        TranslationHelper.LangEntry key2 = new TranslationHelper.LangEntry(this.func_77667_c(stack), "damageignored", TrinketDamageShield.serverConfig.damage_ignore);
        String hits = "0";
        try {
            EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
            IAbilityInterface ability = Capabilities.getEntityProperties((Entity)player, null, (prop, a) -> prop.getAbilityHandler().getAbility("xat:safe_guard"));
            if (ability instanceof AbilityResistance) {
                AbilityResistance safeGuard = (AbilityResistance)ability;
                hits = safeGuard.getHitCount() + "";
            }
        }
        catch (Exception e) {
            hits = "ERROR";
        }
        TranslationHelper.OptionEntry key3 = new TranslationHelper.OptionEntry("damageignoredhitcount", TrinketDamageShield.serverConfig.damage_ignore, hits);
        TranslationHelper.OptionEntry key4 = new TranslationHelper.OptionEntry("cfghitcount", TrinketDamageShield.serverConfig.damage_ignore, TrinketDamageShield.serverConfig.hits);
        String effect = "ERROR";
        try {
            Potion peffect = Potion.func_180142_b((String)TrinketDamageShield.serverConfig.potionEffect);
            if (peffect != null) {
                effect = new TextComponentTranslation(peffect.func_76393_a(), new Object[0]).func_150260_c();
            }
        }
        catch (Exception peffect) {
            // empty catch block
        }
        TranslationHelper.OptionEntry key5 = new TranslationHelper.OptionEntry("soheffect", true, effect);
        TranslationHelper.LangEntry FirstAid = new TranslationHelper.LangEntry(this.func_77667_c(stack), "headshots", TrinketDamageShield.serverConfig.compat.firstaid.chance_ignore);
        TranslationHelper.OptionEntry key6 = new TranslationHelper.OptionEntry("headshotchance", TrinketDamageShield.serverConfig.compat.firstaid.chance_ignore, MathHelper.func_76131_a((float)(1.0f / (float)TrinketDamageShield.serverConfig.compat.firstaid.chance_headshots * 100.0f), (float)-2.1474836E9f, (float)2.1474836E9f) + "%");
        return helper.formatAddVariables(translation, key, key1, key2, key3, key4, FirstAid, key5, key6);
    }

    @Override
    public String[] getAttributeConfig() {
        return TrinketDamageShield.serverConfig.attributes;
    }

    @Override
    public void initAbilities(ItemStack stack, EntityLivingBase entity, List<IAbilityInterface> abilities) {
        abilities.add(new AbilityResistance());
        if (Trinkets.FirstAid && TrinketDamageShield.serverConfig.compat.firstaid.chance_ignore) {
            abilities.add(new AbilityIgnoreHeadshot());
        }
    }

    @Override
    public void func_77663_a(ItemStack stack, World world, Entity entity, int itemSlot, boolean isSelected) {
        super.func_77663_a(stack, world, entity, itemSlot, isSelected);
        Capabilities.getTrinketProperties(stack, prop -> prop.setVariant(0));
    }

    @Override
    public void eventPlayerTick(ItemStack stack, EntityPlayer player) {
        super.eventPlayerTick(stack, player);
        if (TrinketsConfig.SERVER.misc.retrieveVIP) {
            Capabilities.getVipStatus((Entity)player, status -> Capabilities.getTrinketProperties(stack, prop -> prop.setVariant(status.getStatus())));
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void registerModels() {
        ModelResourceLocation normal = new ModelResourceLocation(this.getRegistryName().toString(), "inventory");
        ModelResourceLocation bro = new ModelResourceLocation(this.getRegistryName().toString() + "_bro", "inventory");
        ModelResourceLocation panda = new ModelResourceLocation(this.getRegistryName().toString() + "_panda", "inventory");
        ModelResourceLocation vip = new ModelResourceLocation(this.getRegistryName().toString() + "_vip", "inventory");
        ModelResourceLocation artsy = new ModelResourceLocation(this.getRegistryName().toString() + "_artsy", "inventory");
        ModelResourceLocation twilight = new ModelResourceLocation(this.getRegistryName().toString() + "_twilight", "inventory");
        ModelBakery.registerItemVariants((Item)this, (ResourceLocation[])new ResourceLocation[]{normal, bro, panda, vip, artsy, twilight});
        ModelLoader.setCustomMeshDefinition((Item)this, stack -> {
            int variant = Capabilities.getTrinketProperties(stack, 0, (prop, var) -> prop.getVariant());
            switch (variant) {
                case 0: {
                    return normal;
                }
                case 1: {
                    return vip;
                }
                case 2: {
                    return bro;
                }
                case 3: {
                    return panda;
                }
                case 4: {
                    return artsy;
                }
                case 5: {
                    return twilight;
                }
            }
            return vip;
        });
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void playerRenderLayer(ItemStack stack, EntityLivingBase player, RenderPlayer renderer, boolean isSlim, float partialTicks, float scale) {
        if (!TrinketDamageShield.clientConfig.doRender) {
            return;
        }
        float offsetX = 0.17f;
        float offsetY = 0.22f;
        float offsetZ = 0.16f;
        GlStateManager.func_179094_E();
        if (player.func_70093_af()) {
            GlStateManager.func_179109_b((float)0.0f, (float)0.2f, (float)0.0f);
        }
        renderer.func_177087_b().field_78115_e.func_78794_c(scale);
        GlStateManager.func_179114_b((float)180.0f, (float)1.0f, (float)0.0f, (float)0.0f);
        GlStateManager.func_179109_b((float)0.17f, (float)-0.22f, (float)0.16f);
        if (player.func_190630_a(EntityEquipmentSlot.CHEST)) {
            GlStateManager.func_179109_b((float)0.030000001f, (float)0.0f, (float)0.040000007f);
        }
        float bS = 3.0f;
        GlStateManager.func_179152_a((float)(scale * 3.0f), (float)(scale * 3.0f), (float)(scale * 3.0f));
        Minecraft.func_71410_x().func_175599_af().func_181564_a(stack, ItemCameraTransforms.TransformType.NONE);
        GlStateManager.func_179121_F();
    }

    @Override
    public boolean ItemEnabled() {
        return TrinketDamageShield.serverConfig.enabled;
    }
}

