/*
 * Decompiled with CFR 0.152.
 */
package xzeroair.trinkets.items.base;

import java.util.List;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemFood;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import xzeroair.trinkets.Trinkets;
import xzeroair.trinkets.util.TrinketsConfig;
import xzeroair.trinkets.util.helpers.TranslationHelper;
import xzeroair.trinkets.util.interfaces.IsModelLoaded;

public class FoodBase
extends ItemFood
implements IsModelLoaded {
    private UUID uuid;
    protected int cooldown = 0;
    protected boolean canEat = true;

    public FoodBase(String name, int heal, float saturation) {
        super(heal, saturation, false);
        this.func_77655_b(name);
        this.setRegistryName(name);
        this.func_77637_a(Trinkets.trinketstab);
    }

    @SideOnly(value=Side.CLIENT)
    protected String customItemInformation(ItemStack stack, World world, ITooltipFlag flagIn, int index, String translation) {
        TranslationHelper helper = TranslationHelper.INSTANCE;
        return helper.formatAddVariables(translation, new TranslationHelper.KeyEntry[0]);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World world, List<String> tooltips, ITooltipFlag flagIn) {
        String EV;
        super.func_77624_a(stack, world, tooltips, flagIn);
        if (world == null) {
            return;
        }
        TranslationHelper helper = TranslationHelper.INSTANCE;
        for (int i = 1; i < 10; ++i) {
            int index = i;
            String string = helper.getLangTranslation(stack.func_77977_a() + ".tooltip" + i, lang -> this.customItemInformation(stack, world, flagIn, index, (String)lang));
            if (helper.isStringEmpty(string)) continue;
            tooltips.add(string);
        }
        TextComponentTranslation ctrl = new TextComponentTranslation("xat.holdctrl", new Object[0]);
        boolean tanEnabled = Trinkets.ToughAsNails && TrinketsConfig.compat.toughasnails;
        boolean faEnabled = Trinkets.FirstAid;
        boolean evEnabled = Trinkets.EnhancedVisuals && TrinketsConfig.compat.enhancedvisuals;
        String TAN = !tanEnabled ? "" : helper.getLangTranslation(stack.func_77977_a() + ".compat.tan", lang -> this.customItemInformation(stack, world, flagIn, 11, (String)lang));
        String FA = !faEnabled ? "" : helper.getLangTranslation(stack.func_77977_a() + ".compat.firstaid", lang -> this.customItemInformation(stack, world, flagIn, 12, (String)lang));
        String string = EV = !evEnabled ? "" : helper.getLangTranslation(stack.func_77977_a() + ".compat.enhancedvisuals", lang -> this.customItemInformation(stack, world, flagIn, 13, (String)lang));
        if (GuiScreen.func_146271_m()) {
            if (!helper.isStringEmpty(TAN)) {
                tooltips.add(TAN + helper.gold + " (Tough as Nails)");
            }
            if (!helper.isStringEmpty(FA)) {
                tooltips.add(FA + helper.gold + " (First Aid)");
            }
            if (!helper.isStringEmpty(EV)) {
                tooltips.add(EV + helper.gold + " (Enhanced Visuals)");
            }
        } else if (!(helper.isStringEmpty(TAN) && helper.isStringEmpty(EV) && helper.isStringEmpty(FA))) {
            tooltips.add(helper.reset + "" + helper.dGray + ctrl.func_150254_d());
        }
    }

    public String func_77653_i(ItemStack stack) {
        return super.func_77653_i(stack);
    }

    public UUID getUUID() {
        return this.uuid;
    }

    public void setUUID(String uuid) {
        this.uuid = !uuid.isEmpty() ? UUID.fromString(uuid) : UUID.randomUUID();
    }

    public void func_77663_a(ItemStack stack, World worldIn, Entity entityIn, int itemSlot, boolean isSelected) {
        if (this.cooldown > 0) {
            this.canEat = false;
            --this.cooldown;
        } else {
            this.canEat = true;
        }
        super.func_77663_a(stack, worldIn, entityIn, itemSlot, isSelected);
    }

    public ActionResult<ItemStack> func_77659_a(World worldIn, EntityPlayer playerIn, EnumHand handIn) {
        return super.func_77659_a(worldIn, playerIn, handIn);
    }

    public ItemStack func_77654_b(ItemStack stack, World worldIn, EntityLivingBase entityLiving) {
        return super.func_77654_b(stack, worldIn, entityLiving);
    }

    public void func_77622_d(ItemStack stack, World world, EntityPlayer player) {
        super.func_77622_d(stack, world, player);
    }

    public int getCooldown() {
        return this.cooldown;
    }

    public void setCooldown(int cooldown) {
        this.cooldown = cooldown;
    }

    public boolean getEdible() {
        return this.canEat;
    }

    @Override
    public void registerModels() {
        Trinkets.proxy.registerItemRenderer((Item)this, 0, "inventory");
    }
}

