/*
 * Decompiled with CFR 0.152.
 */
package xzeroair.trinkets.items.base;

import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.MobEffects;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import xzeroair.trinkets.capabilities.Capabilities;
import xzeroair.trinkets.util.TrinketsConfig;
import xzeroair.trinkets.util.compat.SurvivalCompat;
import xzeroair.trinkets.util.helpers.MagicHelper;

public class BasePotion
extends Potion {
    protected final ResourceLocation ICON;
    protected String field_76416_I;
    protected int maxDuration;
    protected int indexX;
    protected int indexY;

    public BasePotion(String name, int color, int duration, boolean isBadEffect) {
        this("xat", name, color, duration, isBadEffect);
    }

    public BasePotion(String modid, String name, int color, int duration, boolean isBadEffect) {
        this(modid, name, color, duration, isBadEffect, -1, -1, new ResourceLocation(modid, "textures/potions/" + name + ".png"));
    }

    public BasePotion(String modid, String name, int color, int duration, boolean isBadEffect, int IconX, int IconY, ResourceLocation texture) {
        super(isBadEffect, color);
        this.indexX = IconX;
        this.indexY = IconY;
        this.field_76416_I = name;
        this.ICON = texture;
        this.maxDuration = duration;
        this.func_76390_b(modid + ".effect." + name);
        this.setRegistryName(new ResourceLocation(modid, name));
    }

    @SideOnly(value=Side.CLIENT)
    public void renderInventoryEffect(PotionEffect effect, Gui gui, int x, int y, float z) {
        this.renderInventoryEffect(x, y, effect, Minecraft.func_71410_x());
    }

    @SideOnly(value=Side.CLIENT)
    public void renderInventoryEffect(int x, int y, PotionEffect effect, Minecraft mc) {
        if (this.getTexture() == null) {
            return;
        }
        mc.func_110434_K().func_110577_a(this.getTexture());
        if (this.indexX >= 0 && this.indexY >= 0) {
            int i1 = (this.indexX + this.indexY) * 8;
            Gui.func_146110_a((int)(x + 6), (int)(y + 7), (float)(0 + i1 % 8 * 18), (float)(198 + i1 / 8 * 18), (int)18, (int)18, (float)256.0f, (float)256.0f);
        } else {
            Gui.func_146110_a((int)(x + 6), (int)(y + 7), (float)0.0f, (float)0.0f, (int)18, (int)18, (float)18.0f, (float)18.0f);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void renderHUDEffect(PotionEffect effect, Gui gui, int x, int y, float z, float alpha) {
        this.renderHUDEffect(x, y, effect, Minecraft.func_71410_x(), alpha);
    }

    @SideOnly(value=Side.CLIENT)
    public void renderHUDEffect(int x, int y, PotionEffect effect, Minecraft mc, float alpha) {
        if (this.getTexture() == null) {
            return;
        }
        mc.func_110434_K().func_110577_a(this.getTexture());
        if (this.indexX >= 0 && this.indexY >= 0) {
            int i1 = (this.indexX + this.indexY) * 8;
            Gui.func_146110_a((int)(x + 3), (int)(y + 3), (float)(i1 % 8 * 18), (float)(198 + i1 / 8 * 18), (int)18, (int)18, (float)256.0f, (float)256.0f);
        } else {
            Gui.func_146110_a((int)(x + 3), (int)(y + 3), (float)0.0f, (float)0.0f, (int)18, (int)18, (float)18.0f, (float)18.0f);
        }
    }

    public boolean func_76397_a(int duration, int amplifier) {
        return duration <= 1;
    }

    public boolean func_76403_b() {
        return this.maxDuration <= 0;
    }

    public void func_180793_a(Entity source, Entity indirectSource, EntityLivingBase entity, int amplifier, double health) {
        Capabilities.getEntityProperties((Entity)entity, prop -> {
            if (this.field_76416_I.equals("restorative")) {
                prop.setImbuedRace(null);
                MagicHelper.refillMana((Entity)entity);
            } else if (this.field_76416_I.equals("glowing")) {
                MagicHelper.refillMana((Entity)entity);
            } else if (this.field_76416_I.equals("glittering")) {
                MagicHelper.refillManaByPrecentage((Entity)entity, 0.5f);
            } else {
                MagicHelper.refillManaByPrecentage((Entity)entity, 0.25f);
            }
        });
        float heals = 0.0f;
        int thirst = 0;
        int saturation = 0;
        if (this.field_76416_I.equals("restorative") || this.field_76416_I.equals("glowing")) {
            heals = entity.func_110138_aP();
            thirst = 20;
            saturation = 20;
        } else if (this.field_76416_I.equals("glittering")) {
            entity.func_70690_d(new PotionEffect(MobEffects.field_76444_x, 300, 0, false, false));
            heals = entity.func_110138_aP() * 0.5f;
            thirst = 10;
            saturation = 10;
        } else {
            heals = entity.func_110138_aP() * 0.25f;
            thirst = 5;
            saturation = 0;
        }
        if (heals > 0.0f) {
            entity.func_70691_i(heals);
        }
        if (TrinketsConfig.SERVER.Potion.potion_thirst && entity instanceof EntityPlayer) {
            SurvivalCompat.addThirst(entity, thirst, saturation);
            SurvivalCompat.clearThirst(entity);
        }
    }

    public ResourceLocation getTexture() {
        return this.ICON;
    }

    public boolean func_76400_d() {
        return this.ICON != null;
    }

    public boolean shouldRenderHUD(PotionEffect effect) {
        return this.func_76400_d();
    }

    public boolean shouldRender(PotionEffect effect) {
        return this.func_76400_d();
    }

    public boolean shouldRenderInvText(PotionEffect effect) {
        return this.func_76400_d();
    }
}

