/*
 * Decompiled with CFR 0.152.
 */
package xzeroair.trinkets.events;

import java.util.Map;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.ai.attributes.AbstractAttributeMap;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraftforge.event.entity.EntityEvent;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.PlayerEvent;
import xzeroair.trinkets.Trinkets;
import xzeroair.trinkets.attributes.JumpAttribute;
import xzeroair.trinkets.attributes.MagicAttributes;
import xzeroair.trinkets.attributes.RaceAttribute.RaceAttribute;
import xzeroair.trinkets.capabilities.Capabilities;
import xzeroair.trinkets.capabilities.race.EntityProperties;
import xzeroair.trinkets.network.NetworkHandler;
import xzeroair.trinkets.network.configsync.PacketConfigSync;
import xzeroair.trinkets.util.TrinketsConfig;

public class OnWorldJoinHandler {
    @SubscribeEvent
    public void attachAttributes(EntityEvent.EntityConstructing event) {
        if (event.getEntity() instanceof EntityLivingBase) {
            EntityLivingBase entity = (EntityLivingBase)event.getEntity();
            AbstractAttributeMap map = entity.func_110140_aT();
            map.func_111150_b(RaceAttribute.ENTITY_RACE);
            map.func_111150_b(JumpAttribute.Jump);
            map.func_111150_b(JumpAttribute.stepHeight);
            map.func_111150_b(MagicAttributes.MAX_MANA);
            map.func_111150_b(MagicAttributes.regen);
            map.func_111150_b(MagicAttributes.regenCooldown);
            map.func_111150_b(MagicAttributes.affinity);
        }
    }

    @SubscribeEvent
    public void onPlayerLogin(PlayerEvent.PlayerLoggedInEvent event) {
        EntityPlayer player = event.player;
        if (player instanceof EntityPlayerMP) {
            EntityPlayerMP playerMP = (EntityPlayerMP)event.player;
            Trinkets.log.info("Syncing Config to " + playerMP.func_70005_c_());
            Map<String, String> configMap = TrinketsConfig.writeConfigMap();
            NetworkHandler.sendTo(new PacketConfigSync(configMap), playerMP);
            Capabilities.getEntityProperties((Entity)playerMP, EntityProperties::onLogin);
            Capabilities.getMagicStats((Entity)playerMP, cap -> cap.sendManaToPlayer((EntityLivingBase)playerMP));
        }
    }

    @SubscribeEvent
    public void onPlayerLogout(PlayerEvent.PlayerLoggedOutEvent event) {
        EntityPlayer player = event.player;
        if (player instanceof EntityPlayerMP) {
            EntityPlayerMP playerMP = (EntityPlayerMP)event.player;
            Capabilities.getEntityProperties((Entity)playerMP, EntityProperties::onLogoff);
        }
    }

    @SubscribeEvent
    public void entityJoinWorld(EntityJoinWorldEvent event) {
        Entity entity = event.getEntity();
        if (entity instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)entity;
            if (TrinketsConfig.SERVER.misc.retrieveVIP) {
                Capabilities.getVipStatus((Entity)player, cap -> cap.sendStatusToPlayer(player));
            }
            Capabilities.getEntityProperties((Entity)player, cap -> cap.sendInformationToPlayer((EntityLivingBase)player));
            Capabilities.getMagicStats((Entity)player, cap -> cap.sendManaToPlayer((EntityLivingBase)player));
        } else {
            Capabilities.getEntityProperties(entity, prop -> prop.setLogin(true));
        }
    }

    @SubscribeEvent
    public void onPlayerChangedDimension(PlayerEvent.PlayerChangedDimensionEvent event) {
    }
}

