/*
 * Decompiled with CFR 0.152.
 */
package xzeroair.trinkets.events;

import baubles.api.cap.IBaublesItemHandler;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.living.LivingDamageEvent;
import net.minecraftforge.event.entity.living.LivingDropsEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.LivingExperienceDropEvent;
import net.minecraftforge.event.entity.living.LivingFallEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.living.LivingSetAttackTargetEvent;
import net.minecraftforge.event.entity.living.PotionEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.PlayerEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import xzeroair.trinkets.api.TrinketHelper;
import xzeroair.trinkets.capabilities.Capabilities;
import xzeroair.trinkets.network.NetworkHandler;
import xzeroair.trinkets.network.SyncItemDataPacket;
import xzeroair.trinkets.util.compat.baubles.BaublesHelper;
import xzeroair.trinkets.util.interfaces.IAccessoryInterface;

public class BaubleEventHandler {
    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public void clientTickEvent(TickEvent.ClientTickEvent event) {
        if (event.phase == TickEvent.Phase.END) {
            EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
            if (player == null || !player.func_70089_S() || player.field_70170_p == null) {
                return;
            }
            BaublesHelper.getBaublesHandler((EntityLivingBase)player, arg_0 -> BaubleEventHandler.lambda$clientTickEvent$0((EntityPlayer)player, arg_0));
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public void PlayerLoggedInEvent(PlayerEvent.PlayerLoggedInEvent event) {
        EntityPlayer player = event.player;
        World world = player.func_130014_f_();
        if (world != null) {
            boolean client = world.field_72995_K;
            BaublesHelper.getBaublesHandler((EntityLivingBase)player, handler -> {
                for (int i = 0; i < handler.getSlots(); ++i) {
                    ItemStack stack = handler.getStackInSlot(i);
                    boolean empty = stack.func_190926_b();
                    if (!client && world instanceof WorldServer) {
                        if (!empty) {
                            Capabilities.getTrinketProperties(stack, properties -> properties.itemEquipped(stack, (EntityLivingBase)player));
                        }
                        SyncItemDataPacket packet = new SyncItemDataPacket((EntityLivingBase)player, stack, stack.func_77978_p(), i, TrinketHelper.SlotInformation.ItemHandlerType.BAUBLES, true, !empty);
                        NetworkHandler.sendTo(packet, (EntityPlayerMP)player);
                    }
                    if (empty || !(stack.func_77973_b() instanceof IAccessoryInterface)) continue;
                    IAccessoryInterface item = (IAccessoryInterface)stack.func_77973_b();
                    item.eventPlayerLogin(stack, player);
                }
            });
        }
    }

    @SubscribeEvent
    public void EntityJoinWorld(EntityJoinWorldEvent event) {
    }

    @SubscribeEvent
    public void PlayerLoggedOutEvent(PlayerEvent.PlayerLoggedOutEvent event) {
        EntityPlayer player = event.player;
        BaublesHelper.getBaublesHandler((EntityLivingBase)player, handler -> {
            for (int i = 0; i < handler.getSlots(); ++i) {
                ItemStack stack = handler.getStackInSlot(i);
                boolean empty = stack.func_190926_b();
                if (empty || !(stack.func_77973_b() instanceof IAccessoryInterface)) continue;
                IAccessoryInterface item = (IAccessoryInterface)stack.func_77973_b();
                item.eventPlayerLogout(stack, player);
            }
        });
    }

    @SubscribeEvent
    public void playerStartTracking(PlayerEvent.StartTracking event) {
        EntityPlayer player = event.getEntityPlayer();
        Entity target = event.getTarget();
        World world = player.func_130014_f_();
        if (!world.field_72995_K && world instanceof WorldServer && target instanceof EntityPlayer) {
            EntityPlayer targetPlayer = (EntityPlayer)target;
            BaublesHelper.getBaublesHandler((EntityLivingBase)targetPlayer, handler -> {
                for (int i = 0; i < handler.getSlots(); ++i) {
                    ItemStack stack = handler.getStackInSlot(i);
                    boolean empty = stack.func_190926_b();
                    SyncItemDataPacket packet = new SyncItemDataPacket((EntityLivingBase)targetPlayer, stack, stack.func_77978_p(), i, TrinketHelper.SlotInformation.ItemHandlerType.BAUBLES, true, !empty);
                    NetworkHandler.sendTo(packet, (EntityPlayerMP)player);
                }
            });
        }
    }

    @SubscribeEvent
    public void PlayerChangedDimensionEvent(PlayerEvent.PlayerChangedDimensionEvent event) {
        EntityPlayer player = event.player;
        BaublesHelper.getBaublesHandler((EntityLivingBase)player, handler -> {
            for (int i = 0; i < handler.getSlots(); ++i) {
                ItemStack stack = handler.getStackInSlot(i);
                if (!(stack.func_77973_b() instanceof IAccessoryInterface)) continue;
                IAccessoryInterface item = (IAccessoryInterface)stack.func_77973_b();
                item.eventPlayerChangedDimension(stack, player, event.fromDim, event.toDim);
            }
        });
    }

    @SubscribeEvent
    public void playerUpdate(TickEvent.PlayerTickEvent event) {
        EntityPlayer player = event.player;
        if (!player.func_70089_S()) {
            return;
        }
        if (event.phase == TickEvent.Phase.END) {
            BaublesHelper.getBaublesHandler((EntityLivingBase)player, handler -> {
                for (int i = 0; i < handler.getSlots(); ++i) {
                    ItemStack stack = handler.getStackInSlot(i);
                    boolean empty = stack.func_190926_b();
                    if (empty || !(stack.func_77973_b() instanceof IAccessoryInterface)) continue;
                    IAccessoryInterface item = (IAccessoryInterface)stack.func_77973_b();
                    item.eventPlayerTick(stack, player);
                }
            });
        }
    }

    @SubscribeEvent
    public void potionApplicable(PotionEvent.PotionApplicableEvent event) {
        EntityLivingBase entity = event.getEntityLiving();
        BaublesHelper.getBaublesHandler(entity, handler -> {
            for (int i = 0; i < handler.getSlots(); ++i) {
                ItemStack stack = handler.getStackInSlot(i);
                boolean empty = stack.func_190926_b();
                if (empty || !(stack.func_77973_b() instanceof IAccessoryInterface)) continue;
                IAccessoryInterface item = (IAccessoryInterface)stack.func_77973_b();
                item.eventPotionApplicable(stack, entity, event);
            }
        });
    }

    @SubscribeEvent
    public void livingJump(LivingEvent.LivingJumpEvent event) {
        EntityLivingBase entity = event.getEntityLiving();
        BaublesHelper.getBaublesHandler(entity, handler -> {
            for (int i = 0; i < handler.getSlots(); ++i) {
                ItemStack stack = handler.getStackInSlot(i);
                boolean empty = stack.func_190926_b();
                if (empty || !(stack.func_77973_b() instanceof IAccessoryInterface)) continue;
                IAccessoryInterface item = (IAccessoryInterface)stack.func_77973_b();
                item.eventLivingJump(stack, entity);
            }
        });
    }

    @SubscribeEvent
    public void livingFall(LivingFallEvent event) {
        EntityLivingBase entity = event.getEntityLiving();
        BaublesHelper.getBaublesHandler(entity, handler -> {
            for (int i = 0; i < handler.getSlots(); ++i) {
                ItemStack stack = handler.getStackInSlot(i);
                boolean empty = stack.func_190926_b();
                if (empty || !(stack.func_77973_b() instanceof IAccessoryInterface)) continue;
                IAccessoryInterface item = (IAccessoryInterface)stack.func_77973_b();
                item.eventLivingFall(stack, entity, event);
            }
        });
    }

    @SubscribeEvent
    public void TargetEvent(LivingSetAttackTargetEvent event) {
        EntityLivingBase entity = event.getEntityLiving();
        BaublesHelper.getBaublesHandler(entity, handler -> {
            for (int i = 0; i < handler.getSlots(); ++i) {
                ItemStack stack = handler.getStackInSlot(i);
                boolean empty = stack.func_190926_b();
                if (empty || !(stack.func_77973_b() instanceof IAccessoryInterface)) continue;
                IAccessoryInterface item = (IAccessoryInterface)stack.func_77973_b();
                item.eventSetAttackTarget(stack, entity, event.getEntityLiving());
            }
        });
    }

    @SubscribeEvent
    public void HurtEvent(LivingHurtEvent event) {
        EntityLivingBase attacked = event.getEntityLiving();
        BaublesHelper.getBaublesHandler(attacked, handler -> {
            for (int i = 0; i < handler.getSlots(); ++i) {
                ItemStack stack = handler.getStackInSlot(i);
                boolean empty = stack.func_190926_b();
                if (empty || !(stack.func_77973_b() instanceof IAccessoryInterface)) continue;
                IAccessoryInterface item = (IAccessoryInterface)stack.func_77973_b();
                item.eventLivingHurtAttacked(stack, attacked, event);
            }
        });
        if (event.getSource().func_76346_g() instanceof EntityLivingBase) {
            EntityLivingBase attacker = (EntityLivingBase)event.getSource().func_76346_g();
            BaublesHelper.getBaublesHandler(attacker, handler -> {
                for (int i = 0; i < handler.getSlots(); ++i) {
                    ItemStack stack = handler.getStackInSlot(i);
                    boolean empty = stack.func_190926_b();
                    if (empty || !(stack.func_77973_b() instanceof IAccessoryInterface)) continue;
                    IAccessoryInterface item = (IAccessoryInterface)stack.func_77973_b();
                    item.eventLivingHurtAttacker(stack, attacker, event);
                }
            });
        }
    }

    @SubscribeEvent
    public void deathEvent(LivingDamageEvent event) {
        EntityLivingBase attacked = event.getEntityLiving();
        BaublesHelper.getBaublesHandler(attacked, handler -> {
            for (int i = 0; i < handler.getSlots(); ++i) {
                ItemStack stack = handler.getStackInSlot(i);
                boolean empty = stack.func_190926_b();
                if (empty || !(stack.func_77973_b() instanceof IAccessoryInterface)) continue;
                IAccessoryInterface item = (IAccessoryInterface)stack.func_77973_b();
                item.eventLivingDamageAttacked(stack, attacked, event);
            }
        });
        if (event.getSource().func_76346_g() instanceof EntityLivingBase) {
            EntityLivingBase attacker = (EntityLivingBase)event.getSource().func_76346_g();
            BaublesHelper.getBaublesHandler(attacker, handler -> {
                for (int i = 0; i < handler.getSlots(); ++i) {
                    ItemStack stack = handler.getStackInSlot(i);
                    boolean empty = stack.func_190926_b();
                    if (empty || !(stack.func_77973_b() instanceof IAccessoryInterface)) continue;
                    IAccessoryInterface item = (IAccessoryInterface)stack.func_77973_b();
                    item.eventLivingDamageAttacker(stack, attacker, event);
                }
            });
        }
    }

    @SubscribeEvent
    public void experienceDropEvent(LivingExperienceDropEvent event) {
        EntityPlayer player = event.getAttackingPlayer();
        BaublesHelper.getBaublesHandler((EntityLivingBase)player, handler -> {
            for (int i = 0; i < handler.getSlots(); ++i) {
                ItemStack stack = handler.getStackInSlot(i);
                boolean empty = stack.func_190926_b();
                if (empty || !(stack.func_77973_b() instanceof IAccessoryInterface)) continue;
                IAccessoryInterface item = (IAccessoryInterface)stack.func_77973_b();
                item.eventLivingExperienceDrops(stack, player, event);
            }
        });
    }

    @SubscribeEvent
    public void ItemDropEvent(LivingDropsEvent event) {
        if (event.getSource().func_76346_g() instanceof EntityLivingBase) {
            EntityLivingBase entity = (EntityLivingBase)event.getSource().func_76346_g();
            BaublesHelper.getBaublesHandler(entity, handler -> {
                for (int i = 0; i < handler.getSlots(); ++i) {
                    ItemStack stack = handler.getStackInSlot(i);
                    boolean empty = stack.func_190926_b();
                    if (empty || !(stack.func_77973_b() instanceof IAccessoryInterface)) continue;
                    IAccessoryInterface item = (IAccessoryInterface)stack.func_77973_b();
                    item.eventLivingDrops(stack, entity, event);
                }
            });
        }
    }

    @SubscribeEvent
    public void onAttemptToBreakBlock(PlayerEvent.BreakSpeed event) {
        EntityPlayer player = event.getEntityPlayer();
        BaublesHelper.getBaublesHandler((EntityLivingBase)player, handler -> {
            for (int i = 0; i < handler.getSlots(); ++i) {
                ItemStack stack = handler.getStackInSlot(i);
                boolean empty = stack.func_190926_b();
                if (empty || !(stack.func_77973_b() instanceof IAccessoryInterface)) continue;
                IAccessoryInterface item = (IAccessoryInterface)stack.func_77973_b();
                item.eventBreakSpeed(stack, player, event);
            }
        });
    }

    @SubscribeEvent
    public void onBlockBroken(BlockEvent.BreakEvent event) {
        EntityPlayer player = event.getPlayer();
        BaublesHelper.getBaublesHandler((EntityLivingBase)player, handler -> {
            for (int i = 0; i < handler.getSlots(); ++i) {
                ItemStack stack = handler.getStackInSlot(i);
                boolean empty = stack.func_190926_b();
                if (empty || !(stack.func_77973_b() instanceof IAccessoryInterface)) continue;
                IAccessoryInterface item = (IAccessoryInterface)stack.func_77973_b();
                item.eventBlockBreak(stack, player, event);
            }
        });
    }

    @SubscribeEvent
    public void onBlockDrops(BlockEvent.HarvestDropsEvent event) {
        EntityPlayer player = event.getHarvester();
        BaublesHelper.getBaublesHandler((EntityLivingBase)player, handler -> {
            for (int i = 0; i < handler.getSlots(); ++i) {
                ItemStack stack = handler.getStackInSlot(i);
                boolean empty = stack.func_190926_b();
                if (empty || !(stack.func_77973_b() instanceof IAccessoryInterface)) continue;
                IAccessoryInterface item = (IAccessoryInterface)stack.func_77973_b();
                item.eventBlockDrops(stack, (EntityLivingBase)player, event);
            }
        });
    }

    private static /* synthetic */ void lambda$clientTickEvent$0(EntityPlayer player, IBaublesItemHandler handler) {
        for (int i = 0; i < handler.getSlots(); ++i) {
            ItemStack stack = handler.getStackInSlot(i);
            boolean empty = stack.func_190926_b();
            if (empty || !(stack.func_77973_b() instanceof IAccessoryInterface)) continue;
            IAccessoryInterface item = (IAccessoryInterface)stack.func_77973_b();
            item.eventClientTick(stack, player);
        }
    }
}

