/*
 * Decompiled with CFR 0.152.
 */
package xzeroair.trinkets.container;

import baubles.api.IBauble;
import baubles.api.cap.BaublesCapabilities;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.ItemStack;
import net.minecraftforge.items.ItemStackHandler;
import xzeroair.trinkets.Trinkets;
import xzeroair.trinkets.capabilities.InventoryContainerCapability.ITrinketContainerHandler;
import xzeroair.trinkets.util.TrinketsConfig;
import xzeroair.trinkets.util.interfaces.IAccessoryInterface;

public class TrinketContainerHandler
extends ItemStackHandler
implements ITrinketContainerHandler {
    private static int slots = TrinketsConfig.SERVER.GUI.guiSlotsRows;
    private boolean[] changed = new boolean[slots];
    private boolean blockEvents = false;
    private EntityLivingBase player;

    public TrinketContainerHandler() {
        super(slots);
    }

    public void setSize(int size) {
        if (size < slots || size > slots) {
            size = slots;
        }
        super.setSize(size);
        boolean[] old = this.changed;
        this.changed = new boolean[size];
        for (int i = 0; i < old.length && i < this.changed.length; ++i) {
            this.changed[i] = old[i];
        }
    }

    public void setStackInSlot(int slot, ItemStack stack) {
        if (stack == null || stack.func_190926_b() || this.isItemValidForSlot(slot, stack, this.player)) {
            super.setStackInSlot(slot, stack);
        }
    }

    public ItemStack insertItem(int slot, ItemStack stack, boolean simulate) {
        if (!this.isItemValidForSlot(slot, stack, this.player)) {
            return stack;
        }
        return super.insertItem(slot, stack, simulate);
    }

    @Override
    public void setPlayer(EntityLivingBase player) {
        this.player = player;
    }

    @Override
    public boolean isItemValidForSlot(int slot, ItemStack stack, EntityLivingBase player) {
        if (stack == null || stack.func_190926_b() || !(stack.func_77973_b() instanceof IAccessoryInterface)) {
            return false;
        }
        if (stack.func_77973_b() instanceof IAccessoryInterface) {
            IAccessoryInterface trinket = (IAccessoryInterface)stack.func_77973_b();
            return trinket.canEquipAccessory(stack, player);
        }
        if (TrinketsConfig.compat.baubles && Trinkets.Baubles && stack.func_77973_b() instanceof IBauble) {
            IBauble bauble = (IBauble)stack.getCapability(BaublesCapabilities.CAPABILITY_ITEM_BAUBLE, null);
            return true;
        }
        return false;
    }

    @Override
    public boolean isEventBlocked() {
        return this.blockEvents;
    }

    @Override
    public void setEventBlock(boolean blockEvents) {
        this.blockEvents = blockEvents;
    }
}

