/*
 * Decompiled with CFR 0.152.
 */
package xzeroair.trinkets.commands;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import javax.annotation.Nullable;
import net.minecraft.command.CommandBase;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import xzeroair.trinkets.capabilities.Capabilities;
import xzeroair.trinkets.capabilities.magic.MagicStats;
import xzeroair.trinkets.capabilities.race.EntityProperties;
import xzeroair.trinkets.init.EntityRaces;
import xzeroair.trinkets.races.EntityRace;

public class CommandMain
extends CommandBase {
    private final List<String> tabCompletionsCommands = Arrays.asList("help", "mana", "race");
    private final String commandUsage = "/xat help";
    private final String listOfCommands = "   help <command>\nmana set <Amount>\nmana setMax <Amount>";
    private final String warn_notPlayerAdmin = "You do not have permission, or are not a player ingame!";
    private final String warn_invalidArgs = "Invalid Arguments";
    private final String warn_noItem = "Not holding an item!";
    private final String exportJsonReminder = "(Don't forget to exportJson !)";

    public List<String> func_71514_a() {
        return Arrays.asList("xat");
    }

    public String func_71517_b() {
        return "Trinkets and Baubles";
    }

    public int func_82362_a() {
        return 0;
    }

    public String func_71518_a(ICommandSender sender) {
        return "/xat <PLAYER>";
    }

    public List<String> func_184883_a(MinecraftServer server, ICommandSender sender, String[] args, @Nullable BlockPos targetPos) {
        int length = args.length;
        if (length == 4) {
            switch (args[1].toLowerCase(Locale.ENGLISH)) {
                case "mana": {
                    switch (args[2].toLowerCase(Locale.ENGLISH)) {
                        case "set": {
                            return CommandMain.func_71530_a((String[])args, (String[])new String[]{"0", "100", "200", "300"});
                        }
                    }
                    return Collections.emptyList();
                }
                case "race": {
                    switch (args[2].toLowerCase(Locale.ENGLISH)) {
                        case "clearRace": {
                            return Collections.emptyList();
                        }
                        case "clearFoodRace": {
                            return Collections.emptyList();
                        }
                    }
                    return CommandMain.func_175762_a((String[])args, (Collection)EntityRace.Registry.getKeys());
                }
            }
            return Collections.emptyList();
        }
        if (length == 3) {
            switch (args[1].toLowerCase(Locale.ENGLISH)) {
                case "mana": {
                    return CommandMain.func_71530_a((String[])args, (String[])new String[]{"refill", "set"});
                }
                case "race": {
                    return CommandMain.func_71530_a((String[])args, (String[])new String[]{"setRace", "setFoodRace", "clearRace", "clearFoodRace"});
                }
            }
            return Collections.emptyList();
        }
        if (length == 2) {
            return CommandMain.func_71530_a((String[])args, (String[])new String[]{"mana", "race"});
        }
        if (length == 1) {
            return CommandMain.func_71530_a((String[])args, (String[])server.func_71213_z());
        }
        return Collections.emptyList();
    }

    public void func_184881_a(MinecraftServer server, ICommandSender sender, String[] args) throws CommandException {
        int length = args.length;
        if (length == 0) {
            this.help(sender);
            return;
        }
        EntityPlayerMP entityplayer = CommandMain.func_184888_a((MinecraftServer)server, (ICommandSender)sender, (String)args[0]);
        if (length > 1) {
            switch (args[1].toLowerCase(Locale.ENGLISH)) {
                case "mana": {
                    this.doMagic((EntityPlayer)entityplayer, server, sender, args);
                    break;
                }
                case "race": {
                    this.entityRace((EntityPlayer)entityplayer, server, sender, args);
                    break;
                }
                default: {
                    this.help(sender);
                    break;
                }
            }
        } else {
            this.help(sender);
        }
    }

    private void helpCommand(MinecraftServer server, ICommandSender sender, String[] args) {
        if (args.length < 2) {
            this.message(sender, "   help <command>\nmana set <Amount>\nmana setMax <Amount>");
            return;
        }
        switch (args[1].toLowerCase()) {
            case "help": {
                this.message(sender, "If you need more help, you can contact the mod author on CurseForge or GitHub");
                return;
            }
        }
        this.message(sender, "/xat help <command> \n(Replace <command> with a simpledifficulty command name)");
    }

    private void doMagic(EntityPlayer target, MinecraftServer server, ICommandSender sender, String[] args) {
        if (this.isAdminPlayer(sender)) {
            try {
                boolean i = false;
                MagicStats capability = Capabilities.getMagicStats((Entity)target);
                if (args.length > 2) {
                    switch (args[2].toLowerCase(Locale.ENGLISH)) {
                        case "refill": {
                            capability.refillMana();
                            break;
                        }
                        case "set": {
                            if (args.length <= 3) break;
                            capability.setMana(Float.parseFloat(args[3]));
                            break;
                        }
                    }
                }
            }
            catch (NumberFormatException e) {
                this.message(sender, "Invalid Arguments <MP>");
                return;
            }
        }
    }

    private void entityRace(EntityPlayer target, MinecraftServer server, ICommandSender sender, String[] args) {
        if (this.isAdminPlayer(sender)) {
            try {
                int length = args.length;
                if (length < 2) {
                    this.message(sender, "Invalid Arguments <modid>");
                    return;
                }
                EntityProperties capability = Capabilities.getEntityProperties((Entity)target);
                String entity = args[0];
                if (length > 1) {
                    String prefixCommand = args[1];
                    if (length > 2) {
                        String command = args[2];
                        String race = "";
                        if (length > 3) {
                            race = args[3];
                        }
                        EntityRace r = EntityRace.getByNameOrId(race);
                        switch (command.toLowerCase(Locale.ENGLISH)) {
                            case "setrace": {
                                if (r == null) break;
                                capability.setOriginalRace(r);
                                break;
                            }
                            case "setfoodrace": {
                                if (r == null) break;
                                capability.setImbuedRace(r);
                                break;
                            }
                            case "clearrace": {
                                capability.setOriginalRace(EntityRaces.none);
                                break;
                            }
                            case "clearfoodrace": {
                                capability.setImbuedRace(EntityRaces.none);
                                break;
                            }
                        }
                    }
                }
            }
            catch (NumberFormatException e) {
                this.message(sender, "Invalid Arguments <MP>");
                return;
            }
        }
    }

    private int getMetadataFromStack(ItemStack stack) {
        return stack.func_77981_g() ? stack.func_77960_j() : -1;
    }

    private String getRegistryName(ItemStack stack) {
        return stack.func_77973_b().getRegistryName().toString();
    }

    private boolean isAdminPlayer(ICommandSender sender) {
        return this.hasPermissionLevel(sender, 4) && sender.func_174793_f() instanceof EntityPlayer;
    }

    private void help(ICommandSender sender) {
        sender.func_145747_a((ITextComponent)new TextComponentString(this.func_71518_a(sender)));
    }

    private void message(ICommandSender sender, String message) {
        sender.func_145747_a((ITextComponent)new TextComponentString(message));
    }

    private boolean hasPermissionLevel(ICommandSender sender, int permLevel) {
        return sender.func_70003_b(permLevel, "Trinkets and Baubles");
    }

    private boolean hasNBTArgument(String[] input) {
        return this.hasArgument("--nbt", input);
    }

    private boolean hasClearArgument(String[] input) {
        return this.hasArgument("--clear", input);
    }

    private boolean hasArgument(String argument, String[] input) {
        if (input == null) {
            return false;
        }
        for (String s : input) {
            if (!s.equals(argument)) continue;
            return true;
        }
        return false;
    }
}

