/*
 * Decompiled with CFR 0.152.
 */
package xzeroair.trinkets.capabilities.statushandler;

import java.util.HashMap;
import java.util.Map;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.DamageSource;
import xzeroair.trinkets.api.TrinketHelper;
import xzeroair.trinkets.capabilities.CapabilityBase;
import xzeroair.trinkets.capabilities.statushandler.TrinketStatusEffect;
import xzeroair.trinkets.init.ModItems;
import xzeroair.trinkets.network.NetworkHandler;
import xzeroair.trinkets.network.status.StatusEffectPacket;
import xzeroair.trinkets.traits.statuseffects.StatusEffectsEnum;

public class StatusHandler
extends CapabilityBase<StatusHandler, EntityLivingBase> {
    Map<String, TrinketStatusEffect> effects = new HashMap<String, TrinketStatusEffect>();

    public StatusHandler(EntityLivingBase entity) {
        super(entity);
    }

    @Override
    public void onUpdate() {
        if (!this.effects.isEmpty()) {
            for (Map.Entry<String, TrinketStatusEffect> entry : this.effects.entrySet()) {
                if (entry.getValue().getDuration() > 0) {
                    entry.getValue().tickDuration();
                    continue;
                }
                this.effects.remove(entry.getKey());
            }
        }
        if (this.effects.containsKey(StatusEffectsEnum.paralysis.getName())) {
            if (!TrinketHelper.AccessoryCheck((EntityLivingBase)this.object, ModItems.trinkets.TrinketArcingOrb)) {
                ((EntityLivingBase)this.object).field_70159_w = 0.0;
                if (((EntityLivingBase)this.object).field_70181_x > 0.0) {
                    ((EntityLivingBase)this.object).field_70181_x = 0.0;
                }
                ((EntityLivingBase)this.object).field_70179_y = 0.0;
                ((EntityLivingBase)this.object).field_70122_E = false;
            } else {
                this.remove(StatusEffectsEnum.paralysis.getIndex());
            }
        }
        if (this.effects.containsKey(StatusEffectsEnum.bleed.getName())) {
            if (!TrinketHelper.AccessoryCheck((EntityLivingBase)this.object, ModItems.trinkets.TrinketFaelisClaw)) {
                TrinketStatusEffect bleeding = this.effects.get(StatusEffectsEnum.bleed.getName());
                float damage = 0.5f * (float)bleeding.getLevel();
                int duration = bleeding.getDuration();
                if (duration % 20 == 0) {
                    ((EntityLivingBase)this.object).func_70097_a(DamageSource.field_76376_m, damage);
                }
            } else {
                this.remove(StatusEffectsEnum.bleed.getIndex());
            }
        }
        if (this.effects.containsKey(StatusEffectsEnum.Invigorated.getName())) {
            // empty if block
        }
    }

    public void apply(int effectIndex, int dur, int level, Entity source) {
        StatusEffectsEnum effectEnum = StatusEffectsEnum.getStatusByIndex(effectIndex);
        TrinketStatusEffect effect = new TrinketStatusEffect(effectEnum, dur, level, source);
        this.apply(effect);
    }

    public void apply(TrinketStatusEffect effect) {
        if (!this.effects.containsKey(effect.getEffectName())) {
            this.effects.put(effect.getEffectName(), effect);
            if (!((EntityLivingBase)this.object).func_130014_f_().field_72995_K && this.object instanceof EntityPlayerMP) {
                NetworkHandler.sendTo(new StatusEffectPacket(effect.getSource(), (EntityLivingBase)this.object, effect), (EntityPlayerMP)this.object);
            }
        }
    }

    public void combine(int effectIndex, int dur, int level) {
        StatusEffectsEnum effectEnum = StatusEffectsEnum.getStatusByIndex(effectIndex);
        if (this.effects.containsKey(effectEnum.getName())) {
            TrinketStatusEffect e = this.effects.get(effectEnum.getName());
            e.addDuration(dur);
            e.addLevel(level);
        }
    }

    public void combine(TrinketStatusEffect effect) {
        if (this.effects.containsKey(effect.getEffectName())) {
            TrinketStatusEffect e = this.effects.get(effect.getEffectName());
            e.addDuration(effect.getDuration());
            e.addLevel(effect.getLevel());
        }
    }

    public void remove(int effectIndex) {
        StatusEffectsEnum effect = StatusEffectsEnum.getStatusByIndex(effectIndex);
        if (this.effects.containsKey(effect.getName())) {
            this.effects.remove(effect.getName());
        }
    }

    public void remove(StatusEffectsEnum effect) {
        if (this.effects.containsKey(effect.getName())) {
            this.effects.remove(effect.getName());
        }
    }

    public void removeAll() {
        if (!this.effects.isEmpty()) {
            this.effects.clear();
        }
    }

    public Map<String, TrinketStatusEffect> getActiveEffects() {
        return this.effects;
    }

    public void savedNBTData(NBTTagCompound tag) {
    }

    public void loadNBTData(NBTTagCompound nbt) {
    }
}

