/*
 * Decompiled with CFR 0.152.
 */
package xzeroair.trinkets.capabilities.Vip;

import java.util.ArrayList;
import java.util.List;
import java.util.TreeMap;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import xzeroair.trinkets.capabilities.CapabilityBase;
import xzeroair.trinkets.network.NetworkHandler;
import xzeroair.trinkets.network.vip.VipStatusPacket;
import xzeroair.trinkets.util.Reference;
import xzeroair.trinkets.vip.VIPHandler;
import xzeroair.trinkets.vip.VipPackage;
import xzeroair.trinkets.vip.VipUser;

public class VipStatus
extends CapabilityBase<VipStatus, EntityPlayer> {
    boolean first_login = true;
    boolean login = false;
    EntityPlayer player;
    int status = 0;
    boolean checkStatus;
    List<String> Quotes;
    private VipUser user;

    public VipStatus(EntityPlayer player) {
        super(player);
        this.player = player;
        this.Quotes = new ArrayList<String>();
    }

    @Override
    public NBTTagCompound getTag() {
        NBTTagCompound tag = ((EntityPlayer)this.object).getEntityData();
        if (tag != null) {
            if (!tag.func_74764_b("PlayerPersisted")) {
                tag.func_74782_a("PlayerPersisted", (NBTBase)new NBTTagCompound());
            }
            NBTTagCompound persistentData = tag.func_74775_l("PlayerPersisted");
            String capTag = "xat.VIP";
            if (!persistentData.func_74764_b("xat.VIP")) {
                persistentData.func_74782_a("xat.VIP", (NBTBase)new NBTTagCompound());
            }
            return persistentData.func_74775_l("xat.VIP");
        }
        return super.getTag();
    }

    @Override
    public void onUpdate() {
        World world = this.player.field_70170_p;
        if (world == null) {
            return;
        }
        if (!this.checkStatus) {
            if (!world.field_72995_K) {
                try {
                    TreeMap<String, VipUser> list = VIPHandler.Vips;
                    if (list != null) {
                        this.confirmedStatus();
                        this.sendStatusToPlayer(this.player);
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            this.checkStatus = true;
        }
    }

    public void confirmedStatus() {
        String id = this.player.func_110124_au().toString().replaceAll("-", "");
        if (VIPHandler.Vips.containsKey(id)) {
            this.user = VIPHandler.Vips.get(id);
            if (this.user != null) {
                VipPackage group1;
                if (!this.user.getGroups().isEmpty() && (group1 = this.user.getGroups().get(0)) != null) {
                    this.status = group1.getGroupID();
                }
                this.Quotes = this.user.getQuotes();
            }
        }
    }

    public void sendStatusToServer(EntityPlayer player) {
        World world = player.func_130014_f_();
        if (world.field_72995_K) {
            NBTTagCompound tag = new NBTTagCompound();
            this.saveToNBT(tag);
            NetworkHandler.sendToServer(new VipStatusPacket(player, tag));
        }
    }

    public void sendStatusToPlayer(EntityPlayer reciever) {
        World world = this.player.func_130014_f_();
        if (!world.field_72995_K && reciever instanceof EntityPlayerMP) {
            try {
                NBTTagCompound tag = new NBTTagCompound();
                this.saveToNBT(tag);
                NetworkHandler.sendTo(new VipStatusPacket(this.player, tag), (EntityPlayerMP)reciever);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void syncStatusToTracking() {
        World world = this.player.func_130014_f_();
        if (this.player instanceof EntityPlayerMP && world instanceof WorldServer) {
            NBTTagCompound tag = new NBTTagCompound();
            this.saveToNBT(tag);
            NetworkHandler.sendToClients((WorldServer)world, this.player.func_180425_c(), new VipStatusPacket(this.player, tag));
        }
    }

    public List<String> getQuotes() {
        return this.Quotes;
    }

    public String getRandomQuote() {
        if (!this.Quotes.isEmpty()) {
            int rand = Reference.random.nextInt(this.Quotes.size());
            return this.Quotes.get(rand);
        }
        return "";
    }

    public void setStatus(int status) {
        this.status = status;
    }

    public int getStatus() {
        return this.status;
    }

    public boolean isFirstLogin() {
        return this.first_login;
    }

    public boolean isLogin() {
        return this.login;
    }

    public void setLogin(boolean login) {
        this.login = login;
    }

    @Override
    public void copyFrom(VipStatus source, boolean wasDeath, boolean keepInv) {
        this.first_login = source.first_login;
        this.login = source.login;
        this.status = source.status;
    }

    @Override
    public NBTTagCompound saveToNBT(NBTTagCompound compound) {
        compound.func_74768_a("status", this.status);
        compound.func_74757_a("login", this.login);
        compound.func_74778_a("uuid", this.player.func_189512_bd());
        return compound;
    }

    @Override
    public void loadFromNBT(NBTTagCompound compound) {
        if (compound.func_74764_b("status")) {
            this.status = compound.func_74762_e("status");
        }
        if (compound.func_74764_b("login")) {
            this.login = compound.func_74767_n("login");
        }
        this.first_login = false;
    }
}

