/*
 * Decompiled with CFR 0.152.
 */
package greymerk.roguelike.treasure.loot.provider;

import com.github.fnar.minecraft.block.BlockType;
import com.github.fnar.minecraft.item.ArmourType;
import com.github.fnar.minecraft.item.Dye;
import com.github.fnar.minecraft.item.Enchantment;
import com.github.fnar.minecraft.item.Food;
import com.github.fnar.minecraft.item.Material;
import com.github.fnar.minecraft.item.Record;
import com.github.fnar.minecraft.item.RldItemStack;
import com.github.fnar.minecraft.item.ToolType;
import com.github.fnar.minecraft.item.WeaponType;
import com.github.fnar.util.Color;
import greymerk.roguelike.treasure.loot.Quality;
import greymerk.roguelike.util.DyeColor;
import greymerk.roguelike.util.TextFormat;
import java.util.HashMap;
import java.util.Map;

public enum ItemNovelty {
    AMLP,
    ASHLEA,
    AVIDYA,
    BAJ,
    BDOUBLEO,
    CLEO,
    DINNERBONE,
    DOCM,
    ENIKOBOW,
    ENIKOSWORD,
    ETHO,
    FOURLES,
    GENERIKB,
    GINGER,
    GREYMERK,
    GRIM,
    GUUDE,
    KURT,
    MANPANTS,
    MMILLSS,
    NEBRISCROWN,
    NOTCH,
    NULL,
    QUANTUMLEAP,
    RLEAHY,
    VALANDRAH,
    VECHS,
    ZISTEAUSIGN;

    public static final Map<String, ItemNovelty> names;

    public static RldItemStack getItemByName(String name) {
        if (!names.containsKey(name)) {
            return null;
        }
        return ItemNovelty.getItem(names.get(name));
    }

    public static RldItemStack getItem(ItemNovelty choice) {
        switch (choice) {
            case GREYMERK: {
                return ItemNovelty.greymerksHatchet();
            }
            case NEBRISCROWN: {
                return ItemNovelty.nebrisCrown();
            }
            case NULL: {
                return ItemNovelty.nullPointer();
            }
            case MANPANTS: {
                return ItemNovelty.manPants();
            }
            case ZISTEAUSIGN: {
                return ItemNovelty.zisteauSign();
            }
            case AVIDYA: {
                return ItemNovelty.avidyasWhiteRussian();
            }
            case ASHLEA: {
                return ItemNovelty.ashleasOatmealCookie();
            }
            case KURT: {
                return ItemNovelty.farlandTravellers();
            }
            case AMLP: {
                return ItemNovelty.lascerator();
            }
            case CLEO: {
                return ItemNovelty.cleophianDiggingFeesh();
            }
            case BDOUBLEO: {
                return ItemNovelty.bDoubleOsDigJob();
            }
            case GUUDE: {
                return ItemNovelty.boulderfistianGoldenRecord();
            }
            case RLEAHY: {
                return ItemNovelty.rleahianBattleSub();
            }
            case ETHO: {
                return ItemNovelty.ethosYourMomJoke();
            }
            case ENIKOBOW: {
                return ItemNovelty.enikosStringTheory();
            }
            case ENIKOSWORD: {
                return ItemNovelty.enikosEarring();
            }
            case BAJ: {
                return ItemNovelty.bajsLastResort();
            }
            case DOCM: {
                return ItemNovelty.docmRodOfCommand();
            }
            case GINGER: {
                return ItemNovelty.gingerSpiceChicken();
            }
            case VECHS: {
                return ItemNovelty.vechsLegendaryStick();
            }
            case NOTCH: {
                return ItemNovelty.notchsApple();
            }
            case QUANTUMLEAP: {
                return ItemNovelty.quantumleapsSwissCheese();
            }
            case GENERIKB: {
                return ItemNovelty.generikBsHotPotato();
            }
            case FOURLES: {
                return ItemNovelty.fourlesDarkroastBeans();
            }
            case DINNERBONE: {
                return ItemNovelty.oldDinnerbone();
            }
            case GRIM: {
                return ItemNovelty.grimChewToy();
            }
            case MMILLSS: {
                return ItemNovelty.mmillssSpiderBane();
            }
            case VALANDRAH: {
                return ItemNovelty.valandrahsKiss();
            }
        }
        return null;
    }

    public static RldItemStack greymerksHatchet() {
        return ToolType.AXE.asItem().withQuality(Quality.IRON).withEnchantment(Enchantment.Effect.SHARPNESS.atLevel(3)).withEnchantment(Enchantment.Effect.KNOCKBACK).withEnchantment(Enchantment.Effect.UNBREAKING.atLevel(2)).asStack().withDisplayName("Greymerk's Hatchet").withDisplayLore(TextFormat.DARKGREEN.apply("Pointlessly sharp"));
    }

    public static RldItemStack nebrisCrown() {
        return ArmourType.HELMET.asItem().golden().withEnchantment(Enchantment.Effect.PROTECTION.atLevel(4)).withEnchantment(Enchantment.Effect.UNBREAKING.atLevel(3)).asStack().withDisplayName("Nebrian Crown of Justice").withDisplayLore(TextFormat.DARKGREEN.apply("Adorned with precious gemstones"));
    }

    public static RldItemStack nullPointer() {
        return WeaponType.SWORD.asItem().diamond().withEnchantment(Enchantment.Effect.SHARPNESS.atLevel(5)).withEnchantment(Enchantment.Effect.KNOCKBACK.atLevel(2)).withEnchantment(Enchantment.Effect.UNBREAKING.atLevel(3)).asStack().withDisplayName("Null Pointer").withDisplayLore(TextFormat.DARKGREEN.apply("Exceptional"));
    }

    public static RldItemStack manPants() {
        return ArmourType.LEGGINGS.asItem().leather().withColor(Color.SMOKED_SALMON).withEnchantment(Enchantment.Effect.FIRE_PROTECTION.atLevel(4)).withEnchantment(Enchantment.Effect.UNBREAKING.atLevel(3)).asStack().withDisplayName("Man Pants").withDisplayLore(TextFormat.DARKGREEN.apply("Yessss, Manpants!"));
    }

    public static RldItemStack zisteauSign() {
        return BlockType.SIGN.asItem().withEnchantment(Enchantment.Effect.SHARPNESS.atLevel(5)).withEnchantment(Enchantment.Effect.KNOCKBACK.atLevel(3)).withEnchantment(Enchantment.Effect.FIRE_ASPECT).asStack().withDisplayName(TextFormat.DARKPURPLE.apply("Battle Sign")).withDisplayLore(TextFormat.DARKGREEN.apply("\"That's what you get!\""));
    }

    public static RldItemStack avidyasWhiteRussian() {
        return Food.Type.MILK_BUCKET.asItem().withEnchantment(Enchantment.Effect.BANE_OF_ARTHROPODS.atLevel(4)).withEnchantment(Enchantment.Effect.KNOCKBACK).withEnchantment(Enchantment.Effect.FIRE_ASPECT).asStack().withDisplayName(TextFormat.DARKPURPLE.apply("White Russian")).withDisplayLore(TextFormat.DARKGREEN.apply("The dude's favourite"));
    }

    public static RldItemStack ashleasOatmealCookie() {
        return Food.Type.COOKIE.asItem().withEnchantment(Enchantment.Effect.SHARPNESS.atLevel(2)).withEnchantment(Enchantment.Effect.KNOCKBACK).asStack().withDisplayName(TextFormat.DARKPURPLE.apply("Ashlea's Oatmeal Cookie")).withDisplayLore(TextFormat.DARKGREEN.apply("Perfect for elevensies"));
    }

    public static RldItemStack farlandTravellers() {
        return ArmourType.BOOTS.asItem().leather().withColor(Color.HARISSA_RED).withEnchantment(Enchantment.Effect.PROTECTION.atLevel(3)).withEnchantment(Enchantment.Effect.FEATHER_FALLING.atLevel(2)).withEnchantment(Enchantment.Effect.UNBREAKING.atLevel(3)).asStack().withDisplayName("Farland Travellers").withDisplayLore(TextFormat.DARKGREEN.apply("Indeed!"));
    }

    public static RldItemStack lascerator() {
        return ToolType.SHEARS.asItem().withEnchantment(Enchantment.Effect.SHARPNESS.atLevel(3)).withEnchantment(Enchantment.Effect.KNOCKBACK.atLevel(2)).withEnchantment(Enchantment.Effect.FIRE_ASPECT).asStack().withDisplayName("Lascerator").withDisplayLore(TextFormat.DARKGREEN.apply("The wool collector"));
    }

    public static RldItemStack cleophianDiggingFeesh() {
        return Food.Type.RAW_COD.asItem().withEnchantment(Enchantment.Effect.EFFICIENCY.atLevel(10)).withEnchantment(Enchantment.Effect.KNOCKBACK.atLevel(5)).withEnchantment(Enchantment.Effect.FORTUNE.atLevel(5)).withEnchantment(Enchantment.Effect.UNBREAKING.atLevel(10)).asStack().withDisplayName(TextFormat.DARKPURPLE.apply("Cleophian Digging Feesh")).withDisplayLore(TextFormat.DARKGREEN.apply("Feesh are not efeeshent for digging"));
    }

    public static RldItemStack bDoubleOspinkSweater() {
        return ArmourType.CHESTPLATE.asItem().withQuality(Quality.WOOD).withColor(Color.CHINESE_RED).asStack().withDisplayName("Pink Sweater").withDisplayLore("\"It's chinese red!\"");
    }

    public static RldItemStack bDoubleOsDigJob() {
        return ToolType.SHOVEL.asItem().diamond().withEnchantment(Enchantment.Effect.EFFICIENCY.atLevel(5)).withEnchantment(Enchantment.Effect.UNBREAKING.atLevel(3)).asStack().withDisplayName("Dig Job").withDisplayLore(TextFormat.DARKGREEN.apply("Recovered from hell's blazes"));
    }

    public static RldItemStack boulderfistianGoldenRecord() {
        return Record.newRecord().withSong(Record.Song.THIRTEEN).withEnchantment(Enchantment.Effect.SHARPNESS.atLevel(3)).withEnchantment(Enchantment.Effect.KNOCKBACK).withEnchantment(Enchantment.Effect.BLAST_PROTECTION.atLevel(3)).asStack().withDisplayName(TextFormat.DARKPURPLE.apply("Boulderfistian Golden Record")).withDisplayLore(TextFormat.DARKGREEN.apply("\"You're Watching Guude Boulderfist...\""));
    }

    public static RldItemStack rleahianBattleSub() {
        return Food.Type.BREAD.asItem().withEnchantment(Enchantment.Effect.SHARPNESS.atLevel(2)).withEnchantment(Enchantment.Effect.KNOCKBACK).withEnchantment(Enchantment.Effect.FIRE_ASPECT.atLevel(2)).asStack().withDisplayName(TextFormat.DARKPURPLE.apply("Rleahian battle sub")).withDisplayLore(TextFormat.DARKGREEN.apply("With extra pastrami"));
    }

    public static RldItemStack ethosYourMomJoke() {
        return ToolType.PICKAXE.asItem().wooden().withEnchantment(Enchantment.Effect.EFFICIENCY.atLevel(5)).withEnchantment(Enchantment.Effect.UNBREAKING.atLevel(3)).asStack().withDisplayName("Your Mum").withDisplayLore(TextFormat.DARKGREEN.apply("The original"));
    }

    public static RldItemStack enikosStringTheory() {
        return WeaponType.BOW.asItem().withEnchantment(Enchantment.Effect.POWER.atLevel(5)).withEnchantment(Enchantment.Effect.KNOCKBACK.atLevel(2)).withEnchantment(Enchantment.Effect.INFINITY).withEnchantment(Enchantment.Effect.UNBREAKING.atLevel(3)).asStack().withDisplayName("Eniko's String Theory").withDisplayLore(TextFormat.DARKGREEN.apply("For Science!"));
    }

    public static RldItemStack enikosEarring() {
        return WeaponType.SWORD.asItem().diamond().withEnchantment(Enchantment.Effect.SHARPNESS.atLevel(5)).withEnchantment(Enchantment.Effect.LOOTING.atLevel(3)).withEnchantment(Enchantment.Effect.UNBREAKING.atLevel(3)).asStack().withDisplayName("Eniko's Earring").withDisplayLore(TextFormat.DARKGREEN.apply("\"She do the loot take boogie\""));
    }

    public static RldItemStack bajsLastResort() {
        return ToolType.HOE.asItem().golden().withEnchantment(Enchantment.Effect.SHARPNESS.atLevel(2)).withEnchantment(Enchantment.Effect.KNOCKBACK).withEnchantment(Enchantment.Effect.FORTUNE.atLevel(5)).asStack().withDisplayName(TextFormat.DARKPURPLE.apply("Baj's Last Resort")).withDisplayLore(TextFormat.DARKGREEN.apply("\"Starvation could be fatal\""));
    }

    public static RldItemStack docmRodOfCommand() {
        return ToolType.FISHING_ROD.asItem().withEnchantment(Enchantment.Effect.SHARPNESS.atLevel(3)).withEnchantment(Enchantment.Effect.KNOCKBACK).asStack().withDisplayName(TextFormat.DARKPURPLE.apply("Rod of Command")).withDisplayLore(TextFormat.DARKGREEN.apply("\"Get to the dang land!\""));
    }

    public static RldItemStack gingerSpiceChicken() {
        return Food.Type.COOKED_CHICKEN.asItem().withEnchantment(Enchantment.Effect.KNOCKBACK).withEnchantment(Enchantment.Effect.UNBREAKING.atLevel(3)).withEnchantment(Enchantment.Effect.SHARPNESS).asStack().withDisplayName(TextFormat.DARKPURPLE.apply("Spice Chicken")).withDisplayLore(TextFormat.DARKGREEN.apply("\"Kung Pao!\""));
    }

    public static RldItemStack vechsLegendaryStick() {
        return Material.Type.STICK.asItem().withEnchantment(Enchantment.Effect.UNBREAKING).asStack().withDisplayName(TextFormat.DARKPURPLE.apply("Legendary Stick")).withDisplayLore(TextFormat.DARKGREEN.apply("\"Really?!\""));
    }

    public static RldItemStack notchsApple() {
        return Food.Type.APPLE.asItem().withEnchantment(Enchantment.Effect.SHARPNESS.atLevel(10)).withEnchantment(Enchantment.Effect.KNOCKBACK.atLevel(10)).asStack().withDisplayName(TextFormat.DARKPURPLE.apply("Notch's apple")).withDisplayLore(TextFormat.DARKGREEN.apply("Imbued with the creator's power"));
    }

    public static RldItemStack quantumleapsSwissCheese() {
        return BlockType.SPONGE.asItem().withEnchantment(Enchantment.Effect.SHARPNESS.atLevel(4)).asStack().withDisplayName(TextFormat.DARKPURPLE.apply("QuantumLeap's Swiss Cheese")).withDisplayLore(TextFormat.DARKGREEN.apply("\"Oh boy\""));
    }

    public static RldItemStack generikBsHotPotato() {
        return Food.Type.BAKED_POTATO.asItem().withEnchantment(Enchantment.Effect.FIRE_ASPECT.atLevel(3)).withEnchantment(Enchantment.Effect.SHARPNESS.atLevel(2)).withEnchantment(Enchantment.Effect.KNOCKBACK).asStack().withDisplayName(TextFormat.DARKPURPLE.apply("Hot Potato")).withDisplayLore(TextFormat.DARKGREEN.apply("All a hermit needs"));
    }

    public static RldItemStack fourlesDarkroastBeans() {
        return new Dye(DyeColor.BROWN).withEnchantment(Enchantment.Effect.FIRE_ASPECT.atLevel(2)).withEnchantment(Enchantment.Effect.SHARPNESS.atLevel(2)).asStack().withDisplayName(TextFormat.DARKPURPLE.apply("Fourles Darkroast Beans")).withDisplayLore(TextFormat.DARKGREEN.apply("\"Mmmm... Dark Roast\""));
    }

    public static RldItemStack oldDinnerbone() {
        return Material.Type.BONE.asItem().withEnchantment(Enchantment.Effect.SHARPNESS.atLevel(3)).withEnchantment(Enchantment.Effect.FIRE_ASPECT.atLevel(2)).asStack().withDisplayName(TextFormat.DARKPURPLE.apply("Old Dinnerbone")).withDisplayLore(TextFormat.DARKGREEN.apply("\"Dang Skellies!\""));
    }

    public static RldItemStack grimChewToy() {
        return Food.Type.ROTTEN_FLESH.asItem().withEnchantment(Enchantment.Effect.SMITE.atLevel(2)).withEnchantment(Enchantment.Effect.LOOTING).asStack().withDisplayName(TextFormat.DARKPURPLE.apply("Grim chew-toy")).withDisplayLore(TextFormat.DARKGREEN.apply("\"Come on Grim, let's do this!\""));
    }

    public static RldItemStack mmillssSpiderBane() {
        return BlockType.CACTUS.asItem().withEnchantment(Enchantment.Effect.BANE_OF_ARTHROPODS.atLevel(4)).withEnchantment(Enchantment.Effect.THORNS.atLevel(2)).withEnchantment(Enchantment.Effect.LOOTING).asStack().withDisplayName(TextFormat.DARKPURPLE.apply("MMillssian spider bane")).withDisplayLore(TextFormat.DARKGREEN.apply("\"I really don't need anymore string...\""));
    }

    public static RldItemStack valandrahsKiss() {
        return WeaponType.SWORD.asItem().iron().withEnchantment(Enchantment.Effect.SHARPNESS.atLevel(4)).withEnchantment(Enchantment.Effect.FIRE_ASPECT).withEnchantment(Enchantment.Effect.KNOCKBACK).withEnchantment(Enchantment.Effect.UNBREAKING.atLevel(2)).asStack().withDisplayName("Valandrah's Kiss").withDisplayLore(TextFormat.DARKGREEN.apply("\"Feel the kiss of my blade\""));
    }

    static {
        names = new HashMap<String, ItemNovelty>();
        names.put("greymerk", GREYMERK);
        names.put("nebriscrown", NEBRISCROWN);
        names.put("nebrissword", NULL);
        names.put("zisteaupants", MANPANTS);
        names.put("zisteausign", ZISTEAUSIGN);
        names.put("avidya", AVIDYA);
        names.put("ashlea", ASHLEA);
        names.put("kurt", KURT);
        names.put("amlp", AMLP);
        names.put("cleo", CLEO);
        names.put("enikosword", ENIKOSWORD);
        names.put("enikobow", ENIKOBOW);
        names.put("bdoubleo", BDOUBLEO);
        names.put("guude", GUUDE);
        names.put("rleahy", RLEAHY);
        names.put("etho", ETHO);
        names.put("baj", BAJ);
        names.put("docm", DOCM);
        names.put("ginger", GINGER);
        names.put("vechs", VECHS);
        names.put("notch", NOTCH);
        names.put("quantumleap", QUANTUMLEAP);
        names.put("generikb", GENERIKB);
        names.put("fourles", FOURLES);
        names.put("dinnerbone", DINNERBONE);
        names.put("grim", GRIM);
        names.put("mmillss", MMILLSS);
        names.put("valandrah", VALANDRAH);
    }
}

