/*
 * Decompiled with CFR 0.152.
 */
package greymerk.roguelike.treasure.loot;

import com.github.fnar.minecraft.item.ArmourType;
import com.github.fnar.minecraft.item.ToolType;
import com.github.fnar.minecraft.item.WeaponType;
import greymerk.roguelike.treasure.loot.Quality;
import greymerk.roguelike.util.IWeighted;
import greymerk.roguelike.util.WeightedChoice;
import greymerk.roguelike.util.WeightedRandomizer;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;

public enum Equipment {
    SWORD,
    BOW,
    HELMET,
    CHEST,
    LEGS,
    FEET,
    PICK,
    AXE,
    SHOVEL,
    HOE;

    public static final Map<Integer, IWeighted<Quality>> equipmentQuality;

    public static Equipment random(Random rand) {
        int choice = rand.nextInt(Equipment.values().length);
        return Equipment.values()[choice];
    }

    public static Quality rollQuality(Random rand, int level) {
        return equipmentQuality.get(level).get(rand);
    }

    public static WeaponType asWeaponType(Equipment type) {
        switch (type) {
            case BOW: {
                return WeaponType.BOW;
            }
            case SWORD: {
                return WeaponType.SWORD;
            }
        }
        throw new IllegalArgumentException("Could not parse WeaponType from EquipmentType: " + (Object)((Object)type));
    }

    public ArmourType asArmourType() {
        switch (this) {
            case HELMET: {
                return ArmourType.HELMET;
            }
            case CHEST: {
                return ArmourType.CHESTPLATE;
            }
            case LEGS: {
                return ArmourType.LEGGINGS;
            }
            case FEET: {
                return ArmourType.BOOTS;
            }
        }
        return null;
    }

    public ToolType asToolType() {
        switch (this) {
            case PICK: {
                return ToolType.PICKAXE;
            }
            case AXE: {
                return ToolType.AXE;
            }
            case SHOVEL: {
                return ToolType.SHOVEL;
            }
            case HOE: {
                return ToolType.HOE;
            }
        }
        return null;
    }

    public static void loadQualityOddsTable() {
        for (int i = 0; i < 5; ++i) {
            WeightedRandomizer<Quality> qualities = new WeightedRandomizer<Quality>();
            switch (i) {
                case 0: {
                    qualities.add(new WeightedChoice<Quality>(Quality.WOOD, 70));
                    qualities.add(new WeightedChoice<Quality>(Quality.STONE, 20));
                    qualities.add(new WeightedChoice<Quality>(Quality.IRON, 5));
                    qualities.add(new WeightedChoice<Quality>(Quality.GOLD, 4));
                    qualities.add(new WeightedChoice<Quality>(Quality.DIAMOND, 1));
                    break;
                }
                case 1: {
                    qualities.add(new WeightedChoice<Quality>(Quality.WOOD, 50));
                    qualities.add(new WeightedChoice<Quality>(Quality.STONE, 30));
                    qualities.add(new WeightedChoice<Quality>(Quality.IRON, 15));
                    qualities.add(new WeightedChoice<Quality>(Quality.GOLD, 4));
                    qualities.add(new WeightedChoice<Quality>(Quality.DIAMOND, 1));
                    break;
                }
                case 2: {
                    qualities.add(new WeightedChoice<Quality>(Quality.WOOD, 30));
                    qualities.add(new WeightedChoice<Quality>(Quality.STONE, 50));
                    qualities.add(new WeightedChoice<Quality>(Quality.IRON, 25));
                    qualities.add(new WeightedChoice<Quality>(Quality.GOLD, 4));
                    qualities.add(new WeightedChoice<Quality>(Quality.DIAMOND, 1));
                    break;
                }
                case 3: {
                    qualities.add(new WeightedChoice<Quality>(Quality.WOOD, 20));
                    qualities.add(new WeightedChoice<Quality>(Quality.STONE, 30));
                    qualities.add(new WeightedChoice<Quality>(Quality.IRON, 35));
                    qualities.add(new WeightedChoice<Quality>(Quality.GOLD, 10));
                    qualities.add(new WeightedChoice<Quality>(Quality.DIAMOND, 5));
                    break;
                }
                case 4: {
                    qualities.add(new WeightedChoice<Quality>(Quality.WOOD, 5));
                    qualities.add(new WeightedChoice<Quality>(Quality.STONE, 20));
                    qualities.add(new WeightedChoice<Quality>(Quality.IRON, 50));
                    qualities.add(new WeightedChoice<Quality>(Quality.GOLD, 10));
                    qualities.add(new WeightedChoice<Quality>(Quality.DIAMOND, 15));
                }
            }
            equipmentQuality.put(i, qualities);
        }
    }

    static {
        equipmentQuality = new HashMap<Integer, IWeighted<Quality>>();
        Equipment.loadQualityOddsTable();
    }
}

