/*
 * Decompiled with CFR 0.152.
 */
package greymerk.roguelike.dungeon.towers;

import greymerk.roguelike.dungeon.towers.BumboTower;
import greymerk.roguelike.dungeon.towers.BunkerTower;
import greymerk.roguelike.dungeon.towers.EniTower;
import greymerk.roguelike.dungeon.towers.EthoTower;
import greymerk.roguelike.dungeon.towers.HoleTower;
import greymerk.roguelike.dungeon.towers.HouseTower;
import greymerk.roguelike.dungeon.towers.JungleTower;
import greymerk.roguelike.dungeon.towers.PyramidTower;
import greymerk.roguelike.dungeon.towers.RogueTower;
import greymerk.roguelike.dungeon.towers.RuinTower;
import greymerk.roguelike.dungeon.towers.Tower;
import greymerk.roguelike.dungeon.towers.TreeTower;
import greymerk.roguelike.dungeon.towers.VillagerHouseTower;
import greymerk.roguelike.dungeon.towers.WitchTower;
import greymerk.roguelike.theme.Theme;
import greymerk.roguelike.theme.Themes;
import greymerk.roguelike.worldgen.Coord;
import greymerk.roguelike.worldgen.WorldEditor;
import java.util.Random;

public enum TowerType {
    BUMBO,
    BUNKER,
    ENIKO,
    ETHO,
    HOLE,
    HOUSE,
    JUNGLE,
    PYRAMID,
    ROGUE,
    RUIN,
    TREE,
    VILLAGER_HOUSE,
    WITCH;


    public static Tower instantiate(TowerType type, WorldEditor worldEditor, Theme theme) {
        switch (type) {
            default: {
                return new RogueTower(worldEditor, theme);
            }
            case ENIKO: {
                return new EniTower(worldEditor, theme);
            }
            case ETHO: {
                return new EthoTower(worldEditor, theme);
            }
            case PYRAMID: {
                return new PyramidTower(worldEditor, theme);
            }
            case JUNGLE: {
                return new JungleTower(worldEditor, theme);
            }
            case WITCH: {
                return new WitchTower(worldEditor, theme);
            }
            case HOUSE: {
                return new HouseTower(worldEditor, theme);
            }
            case BUNKER: {
                return new BunkerTower(worldEditor, theme);
            }
            case RUIN: {
                return new RuinTower(worldEditor, theme);
            }
            case HOLE: {
                return new HoleTower(worldEditor, theme);
            }
            case TREE: {
                return new TreeTower(worldEditor, theme);
            }
            case BUMBO: {
                return new BumboTower(worldEditor, theme);
            }
            case VILLAGER_HOUSE: 
        }
        return new VillagerHouseTower(worldEditor, theme);
    }

    public static Themes getDefaultTheme(TowerType type) {
        switch (type) {
            case ETHO: {
                return Themes.ETHOTOWER;
            }
            case PYRAMID: {
                return Themes.PYRAMID;
            }
            case JUNGLE: {
                return Themes.JUNGLE;
            }
            case WITCH: {
                return Themes.DARKHALL;
            }
            case HOUSE: {
                return Themes.HOUSE;
            }
            case BUMBO: {
                return Themes.BUMBO;
            }
        }
        return Themes.OAK;
    }

    public static Coord getBaseCoord(WorldEditor editor, Coord origin) {
        Coord cursor = new Coord(origin.getX(), 128, origin.getZ());
        while (cursor.getY() > 60 && !editor.isValidGroundBlock(cursor)) {
            cursor.down();
        }
        cursor.up();
        int yOffset = cursor.getY() - origin.getY();
        if (yOffset < 14) {
            yOffset = 14;
        }
        return new Coord(origin.getX(), origin.getY() + yOffset, origin.getZ());
    }

    public static TowerType get(String name) throws Exception {
        if (!TowerType.contains(name.toUpperCase())) {
            throw new Exception("No such tower type: " + name);
        }
        return TowerType.valueOf(name.toUpperCase());
    }

    public static boolean contains(String name) {
        for (TowerType value : TowerType.values()) {
            if (!value.toString().equals(name)) continue;
            return true;
        }
        return false;
    }

    public static TowerType random(Random random) {
        TowerType[] values = TowerType.values();
        return values[random.nextInt(values.length)];
    }
}

