/*
 * Decompiled with CFR 0.152.
 */
package greymerk.roguelike.dungeon.settings;

import com.google.common.base.Charsets;
import com.google.common.collect.Lists;
import com.google.common.io.Files;
import greymerk.roguelike.config.RogueConfig;
import greymerk.roguelike.dungeon.settings.DungeonSettings;
import greymerk.roguelike.dungeon.settings.SettingIdentifier;
import greymerk.roguelike.dungeon.settings.SettingsContainer;
import greymerk.roguelike.util.WeightedChoice;
import greymerk.roguelike.util.WeightedRandomizer;
import greymerk.roguelike.worldgen.Coord;
import greymerk.roguelike.worldgen.WorldEditor;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import net.minecraft.client.Minecraft;
import org.apache.commons.io.FilenameUtils;

public class SettingsResolver {
    private final SettingsContainer settingsContainer;

    public SettingsResolver(SettingsContainer settingsContainer) {
        this.settingsContainer = settingsContainer;
    }

    public static SettingsResolver initSettingsResolver() throws Exception {
        File settingsDirectoryFile = new File("config/roguelike_dungeons/settings");
        if (settingsDirectoryFile.exists() && !settingsDirectoryFile.isDirectory()) {
            throw new Exception("Settings directory is a file");
        }
        if (!settingsDirectoryFile.exists()) {
            settingsDirectoryFile.mkdir();
        }
        Map<String, String> fileByName = SettingsResolver.collectSettingsFiles(settingsDirectoryFile);
        SettingsContainer settings = new SettingsContainer(fileByName);
        return new SettingsResolver(settings);
    }

    private static Map<String, String> collectSettingsFiles(File settingsDirectory) {
        List<File> files = SettingsResolver.listFilesRecursively(settingsDirectory);
        return SettingsResolver.mapContentByFilename(files);
    }

    private static List<File> listFilesRecursively(File settingsDirectory) {
        Object[] files = settingsDirectory.listFiles();
        return Optional.ofNullable(files).isPresent() ? Lists.newArrayList((Object[])files).stream().flatMap(file -> file.isDirectory() ? SettingsResolver.listFilesRecursively(file).stream() : Lists.newArrayList((Object[])new File[]{file}).stream()).filter(file -> FilenameUtils.getExtension((String)file.getName()).equals("json")).collect(Collectors.toList()) : Collections.emptyList();
    }

    private static Map<String, String> mapContentByFilename(List<File> files) {
        return files.stream().collect(Collectors.toMap(File::getAbsolutePath, SettingsResolver::getFileContent));
    }

    private static String getFileContent(File file) {
        try {
            return Files.toString((File)file, (Charset)Charsets.UTF_8);
        }
        catch (IOException e) {
            throw new RuntimeException("Error reading file : " + file.getName());
        }
    }

    public Optional<DungeonSettings> chooseDungeonSetting(WorldEditor editor, Coord coord) {
        Optional<DungeonSettings> customDungeon = this.chooseRandomCustomDungeonIfPossible(editor, coord);
        return customDungeon.isPresent() ? customDungeon : this.chooseOneBuiltinSettingAtRandom(editor, coord);
    }

    public DungeonSettings getByName(String name) {
        try {
            SettingIdentifier id = new SettingIdentifier(name);
            DungeonSettings dungeonSettings = this.settingsContainer.get(id);
            return this.processInheritance(dungeonSettings);
        }
        catch (Exception e) {
            Minecraft.func_71410_x().field_71439_g.func_71165_d(Arrays.toString(e.getStackTrace()));
            throw new RuntimeException(e);
        }
    }

    public DungeonSettings processInheritance(DungeonSettings dungeonSettings) {
        DungeonSettings accumulatedInheritedSettings = dungeonSettings.getInherit().stream().map(this.settingsContainer::get).map(this::processInheritance).reduce(new DungeonSettings(), (accumulation, toInherit) -> toInherit.inherit((DungeonSettings)accumulation));
        return dungeonSettings.inherit(accumulatedInheritedSettings);
    }

    private Optional<DungeonSettings> chooseOneBuiltinSettingAtRandom(WorldEditor editor, Coord coord) {
        if (!RogueConfig.SPAWNBUILTIN.getBoolean()) {
            return Optional.empty();
        }
        return this.chooseRandomValid(editor, coord, this.settingsContainer.getBuiltinSettings());
    }

    private Optional<DungeonSettings> chooseRandomCustomDungeonIfPossible(WorldEditor editor, Coord coord) {
        return this.chooseRandomValid(editor, coord, this.settingsContainer.getCustomSettings());
    }

    private Optional<DungeonSettings> chooseRandomValid(WorldEditor editor, Coord coord, Collection<DungeonSettings> settings) {
        List<DungeonSettings> inflatedSettings = settings.stream().map(this::processInheritance).filter(this.isValid(editor, coord)).collect(Collectors.toList());
        WeightedRandomizer<DungeonSettings> settingsRandomizer = this.newWeightedRandomizer(inflatedSettings);
        return Optional.ofNullable(settingsRandomizer.get(editor.getRandom()));
    }

    private Predicate<DungeonSettings> isValid(WorldEditor editor, Coord coord) {
        return setting -> setting.isExclusive() && setting.isValid(editor, coord);
    }

    private WeightedRandomizer<DungeonSettings> newWeightedRandomizer(List<DungeonSettings> dungeonSettings) {
        WeightedRandomizer<DungeonSettings> settingsRandomizer = new WeightedRandomizer<DungeonSettings>();
        dungeonSettings.stream().map(setting -> new WeightedChoice<DungeonSettings>((DungeonSettings)setting, setting.getCriteria().getWeight())).forEach(settingsRandomizer::add);
        return settingsRandomizer;
    }

    public String toString(String namespace) {
        return this.settingsContainer.getByNamespace(namespace).stream().map(DungeonSettings::getId).map(SettingIdentifier::toString).collect(Collectors.joining(" "));
    }

    public String toString() {
        return this.settingsContainer.toString();
    }
}

