/*
 * Decompiled with CFR 0.152.
 */
package c4.corpsecomplex.common.modules.inventory.helpers;

import c4.corpsecomplex.CorpseComplex;
import c4.corpsecomplex.common.modules.compatibility.enderio.EnderIOIntegration;
import c4.corpsecomplex.common.modules.inventory.InventoryModule;
import c4.corpsecomplex.common.modules.inventory.enchantment.EnchantmentModule;
import java.util.Map;
import java.util.Random;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.EnumDifficulty;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;

public final class DeathStackHelper {
    private static Random generator = new Random();

    private DeathStackHelper() {
    }

    public static ItemStack stackToStore(EntityPlayer player, ItemStack stack, boolean cfgStore) {
        return DeathStackHelper.stackToStore(player, stack, cfgStore, false);
    }

    public static ItemStack stackToStore(EntityPlayer player, ItemStack stack, boolean cfgStore, boolean isMainInventory) {
        int level;
        boolean store;
        boolean essential = DeathStackHelper.isEssential(stack);
        boolean cursed = !essential && DeathStackHelper.isCursed(stack);
        boolean bl = store = cfgStore && !cursed || essential;
        if (EnchantmentModule.registerEnchant && (level = EnchantmentHelper.func_77506_a((Enchantment)EnchantmentModule.soulbound, (ItemStack)stack)) != 0) {
            essential = DeathStackHelper.handleSoulbound(stack, level);
            boolean bl2 = cursed = !essential && cursed;
            if (!store && essential) {
                store = true;
            }
        }
        if (cursed && InventoryModule.destroyCursed) {
            DeathStackHelper.destroyStack(stack);
            return stack;
        }
        if (InventoryModule.dropLoss > 0.0 || InventoryModule.keptLoss > 0.0) {
            DeathStackHelper.loseDurability(player, stack, store);
        }
        if (InventoryModule.dropDrain > 0.0 || InventoryModule.keptDrain > 0.0) {
            DeathStackHelper.loseEnergy(stack, store);
        }
        if (stack.func_190926_b()) {
            return ItemStack.field_190927_a;
        }
        if (store) {
            if (!essential && InventoryModule.randomDrop > 0.0 && (isMainInventory || !InventoryModule.randomDropOnlyMain)) {
                int keepAmount = stack.func_190916_E();
                return stack.func_77979_a(keepAmount -= DeathStackHelper.randomlyDrop(stack));
            }
            ItemStack stack1 = stack.func_77946_l();
            stack.func_190920_e(0);
            return stack1;
        }
        return ItemStack.field_190927_a;
    }

    public static void destroyStack(ItemStack stack) {
        stack.func_190920_e(0);
    }

    public static int randomlyDrop(ItemStack stack) {
        int dropAmount = 0;
        for (int i = 0; i < stack.func_190916_E(); ++i) {
            if (!(generator.nextDouble() < InventoryModule.randomDrop)) continue;
            ++dropAmount;
        }
        return dropAmount;
    }

    public static void randomlyDestroy(ItemStack stack) {
        int destroyAmount = 0;
        for (int i = 0; i < stack.func_190916_E(); ++i) {
            if (!(generator.nextDouble() < InventoryModule.randomDestroy)) continue;
            ++destroyAmount;
        }
        stack.func_190918_g(destroyAmount);
    }

    public static void loseDurability(EntityPlayer player, ItemStack stack, boolean store) {
        if (!stack.func_77984_f()) {
            return;
        }
        int limit = InventoryModule.durabilityLossLimiter ? stack.func_77958_k() - stack.func_77952_i() - 1 : stack.func_77958_k();
        double actualLoss = 0.0;
        if (store) {
            if (InventoryModule.difficultyKeptLoss) {
                if (player.field_70170_p.func_175659_aa() == EnumDifficulty.EASY) {
                    actualLoss = InventoryModule.keptLossEasy;
                } else if (player.field_70170_p.func_175659_aa() == EnumDifficulty.NORMAL) {
                    actualLoss = InventoryModule.keptLossNormal;
                } else if (player.field_70170_p.func_175659_aa() == EnumDifficulty.HARD) {
                    actualLoss = InventoryModule.keptLossHard;
                }
            } else {
                actualLoss = InventoryModule.keptLoss;
            }
        } else if (InventoryModule.difficultyDropLoss) {
            if (player.field_70170_p.func_175659_aa() == EnumDifficulty.EASY) {
                actualLoss = InventoryModule.dropLossEasy;
            } else if (player.field_70170_p.func_175659_aa() == EnumDifficulty.NORMAL) {
                actualLoss = InventoryModule.dropLossNormal;
            } else if (player.field_70170_p.func_175659_aa() == EnumDifficulty.HARD) {
                actualLoss = InventoryModule.dropLossHard;
            }
        } else {
            actualLoss = InventoryModule.dropLoss;
        }
        int loss = (int)Math.round((double)stack.func_77958_k() * actualLoss);
        stack.func_77972_a(Math.min(loss, limit), (EntityLivingBase)player);
    }

    public static void loseEnergy(ItemStack stack, boolean store) {
        int energyExtracted;
        boolean hasUpgrade;
        IEnergyStorage energy = (IEnergyStorage)stack.getCapability(CapabilityEnergy.ENERGY, null);
        if (energy == null) {
            return;
        }
        boolean bl = hasUpgrade = CorpseComplex.isEnderIOLoaded && EnderIOIntegration.hasPowerUpgrade(stack);
        for (int energyToLose = store ? (int)Math.round((double)energy.getMaxEnergyStored() * InventoryModule.keptDrain) : (int)Math.round((double)energy.getMaxEnergyStored() * InventoryModule.dropDrain); energyToLose > 0 && energy.getEnergyStored() > 0; energyToLose -= energyExtracted) {
            int n = energyExtracted = hasUpgrade ? EnderIOIntegration.extractEnergy(stack, energyToLose, false) : energy.extractEnergy(energyToLose, false);
            if (energyExtracted == 0) break;
        }
    }

    public static boolean isEssential(ItemStack stack) {
        for (String s : InventoryModule.essentialItems) {
            ResourceLocation name = stack.func_77973_b().getRegistryName();
            if (name == null || !s.equals(name.toString())) continue;
            return true;
        }
        return false;
    }

    public static boolean isCursed(ItemStack stack) {
        if (EnchantmentHelper.func_190939_c((ItemStack)stack)) {
            return true;
        }
        for (String s : InventoryModule.cursedItems) {
            ResourceLocation name = stack.func_77973_b().getRegistryName();
            if (name == null || !s.equals(name.toString())) continue;
            return true;
        }
        return false;
    }

    public static boolean handleSoulbound(ItemStack stack, int level) {
        double savePercent = EnchantmentModule.baseSave + EnchantmentModule.extraPerLevel * (double)(level - 1);
        boolean activated = false;
        if (generator.nextDouble() < savePercent) {
            activated = true;
        }
        if (EnchantmentModule.levelDrop != 0.0 && activated) {
            if (generator.nextDouble() < EnchantmentModule.levelDrop) {
                level = Math.max(0, level - 1);
            }
            Map enchMap = EnchantmentHelper.func_82781_a((ItemStack)stack);
            enchMap.remove((Object)EnchantmentModule.soulbound);
            if (level > 0) {
                enchMap.put(EnchantmentModule.soulbound, level);
            }
            EnchantmentHelper.func_82782_a((Map)enchMap, (ItemStack)stack);
        }
        return activated;
    }
}

