/*
 * Decompiled with CFR 0.152.
 */
package org.jwaresoftware.mcmods.armorunder.item;

import java.util.List;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumAction;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.stats.StatList;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import org.jwaresoftware.mcmods.armorunder.ModInfo;
import org.jwaresoftware.mcmods.armorunder.ModItem;
import org.jwaresoftware.mcmods.armorunder.ModItems;
import org.jwaresoftware.mcmods.lib.Effects;
import org.jwaresoftware.mcmods.lib.ItemStacks;
import org.jwaresoftware.mcmods.lib.SharedGlue;
import org.jwaresoftware.mcmods.lib.capability.ITemperatureChangeable;
import org.jwaresoftware.mcmods.lib.impl.ItemSupport;

public final class GooPak
extends ModItem
implements ITemperatureChangeable {
    private static final String _NBT_USED_FLAG = ModInfo.rstring("Used");
    protected final ITemperatureChangeable.UsedEffect _type;

    private GooPak(String oid, ITemperatureChangeable.UsedEffect type) {
        super(oid);
        this._type = type;
        this.func_185043_a(new ResourceLocation("temperature"), ITemperatureChangeable.TemperaturePropertyGetter.forEither());
        this.autoregister();
    }

    public static final GooPak cooling() {
        return new GooPak("goopak_cool", ITemperatureChangeable.UsedEffect.COOLED);
    }

    public static final GooPak warming() {
        return new GooPak("goopak_heat", ITemperatureChangeable.UsedEffect.HEATED);
    }

    public ITemperatureChangeable.Category getTemperatureDelivery() {
        return ITemperatureChangeable.Category.CARRIED;
    }

    public final int getCoolDuration(ItemStack pak) {
        return this.getHeatDuration(pak);
    }

    public int getTemperatureModifier(ItemStack pak) {
        return 2;
    }

    public void func_77622_d(ItemStack pak, World world, EntityPlayer player) {
        ITemperatureChangeable.UsedEffect e = this.onCreateCheckBonusTemperature(pak);
        super.func_77622_d(pak, world, player);
        if (ITemperatureChangeable.UsedEffect.HEATED.equals((Object)e)) {
            this.setHeated(pak);
        } else if (ITemperatureChangeable.UsedEffect.COOLED.equals((Object)e)) {
            this.setCooled(pak);
        }
    }

    private boolean isUsed(ItemStack pak) {
        return pak.func_77942_o() && pak.func_77978_p().func_74764_b(_NBT_USED_FLAG);
    }

    private void markUsed(ItemStack pak) {
        ItemStacks.getTagCompoundNonNull((ItemStack)pak).func_74757_a(_NBT_USED_FLAG, true);
    }

    public boolean hasBonusTemperature(ItemStack pak) {
        return !this.isUsed(pak) && super.hasBonusTemperature(pak);
    }

    public int getItemStackLimit(ItemStack pak) {
        return this.hasBonusTemperature(pak) ? 1 : super.getItemStackLimit(pak);
    }

    private boolean canActivate(ItemStack pak) {
        if (pak.func_190926_b() || pak.func_190916_E() > 1) {
            return false;
        }
        return !this.hasBonusTemperature(pak);
    }

    public EnumAction func_77661_b(ItemStack pak) {
        return this.canActivate(pak) ? EnumAction.BOW : EnumAction.NONE;
    }

    public int func_77626_a(ItemStack pak) {
        return this.canActivate(pak) ? SharedGlue.SHORT_FOOD_CONSUME_DURATION() : 0;
    }

    public ActionResult<ItemStack> func_77659_a(World world, EntityPlayer player, EnumHand hand) {
        EnumActionResult result;
        ItemStack helditem = player.func_184586_b(hand);
        EnumActionResult enumActionResult = result = this.canActivate(helditem) ? EnumActionResult.SUCCESS : EnumActionResult.FAIL;
        if (result == EnumActionResult.SUCCESS) {
            player.func_184598_c(hand);
        } else {
            Effects.playUseItemFailedSound((World)world, (EntityPlayer)player);
        }
        return ActionResult.newResult((EnumActionResult)result, (Object)helditem);
    }

    public ItemStack func_77654_b(ItemStack pak, World world, EntityLivingBase entity) {
        ItemStack remaining = pak;
        EntityPlayer player = SharedGlue.getPlayerOrNull((Entity)entity);
        if (player != null) {
            ItemStack original = ItemStacks.copyItemStackSingle((ItemStack)pak);
            player.func_71029_a(StatList.func_188057_b((Item)this));
            remaining = this.onActivated(original, pak, world, player);
            ItemSupport.noteItemConsumed((EntityPlayer)player, (ItemStack)original);
        }
        return remaining;
    }

    private ItemStack onActivated(ItemStack original, ItemStack pak, World world, EntityPlayer player) {
        if (SharedGlue.isaServerWorld((IBlockAccess)world)) {
            if (ITemperatureChangeable.UsedEffect.HEATED.equals((Object)this._type)) {
                this.setHeated(pak);
            } else {
                this.setCooled(pak);
            }
        }
        return pak;
    }

    public void func_77663_a(ItemStack pak, World world, Entity holder, int slotindex, boolean selected) {
        EntityPlayer player;
        IItemHandler ih;
        if (!this.hasBonusTemperature(pak)) {
            return;
        }
        if (this.onUpdateTickBonusTemperature(pak, world, holder, -1, selected) && (ih = (IItemHandler)SharedGlue.getCapability((ICapabilityProvider)(player = (EntityPlayer)holder), (Capability)CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null)) != null) {
            for (int i = 0; i < ih.getSlots(); ++i) {
                ItemStack check = ih.getStackInSlot(i);
                if (pak != check) continue;
                this.markUsed(pak);
                check = ih.extractItem(i, pak.func_190916_E(), false);
                if (check.func_190926_b()) break;
                ItemStack spent = new ItemStack((Item)ModItems.spent_goopak);
                ih.insertItem(i, spent, false);
                ItemSupport.noteItemConsumed((EntityPlayer)player, (ItemStack)spent);
                break;
            }
        }
    }

    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        return slotChanged || !oldStack.func_77969_a(newStack);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack pak, World world, List<String> tooltip, ITooltipFlag flags) {
        if (!this.hasBonusTemperature(pak)) {
            super.func_77624_a(pak, world, tooltip, flags);
        } else {
            this.addBonusTemperatureInformation(pak, world, tooltip);
        }
    }
}

